package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.TransformationparametermappingCollectionRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "_importmapid_value", 
    "modifiedon", 
    "solutionid", 
    "targetentityname", 
    "_createdonbehalfby_value", 
    "ismanaged", 
    "_modifiedby_value", 
    "transformationtypename", 
    "transformationmappingid", 
    "overwritetime", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "introducedversion", 
    "_createdby_value", 
    "statuscode", 
    "statecode", 
    "processcode", 
    "sourceentityname", 
    "transformationmappingidunique"})
@JsonInclude(Include.NON_NULL)
public class Transformationmapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.transformationmapping";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_importmapid_value")
    protected UUID _importmapid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("targetentityname")
    protected String targetentityname;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("transformationtypename")
    protected String transformationtypename;

    @JsonProperty("transformationmappingid")
    protected UUID transformationmappingid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("sourceentityname")
    protected String sourceentityname;

    @JsonProperty("transformationmappingidunique")
    protected UUID transformationmappingidunique;

    protected Transformationmapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTransformationmapping() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private UUID _importmapid_value;
        private OffsetDateTime modifiedon;
        private UUID solutionid;
        private String targetentityname;
        private UUID _createdonbehalfby_value;
        private Boolean ismanaged;
        private UUID _modifiedby_value;
        private String transformationtypename;
        private UUID transformationmappingid;
        private OffsetDateTime overwritetime;
        private OffsetDateTime createdon;
        private UUID _modifiedonbehalfby_value;
        private String introducedversion;
        private UUID _createdby_value;
        private Integer statuscode;
        private Integer statecode;
        private Integer processcode;
        private String sourceentityname;
        private UUID transformationmappingidunique;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _importmapid_value(UUID _importmapid_value) {
            this._importmapid_value = _importmapid_value;
            this.changedFields = changedFields.add("_importmapid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder targetentityname(String targetentityname) {
            this.targetentityname = targetentityname;
            this.changedFields = changedFields.add("targetentityname");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder transformationtypename(String transformationtypename) {
            this.transformationtypename = transformationtypename;
            this.changedFields = changedFields.add("transformationtypename");
            return this;
        }

        public Builder transformationmappingid(UUID transformationmappingid) {
            this.transformationmappingid = transformationmappingid;
            this.changedFields = changedFields.add("transformationmappingid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder sourceentityname(String sourceentityname) {
            this.sourceentityname = sourceentityname;
            this.changedFields = changedFields.add("sourceentityname");
            return this;
        }

        public Builder transformationmappingidunique(UUID transformationmappingidunique) {
            this.transformationmappingidunique = transformationmappingidunique;
            this.changedFields = changedFields.add("transformationmappingidunique");
            return this;
        }

        public Transformationmapping build() {
            Transformationmapping _x = new Transformationmapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.transformationmapping";
            _x.componentstate = componentstate;
            _x._importmapid_value = _importmapid_value;
            _x.modifiedon = modifiedon;
            _x.solutionid = solutionid;
            _x.targetentityname = targetentityname;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.ismanaged = ismanaged;
            _x._modifiedby_value = _modifiedby_value;
            _x.transformationtypename = transformationtypename;
            _x.transformationmappingid = transformationmappingid;
            _x.overwritetime = overwritetime;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.introducedversion = introducedversion;
            _x._createdby_value = _createdby_value;
            _x.statuscode = statuscode;
            _x.statecode = statecode;
            _x.processcode = processcode;
            _x.sourceentityname = sourceentityname;
            _x.transformationmappingidunique = transformationmappingidunique;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && transformationmappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(transformationmappingid, UUID.class));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Transformationmapping withComponentstate(Integer componentstate) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_importmapid_value")
    @JsonIgnore
    public Optional<UUID> get_importmapid_value() {
        return Optional.ofNullable(_importmapid_value);
    }

    public Transformationmapping with_importmapid_value(UUID _importmapid_value) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("_importmapid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x._importmapid_value = _importmapid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Transformationmapping withModifiedon(OffsetDateTime modifiedon) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Transformationmapping withSolutionid(UUID solutionid) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="targetentityname")
    @JsonIgnore
    public Optional<String> getTargetentityname() {
        return Optional.ofNullable(targetentityname);
    }

    public Transformationmapping withTargetentityname(String targetentityname) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("targetentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.targetentityname = targetentityname;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Transformationmapping with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Transformationmapping withIsmanaged(Boolean ismanaged) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Transformationmapping with_modifiedby_value(UUID _modifiedby_value) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="transformationtypename")
    @JsonIgnore
    public Optional<String> getTransformationtypename() {
        return Optional.ofNullable(transformationtypename);
    }

    public Transformationmapping withTransformationtypename(String transformationtypename) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("transformationtypename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.transformationtypename = transformationtypename;
        return _x;
    }

    @Property(name="transformationmappingid")
    @JsonIgnore
    public Optional<UUID> getTransformationmappingid() {
        return Optional.ofNullable(transformationmappingid);
    }

    public Transformationmapping withTransformationmappingid(UUID transformationmappingid) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("transformationmappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.transformationmappingid = transformationmappingid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Transformationmapping withOverwritetime(OffsetDateTime overwritetime) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Transformationmapping withCreatedon(OffsetDateTime createdon) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Transformationmapping with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Transformationmapping withIntroducedversion(String introducedversion) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Transformationmapping with_createdby_value(UUID _createdby_value) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Transformationmapping withStatuscode(Integer statuscode) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Transformationmapping withStatecode(Integer statecode) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Transformationmapping withProcesscode(Integer processcode) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="sourceentityname")
    @JsonIgnore
    public Optional<String> getSourceentityname() {
        return Optional.ofNullable(sourceentityname);
    }

    public Transformationmapping withSourceentityname(String sourceentityname) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("sourceentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.sourceentityname = sourceentityname;
        return _x;
    }

    @Property(name="transformationmappingidunique")
    @JsonIgnore
    public Optional<UUID> getTransformationmappingidunique() {
        return Optional.ofNullable(transformationmappingidunique);
    }

    public Transformationmapping withTransformationmappingidunique(UUID transformationmappingidunique) {
        Transformationmapping _x = _copy();
        _x.changedFields = changedFields.add("transformationmappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.transformationmapping");
        _x.transformationmappingidunique = transformationmappingidunique;
        return _x;
    }

    public Transformationmapping withUnmappedField(String name, Object value) {
        Transformationmapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="TransformationParameterMapping_TransformationMapping")
    @JsonIgnore
    public TransformationparametermappingCollectionRequest getTransformationParameterMapping_TransformationMapping() {
        return new TransformationparametermappingCollectionRequest(
                        contextPath.addSegment("TransformationParameterMapping_TransformationMapping"), RequestHelper.getValue(unmappedFields, "TransformationParameterMapping_TransformationMapping"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="importmapid")
    @JsonIgnore
    public ImportmapRequest getImportmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), RequestHelper.getValue(unmappedFields, "importmapid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Transformationmapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Transformationmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Transformationmapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Transformationmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Transformationmapping _copy() {
        Transformationmapping _x = new Transformationmapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x._importmapid_value = _importmapid_value;
        _x.modifiedon = modifiedon;
        _x.solutionid = solutionid;
        _x.targetentityname = targetentityname;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.ismanaged = ismanaged;
        _x._modifiedby_value = _modifiedby_value;
        _x.transformationtypename = transformationtypename;
        _x.transformationmappingid = transformationmappingid;
        _x.overwritetime = overwritetime;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.introducedversion = introducedversion;
        _x._createdby_value = _createdby_value;
        _x.statuscode = statuscode;
        _x.statecode = statecode;
        _x.processcode = processcode;
        _x.sourceentityname = sourceentityname;
        _x.transformationmappingidunique = transformationmappingidunique;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Transformationmapping[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_importmapid_value=");
        b.append(this._importmapid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("targetentityname=");
        b.append(this.targetentityname);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("transformationtypename=");
        b.append(this.transformationtypename);
        b.append(", ");
        b.append("transformationmappingid=");
        b.append(this.transformationmappingid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("sourceentityname=");
        b.append(this.sourceentityname);
        b.append(", ");
        b.append("transformationmappingidunique=");
        b.append(this.transformationmappingidunique);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
