package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "systemusersyncmappingprofileid", 
    "syncattributemappingprofileid", 
    "versionnumber", 
    "systemuserid"})
@JsonInclude(Include.NON_NULL)
public class Systemusersyncmappingprofiles extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.systemusersyncmappingprofiles";
    }

    @JsonProperty("systemusersyncmappingprofileid")
    protected UUID systemusersyncmappingprofileid;

    @JsonProperty("syncattributemappingprofileid")
    protected UUID syncattributemappingprofileid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("systemuserid")
    protected UUID systemuserid;

    protected Systemusersyncmappingprofiles() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSystemusersyncmappingprofiles() {
        return new Builder();
    }

    public static final class Builder {
        private UUID systemusersyncmappingprofileid;
        private UUID syncattributemappingprofileid;
        private Long versionnumber;
        private UUID systemuserid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder systemusersyncmappingprofileid(UUID systemusersyncmappingprofileid) {
            this.systemusersyncmappingprofileid = systemusersyncmappingprofileid;
            this.changedFields = changedFields.add("systemusersyncmappingprofileid");
            return this;
        }

        public Builder syncattributemappingprofileid(UUID syncattributemappingprofileid) {
            this.syncattributemappingprofileid = syncattributemappingprofileid;
            this.changedFields = changedFields.add("syncattributemappingprofileid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder systemuserid(UUID systemuserid) {
            this.systemuserid = systemuserid;
            this.changedFields = changedFields.add("systemuserid");
            return this;
        }

        public Systemusersyncmappingprofiles build() {
            Systemusersyncmappingprofiles _x = new Systemusersyncmappingprofiles();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.systemusersyncmappingprofiles";
            _x.systemusersyncmappingprofileid = systemusersyncmappingprofileid;
            _x.syncattributemappingprofileid = syncattributemappingprofileid;
            _x.versionnumber = versionnumber;
            _x.systemuserid = systemuserid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && systemusersyncmappingprofileid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(systemusersyncmappingprofileid, UUID.class));
        }
    }

    @Property(name="systemusersyncmappingprofileid")
    @JsonIgnore
    public Optional<UUID> getSystemusersyncmappingprofileid() {
        return Optional.ofNullable(systemusersyncmappingprofileid);
    }

    public Systemusersyncmappingprofiles withSystemusersyncmappingprofileid(UUID systemusersyncmappingprofileid) {
        Systemusersyncmappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("systemusersyncmappingprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemusersyncmappingprofiles");
        _x.systemusersyncmappingprofileid = systemusersyncmappingprofileid;
        return _x;
    }

    @Property(name="syncattributemappingprofileid")
    @JsonIgnore
    public Optional<UUID> getSyncattributemappingprofileid() {
        return Optional.ofNullable(syncattributemappingprofileid);
    }

    public Systemusersyncmappingprofiles withSyncattributemappingprofileid(UUID syncattributemappingprofileid) {
        Systemusersyncmappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("syncattributemappingprofileid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemusersyncmappingprofiles");
        _x.syncattributemappingprofileid = syncattributemappingprofileid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Systemusersyncmappingprofiles withVersionnumber(Long versionnumber) {
        Systemusersyncmappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemusersyncmappingprofiles");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="systemuserid")
    @JsonIgnore
    public Optional<UUID> getSystemuserid() {
        return Optional.ofNullable(systemuserid);
    }

    public Systemusersyncmappingprofiles withSystemuserid(UUID systemuserid) {
        Systemusersyncmappingprofiles _x = _copy();
        _x.changedFields = changedFields.add("systemuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.systemusersyncmappingprofiles");
        _x.systemuserid = systemuserid;
        return _x;
    }

    public Systemusersyncmappingprofiles withUnmappedField(String name, Object value) {
        Systemusersyncmappingprofiles _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Systemusersyncmappingprofiles patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Systemusersyncmappingprofiles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Systemusersyncmappingprofiles put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Systemusersyncmappingprofiles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Systemusersyncmappingprofiles _copy() {
        Systemusersyncmappingprofiles _x = new Systemusersyncmappingprofiles();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.systemusersyncmappingprofileid = systemusersyncmappingprofileid;
        _x.syncattributemappingprofileid = syncattributemappingprofileid;
        _x.versionnumber = versionnumber;
        _x.systemuserid = systemuserid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Systemusersyncmappingprofiles[");
        b.append("systemusersyncmappingprofileid=");
        b.append(this.systemusersyncmappingprofileid);
        b.append(", ");
        b.append("syncattributemappingprofileid=");
        b.append(this.syncattributemappingprofileid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("systemuserid=");
        b.append(this.systemuserid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
