package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "subscriptionid", 
    "fullsyncrequired", 
    "objecttypecode"})
@JsonInclude(Include.NON_NULL)
public class Subscriptionstatisticsoffline extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.subscriptionstatisticsoffline";
    }

    @JsonProperty("subscriptionid")
    protected UUID subscriptionid;

    @JsonProperty("fullsyncrequired")
    protected Boolean fullsyncrequired;

    @JsonProperty("objecttypecode")
    protected Integer objecttypecode;

    protected Subscriptionstatisticsoffline() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSubscriptionstatisticsoffline() {
        return new Builder();
    }

    public static final class Builder {
        private UUID subscriptionid;
        private Boolean fullsyncrequired;
        private Integer objecttypecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder subscriptionid(UUID subscriptionid) {
            this.subscriptionid = subscriptionid;
            this.changedFields = changedFields.add("subscriptionid");
            return this;
        }

        public Builder fullsyncrequired(Boolean fullsyncrequired) {
            this.fullsyncrequired = fullsyncrequired;
            this.changedFields = changedFields.add("fullsyncrequired");
            return this;
        }

        public Builder objecttypecode(Integer objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Subscriptionstatisticsoffline build() {
            Subscriptionstatisticsoffline _x = new Subscriptionstatisticsoffline();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.subscriptionstatisticsoffline";
            _x.subscriptionid = subscriptionid;
            _x.fullsyncrequired = fullsyncrequired;
            _x.objecttypecode = objecttypecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && subscriptionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(subscriptionid, UUID.class));
        }
    }

    @Property(name="subscriptionid")
    @JsonIgnore
    public Optional<UUID> getSubscriptionid() {
        return Optional.ofNullable(subscriptionid);
    }

    public Subscriptionstatisticsoffline withSubscriptionid(UUID subscriptionid) {
        Subscriptionstatisticsoffline _x = _copy();
        _x.changedFields = changedFields.add("subscriptionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionstatisticsoffline");
        _x.subscriptionid = subscriptionid;
        return _x;
    }

    @Property(name="fullsyncrequired")
    @JsonIgnore
    public Optional<Boolean> getFullsyncrequired() {
        return Optional.ofNullable(fullsyncrequired);
    }

    public Subscriptionstatisticsoffline withFullsyncrequired(Boolean fullsyncrequired) {
        Subscriptionstatisticsoffline _x = _copy();
        _x.changedFields = changedFields.add("fullsyncrequired");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionstatisticsoffline");
        _x.fullsyncrequired = fullsyncrequired;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<Integer> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Subscriptionstatisticsoffline withObjecttypecode(Integer objecttypecode) {
        Subscriptionstatisticsoffline _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.subscriptionstatisticsoffline");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    public Subscriptionstatisticsoffline withUnmappedField(String name, Object value) {
        Subscriptionstatisticsoffline _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscriptionstatisticsoffline patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Subscriptionstatisticsoffline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Subscriptionstatisticsoffline put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Subscriptionstatisticsoffline _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Subscriptionstatisticsoffline _copy() {
        Subscriptionstatisticsoffline _x = new Subscriptionstatisticsoffline();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.subscriptionid = subscriptionid;
        _x.fullsyncrequired = fullsyncrequired;
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Subscriptionstatisticsoffline[");
        b.append("subscriptionid=");
        b.append(this.subscriptionid);
        b.append(", ");
        b.append("fullsyncrequired=");
        b.append(this.fullsyncrequired);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
