package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.RolePrivilege;
import microsoft.dynamics.crm.entity.collection.request.ApplicationuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmoduleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrivilegeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateRequest;
import microsoft.dynamics.crm.entity.request.SolutionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "importsequencenumber", 
    "solutionid", 
    "_roletemplateid_value", 
    "_parentroleid_value", 
    "modifiedon", 
    "_modifiedby_value", 
    "_modifiedonbehalfby_value", 
    "organizationid", 
    "name", 
    "canbedeleted", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "_businessunitid_value", 
    "roleid", 
    "overwritetime", 
    "ismanaged", 
    "componentstate", 
    "iscustomizable", 
    "_parentrootroleid_value", 
    "roleidunique", 
    "isinherited", 
    "overriddencreatedon", 
    "createdon", 
    "versionnumber"})
@JsonInclude(Include.NON_NULL)
public class Role extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.role";
    }

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("_roletemplateid_value")
    protected UUID _roletemplateid_value;

    @JsonProperty("_parentroleid_value")
    protected UUID _parentroleid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("organizationid")
    protected UUID organizationid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("canbedeleted")
    protected BooleanManagedProperty canbedeleted;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_businessunitid_value")
    protected UUID _businessunitid_value;

    @JsonProperty("roleid")
    protected UUID roleid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_parentrootroleid_value")
    protected UUID _parentrootroleid_value;

    @JsonProperty("roleidunique")
    protected UUID roleidunique;

    @JsonProperty("isinherited")
    protected Integer isinherited;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    protected Role() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRole() {
        return new Builder();
    }

    public static final class Builder {
        private Integer importsequencenumber;
        private UUID solutionid;
        private UUID _roletemplateid_value;
        private UUID _parentroleid_value;
        private OffsetDateTime modifiedon;
        private UUID _modifiedby_value;
        private UUID _modifiedonbehalfby_value;
        private UUID organizationid;
        private String name;
        private BooleanManagedProperty canbedeleted;
        private UUID _createdonbehalfby_value;
        private UUID _createdby_value;
        private UUID _businessunitid_value;
        private UUID roleid;
        private OffsetDateTime overwritetime;
        private Boolean ismanaged;
        private Integer componentstate;
        private BooleanManagedProperty iscustomizable;
        private UUID _parentrootroleid_value;
        private UUID roleidunique;
        private Integer isinherited;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime createdon;
        private Long versionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _roletemplateid_value(UUID _roletemplateid_value) {
            this._roletemplateid_value = _roletemplateid_value;
            this.changedFields = changedFields.add("_roletemplateid_value");
            return this;
        }

        public Builder _parentroleid_value(UUID _parentroleid_value) {
            this._parentroleid_value = _parentroleid_value;
            this.changedFields = changedFields.add("_parentroleid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder organizationid(UUID organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder canbedeleted(BooleanManagedProperty canbedeleted) {
            this.canbedeleted = canbedeleted;
            this.changedFields = changedFields.add("canbedeleted");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _businessunitid_value(UUID _businessunitid_value) {
            this._businessunitid_value = _businessunitid_value;
            this.changedFields = changedFields.add("_businessunitid_value");
            return this;
        }

        public Builder roleid(UUID roleid) {
            this.roleid = roleid;
            this.changedFields = changedFields.add("roleid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _parentrootroleid_value(UUID _parentrootroleid_value) {
            this._parentrootroleid_value = _parentrootroleid_value;
            this.changedFields = changedFields.add("_parentrootroleid_value");
            return this;
        }

        public Builder roleidunique(UUID roleidunique) {
            this.roleidunique = roleidunique;
            this.changedFields = changedFields.add("roleidunique");
            return this;
        }

        public Builder isinherited(Integer isinherited) {
            this.isinherited = isinherited;
            this.changedFields = changedFields.add("isinherited");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Role build() {
            Role _x = new Role();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.role";
            _x.importsequencenumber = importsequencenumber;
            _x.solutionid = solutionid;
            _x._roletemplateid_value = _roletemplateid_value;
            _x._parentroleid_value = _parentroleid_value;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.organizationid = organizationid;
            _x.name = name;
            _x.canbedeleted = canbedeleted;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x._businessunitid_value = _businessunitid_value;
            _x.roleid = roleid;
            _x.overwritetime = overwritetime;
            _x.ismanaged = ismanaged;
            _x.componentstate = componentstate;
            _x.iscustomizable = iscustomizable;
            _x._parentrootroleid_value = _parentrootroleid_value;
            _x.roleidunique = roleidunique;
            _x.isinherited = isinherited;
            _x.overriddencreatedon = overriddencreatedon;
            _x.createdon = createdon;
            _x.versionnumber = versionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && roleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(roleid, UUID.class));
        }
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Role withImportsequencenumber(Integer importsequencenumber) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Role withSolutionid(UUID solutionid) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_roletemplateid_value")
    @JsonIgnore
    public Optional<UUID> get_roletemplateid_value() {
        return Optional.ofNullable(_roletemplateid_value);
    }

    public Role with_roletemplateid_value(UUID _roletemplateid_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_roletemplateid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._roletemplateid_value = _roletemplateid_value;
        return _x;
    }

    @Property(name="_parentroleid_value")
    @JsonIgnore
    public Optional<UUID> get_parentroleid_value() {
        return Optional.ofNullable(_parentroleid_value);
    }

    public Role with_parentroleid_value(UUID _parentroleid_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_parentroleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._parentroleid_value = _parentroleid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Role withModifiedon(OffsetDateTime modifiedon) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Role with_modifiedby_value(UUID _modifiedby_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Role with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<UUID> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Role withOrganizationid(UUID organizationid) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Role withName(String name) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.name = name;
        return _x;
    }

    @Property(name="canbedeleted")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getCanbedeleted() {
        return Optional.ofNullable(canbedeleted);
    }

    public Role withCanbedeleted(BooleanManagedProperty canbedeleted) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("canbedeleted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.canbedeleted = canbedeleted;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Role with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Role with_createdby_value(UUID _createdby_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_businessunitid_value")
    @JsonIgnore
    public Optional<UUID> get_businessunitid_value() {
        return Optional.ofNullable(_businessunitid_value);
    }

    public Role with_businessunitid_value(UUID _businessunitid_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_businessunitid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._businessunitid_value = _businessunitid_value;
        return _x;
    }

    @Property(name="roleid")
    @JsonIgnore
    public Optional<UUID> getRoleid() {
        return Optional.ofNullable(roleid);
    }

    public Role withRoleid(UUID roleid) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("roleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.roleid = roleid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Role withOverwritetime(OffsetDateTime overwritetime) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Role withIsmanaged(Boolean ismanaged) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Role withComponentstate(Integer componentstate) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Role withIscustomizable(BooleanManagedProperty iscustomizable) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_parentrootroleid_value")
    @JsonIgnore
    public Optional<UUID> get_parentrootroleid_value() {
        return Optional.ofNullable(_parentrootroleid_value);
    }

    public Role with_parentrootroleid_value(UUID _parentrootroleid_value) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("_parentrootroleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x._parentrootroleid_value = _parentrootroleid_value;
        return _x;
    }

    @Property(name="roleidunique")
    @JsonIgnore
    public Optional<UUID> getRoleidunique() {
        return Optional.ofNullable(roleidunique);
    }

    public Role withRoleidunique(UUID roleidunique) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("roleidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.roleidunique = roleidunique;
        return _x;
    }

    @Property(name="isinherited")
    @JsonIgnore
    public Optional<Integer> getIsinherited() {
        return Optional.ofNullable(isinherited);
    }

    public Role withIsinherited(Integer isinherited) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("isinherited");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.isinherited = isinherited;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Role withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Role withCreatedon(OffsetDateTime createdon) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Role withVersionnumber(Long versionnumber) {
        Role _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.role");
        _x.versionnumber = versionnumber;
        return _x;
    }

    public Role withUnmappedField(String name, Object value) {
        Role _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="systemuserroles_association")
    @JsonIgnore
    public SystemuserCollectionRequest getSystemuserroles_association() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("systemuserroles_association"), RequestHelper.getValue(unmappedFields, "systemuserroles_association"));
    }

    @NavigationProperty(name="roleprivileges_association")
    @JsonIgnore
    public PrivilegeCollectionRequest getRoleprivileges_association() {
        return new PrivilegeCollectionRequest(
                        contextPath.addSegment("roleprivileges_association"), RequestHelper.getValue(unmappedFields, "roleprivileges_association"));
    }

    @NavigationProperty(name="appmoduleroles_association")
    @JsonIgnore
    public AppmoduleCollectionRequest getAppmoduleroles_association() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("appmoduleroles_association"), RequestHelper.getValue(unmappedFields, "appmoduleroles_association"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="parentroleid")
    @JsonIgnore
    public RoleRequest getParentroleid() {
        return new RoleRequest(contextPath.addSegment("parentroleid"), RequestHelper.getValue(unmappedFields, "parentroleid"));
    }

    @NavigationProperty(name="role_parent_role")
    @JsonIgnore
    public RoleCollectionRequest getRole_parent_role() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("role_parent_role"), RequestHelper.getValue(unmappedFields, "role_parent_role"));
    }

    @NavigationProperty(name="businessunitid")
    @JsonIgnore
    public BusinessunitRequest getBusinessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), RequestHelper.getValue(unmappedFields, "businessunitid"));
    }

    @NavigationProperty(name="roletemplateid")
    @JsonIgnore
    public RoletemplateRequest getRoletemplateid() {
        return new RoletemplateRequest(contextPath.addSegment("roletemplateid"), RequestHelper.getValue(unmappedFields, "roletemplateid"));
    }

    @NavigationProperty(name="Role_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getRole_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Role_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Role_AsyncOperations"));
    }

    @NavigationProperty(name="Role_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getRole_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Role_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Role_BulkDeleteFailures"));
    }

    @NavigationProperty(name="organizationid_organization")
    @JsonIgnore
    public OrganizationRequest getOrganizationid_organization() {
        return new OrganizationRequest(contextPath.addSegment("organizationid_organization"), RequestHelper.getValue(unmappedFields, "organizationid_organization"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="teamroles_association")
    @JsonIgnore
    public TeamCollectionRequest getTeamroles_association() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("teamroles_association"), RequestHelper.getValue(unmappedFields, "teamroles_association"));
    }

    @NavigationProperty(name="parentrootroleid")
    @JsonIgnore
    public RoleRequest getParentrootroleid() {
        return new RoleRequest(contextPath.addSegment("parentrootroleid"), RequestHelper.getValue(unmappedFields, "parentrootroleid"));
    }

    @NavigationProperty(name="role_parent_root_role")
    @JsonIgnore
    public RoleCollectionRequest getRole_parent_root_role() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("role_parent_root_role"), RequestHelper.getValue(unmappedFields, "role_parent_root_role"));
    }

    @NavigationProperty(name="Role_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getRole_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Role_SyncErrors"), RequestHelper.getValue(unmappedFields, "Role_SyncErrors"));
    }

    @NavigationProperty(name="solution_role")
    @JsonIgnore
    public SolutionRequest getSolution_role() {
        return new SolutionRequest(contextPath.addSegment("solution_role"), RequestHelper.getValue(unmappedFields, "solution_role"));
    }

    @NavigationProperty(name="applicationuserrole")
    @JsonIgnore
    public ApplicationuserCollectionRequest getApplicationuserrole() {
        return new ApplicationuserCollectionRequest(
                        contextPath.addSegment("applicationuserrole"), RequestHelper.getValue(unmappedFields, "applicationuserrole"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Role patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Role _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Role put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Role _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Role _copy() {
        Role _x = new Role();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.importsequencenumber = importsequencenumber;
        _x.solutionid = solutionid;
        _x._roletemplateid_value = _roletemplateid_value;
        _x._parentroleid_value = _parentroleid_value;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.organizationid = organizationid;
        _x.name = name;
        _x.canbedeleted = canbedeleted;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x._businessunitid_value = _businessunitid_value;
        _x.roleid = roleid;
        _x.overwritetime = overwritetime;
        _x.ismanaged = ismanaged;
        _x.componentstate = componentstate;
        _x.iscustomizable = iscustomizable;
        _x._parentrootroleid_value = _parentrootroleid_value;
        _x.roleidunique = roleidunique;
        _x.isinherited = isinherited;
        _x.overriddencreatedon = overriddencreatedon;
        _x.createdon = createdon;
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Action(name = "AddPrivilegesRole")
    @JsonIgnore
    public ActionRequestNoReturn addPrivilegesRole(List<RolePrivilege> privileges) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Privileges", "Collection(Microsoft.Dynamics.CRM.RolePrivilege)", privileges)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddPrivilegesRole"), _parameters);
    }

    @Action(name = "RemovePrivilegeRole")
    @JsonIgnore
    public ActionRequestNoReturn removePrivilegeRole(Privilege privilege) {
        Preconditions.checkNotNull(privilege, "privilege cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Privilege", "Microsoft.Dynamics.CRM.privilege", privilege)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemovePrivilegeRole"), _parameters);
    }

    @Action(name = "ReplacePrivilegesRole")
    @JsonIgnore
    public ActionRequestNoReturn replacePrivilegesRole(List<RolePrivilege> privileges) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Privileges", "Collection(Microsoft.Dynamics.CRM.RolePrivilege)", privileges)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReplacePrivilegesRole"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Role[");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_roletemplateid_value=");
        b.append(this._roletemplateid_value);
        b.append(", ");
        b.append("_parentroleid_value=");
        b.append(this._parentroleid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("canbedeleted=");
        b.append(this.canbedeleted);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_businessunitid_value=");
        b.append(this._businessunitid_value);
        b.append(", ");
        b.append("roleid=");
        b.append(this.roleid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_parentrootroleid_value=");
        b.append(this._parentrootroleid_value);
        b.append(", ");
        b.append("roleidunique=");
        b.append(this.roleidunique);
        b.append(", ");
        b.append("isinherited=");
        b.append(this.isinherited);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
