package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AttributeRequest;
import microsoft.dynamics.crm.entity.request.RelationshipRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "ismanaged", 
    "_referencedattributeid_value", 
    "name", 
    "overwritetime", 
    "relationshipattributeid", 
    "iscustomizable", 
    "componentidunique", 
    "solutionid", 
    "_relationshipid_value", 
    "_referencingattributeid_value"})
@JsonInclude(Include.NON_NULL)
public class Relationshipattribute extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.relationshipattribute";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_referencedattributeid_value")
    protected UUID _referencedattributeid_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("relationshipattributeid")
    protected UUID relationshipattributeid;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("_relationshipid_value")
    protected UUID _relationshipid_value;

    @JsonProperty("_referencingattributeid_value")
    protected UUID _referencingattributeid_value;

    protected Relationshipattribute() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRelationshipattribute() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private Boolean ismanaged;
        private UUID _referencedattributeid_value;
        private String name;
        private OffsetDateTime overwritetime;
        private UUID relationshipattributeid;
        private BooleanManagedProperty iscustomizable;
        private UUID componentidunique;
        private UUID solutionid;
        private UUID _relationshipid_value;
        private UUID _referencingattributeid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _referencedattributeid_value(UUID _referencedattributeid_value) {
            this._referencedattributeid_value = _referencedattributeid_value;
            this.changedFields = changedFields.add("_referencedattributeid_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder relationshipattributeid(UUID relationshipattributeid) {
            this.relationshipattributeid = relationshipattributeid;
            this.changedFields = changedFields.add("relationshipattributeid");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _relationshipid_value(UUID _relationshipid_value) {
            this._relationshipid_value = _relationshipid_value;
            this.changedFields = changedFields.add("_relationshipid_value");
            return this;
        }

        public Builder _referencingattributeid_value(UUID _referencingattributeid_value) {
            this._referencingattributeid_value = _referencingattributeid_value;
            this.changedFields = changedFields.add("_referencingattributeid_value");
            return this;
        }

        public Relationshipattribute build() {
            Relationshipattribute _x = new Relationshipattribute();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.relationshipattribute";
            _x.componentstate = componentstate;
            _x.ismanaged = ismanaged;
            _x._referencedattributeid_value = _referencedattributeid_value;
            _x.name = name;
            _x.overwritetime = overwritetime;
            _x.relationshipattributeid = relationshipattributeid;
            _x.iscustomizable = iscustomizable;
            _x.componentidunique = componentidunique;
            _x.solutionid = solutionid;
            _x._relationshipid_value = _relationshipid_value;
            _x._referencingattributeid_value = _referencingattributeid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && relationshipattributeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(relationshipattributeid, UUID.class));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Relationshipattribute withComponentstate(Integer componentstate) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Relationshipattribute withIsmanaged(Boolean ismanaged) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_referencedattributeid_value")
    @JsonIgnore
    public Optional<UUID> get_referencedattributeid_value() {
        return Optional.ofNullable(_referencedattributeid_value);
    }

    public Relationshipattribute with_referencedattributeid_value(UUID _referencedattributeid_value) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("_referencedattributeid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x._referencedattributeid_value = _referencedattributeid_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Relationshipattribute withName(String name) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.name = name;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Relationshipattribute withOverwritetime(OffsetDateTime overwritetime) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="relationshipattributeid")
    @JsonIgnore
    public Optional<UUID> getRelationshipattributeid() {
        return Optional.ofNullable(relationshipattributeid);
    }

    public Relationshipattribute withRelationshipattributeid(UUID relationshipattributeid) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("relationshipattributeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.relationshipattributeid = relationshipattributeid;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Relationshipattribute withIscustomizable(BooleanManagedProperty iscustomizable) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Relationshipattribute withComponentidunique(UUID componentidunique) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Relationshipattribute withSolutionid(UUID solutionid) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_relationshipid_value")
    @JsonIgnore
    public Optional<UUID> get_relationshipid_value() {
        return Optional.ofNullable(_relationshipid_value);
    }

    public Relationshipattribute with_relationshipid_value(UUID _relationshipid_value) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("_relationshipid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x._relationshipid_value = _relationshipid_value;
        return _x;
    }

    @Property(name="_referencingattributeid_value")
    @JsonIgnore
    public Optional<UUID> get_referencingattributeid_value() {
        return Optional.ofNullable(_referencingattributeid_value);
    }

    public Relationshipattribute with_referencingattributeid_value(UUID _referencingattributeid_value) {
        Relationshipattribute _x = _copy();
        _x.changedFields = changedFields.add("_referencingattributeid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.relationshipattribute");
        _x._referencingattributeid_value = _referencingattributeid_value;
        return _x;
    }

    public Relationshipattribute withUnmappedField(String name, Object value) {
        Relationshipattribute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="relationshipattribute_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getRelationshipattribute_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("relationshipattribute_SyncErrors"), RequestHelper.getValue(unmappedFields, "relationshipattribute_SyncErrors"));
    }

    @NavigationProperty(name="relationshipattribute_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getRelationshipattribute_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("relationshipattribute_AsyncOperations"), RequestHelper.getValue(unmappedFields, "relationshipattribute_AsyncOperations"));
    }

    @NavigationProperty(name="relationshipattribute_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getRelationshipattribute_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("relationshipattribute_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "relationshipattribute_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="relationshipattribute_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getRelationshipattribute_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("relationshipattribute_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "relationshipattribute_BulkDeleteFailures"));
    }

    @NavigationProperty(name="relationshipattribute_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getRelationshipattribute_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("relationshipattribute_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "relationshipattribute_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="referencingattributeid_relationshipattribute")
    @JsonIgnore
    public AttributeRequest getReferencingattributeid_relationshipattribute() {
        return new AttributeRequest(contextPath.addSegment("referencingattributeid_relationshipattribute"), RequestHelper.getValue(unmappedFields, "referencingattributeid_relationshipattribute"));
    }

    @NavigationProperty(name="referencedattributeid_relationshipattribute")
    @JsonIgnore
    public AttributeRequest getReferencedattributeid_relationshipattribute() {
        return new AttributeRequest(contextPath.addSegment("referencedattributeid_relationshipattribute"), RequestHelper.getValue(unmappedFields, "referencedattributeid_relationshipattribute"));
    }

    @NavigationProperty(name="relationshipid_relationshipattribute")
    @JsonIgnore
    public RelationshipRequest getRelationshipid_relationshipattribute() {
        return new RelationshipRequest(contextPath.addSegment("relationshipid_relationshipattribute"), RequestHelper.getValue(unmappedFields, "relationshipid_relationshipattribute"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Relationshipattribute patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Relationshipattribute _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Relationshipattribute put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Relationshipattribute _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Relationshipattribute _copy() {
        Relationshipattribute _x = new Relationshipattribute();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.ismanaged = ismanaged;
        _x._referencedattributeid_value = _referencedattributeid_value;
        _x.name = name;
        _x.overwritetime = overwritetime;
        _x.relationshipattributeid = relationshipattributeid;
        _x.iscustomizable = iscustomizable;
        _x.componentidunique = componentidunique;
        _x.solutionid = solutionid;
        _x._relationshipid_value = _relationshipid_value;
        _x._referencingattributeid_value = _referencingattributeid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Relationshipattribute[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_referencedattributeid_value=");
        b.append(this._referencedattributeid_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("relationshipattributeid=");
        b.append(this.relationshipattributeid);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_relationshipid_value=");
        b.append(this._relationshipid_value);
        b.append(", ");
        b.append("_referencingattributeid_value=");
        b.append(this._referencingattributeid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
