package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.PostCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "postregardingid", 
    "latestmanualpostmodifiedon", 
    "_regardingobjectowningbusinessunit_value", 
    "_regardingobjectid_value", 
    "_regardingobjectownerid_value", 
    "latestautopostmodifiedon", 
    "regardingobjecttypecodeforsharing"})
@JsonInclude(Include.NON_NULL)
public class Postregarding extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.postregarding";
    }

    @JsonProperty("postregardingid")
    protected UUID postregardingid;

    @JsonProperty("latestmanualpostmodifiedon")
    protected OffsetDateTime latestmanualpostmodifiedon;

    @JsonProperty("_regardingobjectowningbusinessunit_value")
    protected UUID _regardingobjectowningbusinessunit_value;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("_regardingobjectownerid_value")
    protected UUID _regardingobjectownerid_value;

    @JsonProperty("latestautopostmodifiedon")
    protected OffsetDateTime latestautopostmodifiedon;

    @JsonProperty("regardingobjecttypecodeforsharing")
    protected String regardingobjecttypecodeforsharing;

    protected Postregarding() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPostregarding() {
        return new Builder();
    }

    public static final class Builder {
        private UUID postregardingid;
        private OffsetDateTime latestmanualpostmodifiedon;
        private UUID _regardingobjectowningbusinessunit_value;
        private UUID _regardingobjectid_value;
        private UUID _regardingobjectownerid_value;
        private OffsetDateTime latestautopostmodifiedon;
        private String regardingobjecttypecodeforsharing;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder postregardingid(UUID postregardingid) {
            this.postregardingid = postregardingid;
            this.changedFields = changedFields.add("postregardingid");
            return this;
        }

        public Builder latestmanualpostmodifiedon(OffsetDateTime latestmanualpostmodifiedon) {
            this.latestmanualpostmodifiedon = latestmanualpostmodifiedon;
            this.changedFields = changedFields.add("latestmanualpostmodifiedon");
            return this;
        }

        public Builder _regardingobjectowningbusinessunit_value(UUID _regardingobjectowningbusinessunit_value) {
            this._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
            this.changedFields = changedFields.add("_regardingobjectowningbusinessunit_value");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder _regardingobjectownerid_value(UUID _regardingobjectownerid_value) {
            this._regardingobjectownerid_value = _regardingobjectownerid_value;
            this.changedFields = changedFields.add("_regardingobjectownerid_value");
            return this;
        }

        public Builder latestautopostmodifiedon(OffsetDateTime latestautopostmodifiedon) {
            this.latestautopostmodifiedon = latestautopostmodifiedon;
            this.changedFields = changedFields.add("latestautopostmodifiedon");
            return this;
        }

        public Builder regardingobjecttypecodeforsharing(String regardingobjecttypecodeforsharing) {
            this.regardingobjecttypecodeforsharing = regardingobjecttypecodeforsharing;
            this.changedFields = changedFields.add("regardingobjecttypecodeforsharing");
            return this;
        }

        public Postregarding build() {
            Postregarding _x = new Postregarding();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.postregarding";
            _x.postregardingid = postregardingid;
            _x.latestmanualpostmodifiedon = latestmanualpostmodifiedon;
            _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x._regardingobjectownerid_value = _regardingobjectownerid_value;
            _x.latestautopostmodifiedon = latestautopostmodifiedon;
            _x.regardingobjecttypecodeforsharing = regardingobjecttypecodeforsharing;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && postregardingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(postregardingid, UUID.class));
        }
    }

    @Property(name="postregardingid")
    @JsonIgnore
    public Optional<UUID> getPostregardingid() {
        return Optional.ofNullable(postregardingid);
    }

    public Postregarding withPostregardingid(UUID postregardingid) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("postregardingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x.postregardingid = postregardingid;
        return _x;
    }

    @Property(name="latestmanualpostmodifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getLatestmanualpostmodifiedon() {
        return Optional.ofNullable(latestmanualpostmodifiedon);
    }

    public Postregarding withLatestmanualpostmodifiedon(OffsetDateTime latestmanualpostmodifiedon) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("latestmanualpostmodifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x.latestmanualpostmodifiedon = latestmanualpostmodifiedon;
        return _x;
    }

    @Property(name="_regardingobjectowningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectowningbusinessunit_value() {
        return Optional.ofNullable(_regardingobjectowningbusinessunit_value);
    }

    public Postregarding with_regardingobjectowningbusinessunit_value(UUID _regardingobjectowningbusinessunit_value) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectowningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Postregarding with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="_regardingobjectownerid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectownerid_value() {
        return Optional.ofNullable(_regardingobjectownerid_value);
    }

    public Postregarding with_regardingobjectownerid_value(UUID _regardingobjectownerid_value) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x._regardingobjectownerid_value = _regardingobjectownerid_value;
        return _x;
    }

    @Property(name="latestautopostmodifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getLatestautopostmodifiedon() {
        return Optional.ofNullable(latestautopostmodifiedon);
    }

    public Postregarding withLatestautopostmodifiedon(OffsetDateTime latestautopostmodifiedon) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("latestautopostmodifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x.latestautopostmodifiedon = latestautopostmodifiedon;
        return _x;
    }

    @Property(name="regardingobjecttypecodeforsharing")
    @JsonIgnore
    public Optional<String> getRegardingobjecttypecodeforsharing() {
        return Optional.ofNullable(regardingobjecttypecodeforsharing);
    }

    public Postregarding withRegardingobjecttypecodeforsharing(String regardingobjecttypecodeforsharing) {
        Postregarding _x = _copy();
        _x.changedFields = changedFields.add("regardingobjecttypecodeforsharing");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postregarding");
        _x.regardingobjecttypecodeforsharing = regardingobjecttypecodeforsharing;
        return _x;
    }

    public Postregarding withUnmappedField(String name, Object value) {
        Postregarding _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_task")
    @JsonIgnore
    public TaskRequest getRegardingobjectid_task() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task"), RequestHelper.getValue(unmappedFields, "regardingobjectid_task"));
    }

    @NavigationProperty(name="regardingobjectid_appointment")
    @JsonIgnore
    public AppointmentRequest getRegardingobjectid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment"), RequestHelper.getValue(unmappedFields, "regardingobjectid_appointment"));
    }

    @NavigationProperty(name="regardingobjectid_phonecall")
    @JsonIgnore
    public PhonecallRequest getRegardingobjectid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall"), RequestHelper.getValue(unmappedFields, "regardingobjectid_phonecall"));
    }

    @NavigationProperty(name="regardingobjectid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getRegardingobjectid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "regardingobjectid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="post_PostRegardings")
    @JsonIgnore
    public PostCollectionRequest getPost_PostRegardings() {
        return new PostCollectionRequest(
                        contextPath.addSegment("post_PostRegardings"), RequestHelper.getValue(unmappedFields, "post_PostRegardings"));
    }

    @NavigationProperty(name="regardingobjectid_account")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account"));
    }

    @NavigationProperty(name="regardingobjectid_systemuser")
    @JsonIgnore
    public SystemuserRequest getRegardingobjectid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("regardingobjectid_systemuser"), RequestHelper.getValue(unmappedFields, "regardingobjectid_systemuser"));
    }

    @NavigationProperty(name="regardingobjectowningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getRegardingobjectowningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("regardingobjectowningbusinessunit"), RequestHelper.getValue(unmappedFields, "regardingobjectowningbusinessunit"));
    }

    @NavigationProperty(name="regardingobjectid_contact")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact"));
    }

    @NavigationProperty(name="regardingobjectid_team")
    @JsonIgnore
    public TeamRequest getRegardingobjectid_team() {
        return new TeamRequest(contextPath.addSegment("regardingobjectid_team"), RequestHelper.getValue(unmappedFields, "regardingobjectid_team"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle"));
    }

    @NavigationProperty(name="regardingobjectid_queue")
    @JsonIgnore
    public QueueRequest getRegardingobjectid_queue() {
        return new QueueRequest(contextPath.addSegment("regardingobjectid_queue"), RequestHelper.getValue(unmappedFields, "regardingobjectid_queue"));
    }

    @NavigationProperty(name="regardingobjectid_processsession")
    @JsonIgnore
    public ProcesssessionRequest getRegardingobjectid_processsession() {
        return new ProcesssessionRequest(contextPath.addSegment("regardingobjectid_processsession"), RequestHelper.getValue(unmappedFields, "regardingobjectid_processsession"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Postregarding patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Postregarding _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Postregarding put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Postregarding _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Postregarding _copy() {
        Postregarding _x = new Postregarding();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.postregardingid = postregardingid;
        _x.latestmanualpostmodifiedon = latestmanualpostmodifiedon;
        _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x._regardingobjectownerid_value = _regardingobjectownerid_value;
        _x.latestautopostmodifiedon = latestautopostmodifiedon;
        _x.regardingobjecttypecodeforsharing = regardingobjecttypecodeforsharing;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Postregarding[");
        b.append("postregardingid=");
        b.append(this.postregardingid);
        b.append(", ");
        b.append("latestmanualpostmodifiedon=");
        b.append(this.latestmanualpostmodifiedon);
        b.append(", ");
        b.append("_regardingobjectowningbusinessunit_value=");
        b.append(this._regardingobjectowningbusinessunit_value);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("_regardingobjectownerid_value=");
        b.append(this._regardingobjectownerid_value);
        b.append(", ");
        b.append("latestautopostmodifiedon=");
        b.append(this.latestautopostmodifiedon);
        b.append(", ");
        b.append("regardingobjecttypecodeforsharing=");
        b.append(this.regardingobjecttypecodeforsharing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
