package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_regardingobjectid_value", 
    "createdon", 
    "type", 
    "text", 
    "_organizationid_value", 
    "source", 
    "_createdby_value", 
    "timezoneruleversionnumber", 
    "_regardingobjectowningbusinessunit_value", 
    "utcconversiontimezonecode", 
    "modifiedon", 
    "_regardingobjectownerid_value", 
    "_createdonbehalfby_value", 
    "_modifiedonbehalfby_value", 
    "_modifiedby_value", 
    "postid"})
@JsonInclude(Include.NON_NULL)
public class Post extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.post";
    }

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("type")
    protected Integer type;

    @JsonProperty("text")
    protected String text;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("source")
    protected Integer source;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_regardingobjectowningbusinessunit_value")
    protected UUID _regardingobjectowningbusinessunit_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_regardingobjectownerid_value")
    protected UUID _regardingobjectownerid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("postid")
    protected UUID postid;

    protected Post() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPost() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _regardingobjectid_value;
        private OffsetDateTime createdon;
        private Integer type;
        private String text;
        private UUID _organizationid_value;
        private Integer source;
        private UUID _createdby_value;
        private Integer timezoneruleversionnumber;
        private UUID _regardingobjectowningbusinessunit_value;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime modifiedon;
        private UUID _regardingobjectownerid_value;
        private UUID _createdonbehalfby_value;
        private UUID _modifiedonbehalfby_value;
        private UUID _modifiedby_value;
        private UUID postid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.changedFields = changedFields.add("text");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder source(Integer source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _regardingobjectowningbusinessunit_value(UUID _regardingobjectowningbusinessunit_value) {
            this._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
            this.changedFields = changedFields.add("_regardingobjectowningbusinessunit_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _regardingobjectownerid_value(UUID _regardingobjectownerid_value) {
            this._regardingobjectownerid_value = _regardingobjectownerid_value;
            this.changedFields = changedFields.add("_regardingobjectownerid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder postid(UUID postid) {
            this.postid = postid;
            this.changedFields = changedFields.add("postid");
            return this;
        }

        public Post build() {
            Post _x = new Post();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.post";
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.createdon = createdon;
            _x.type = type;
            _x.text = text;
            _x._organizationid_value = _organizationid_value;
            _x.source = source;
            _x._createdby_value = _createdby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.modifiedon = modifiedon;
            _x._regardingobjectownerid_value = _regardingobjectownerid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.postid = postid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && postid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(postid, UUID.class));
        }
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Post with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Post withCreatedon(OffsetDateTime createdon) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<Integer> getType() {
        return Optional.ofNullable(type);
    }

    public Post withType(Integer type) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.type = type;
        return _x;
    }

    @Property(name="text")
    @JsonIgnore
    public Optional<String> getText() {
        return Optional.ofNullable(text);
    }

    public Post withText(String text) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("text");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.text = text;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Post with_organizationid_value(UUID _organizationid_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<Integer> getSource() {
        return Optional.ofNullable(source);
    }

    public Post withSource(Integer source) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.source = source;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Post with_createdby_value(UUID _createdby_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Post withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_regardingobjectowningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectowningbusinessunit_value() {
        return Optional.ofNullable(_regardingobjectowningbusinessunit_value);
    }

    public Post with_regardingobjectowningbusinessunit_value(UUID _regardingobjectowningbusinessunit_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectowningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Post withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Post withModifiedon(OffsetDateTime modifiedon) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_regardingobjectownerid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectownerid_value() {
        return Optional.ofNullable(_regardingobjectownerid_value);
    }

    public Post with_regardingobjectownerid_value(UUID _regardingobjectownerid_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._regardingobjectownerid_value = _regardingobjectownerid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Post with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Post with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Post with_modifiedby_value(UUID _modifiedby_value) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="postid")
    @JsonIgnore
    public Optional<UUID> getPostid() {
        return Optional.ofNullable(postid);
    }

    public Post withPostid(UUID postid) {
        Post _x = _copy();
        _x.changedFields = changedFields.add("postid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.post");
        _x.postid = postid;
        return _x;
    }

    public Post withUnmappedField(String name, Object value) {
        Post _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="post_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getPost_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("post_AsyncOperations"), RequestHelper.getValue(unmappedFields, "post_AsyncOperations"));
    }

    @NavigationProperty(name="post_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getPost_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("post_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "post_BulkDeleteFailures"));
    }

    @NavigationProperty(name="postregardingid")
    @JsonIgnore
    public PostregardingRequest getPostregardingid() {
        return new PostregardingRequest(contextPath.addSegment("postregardingid"), RequestHelper.getValue(unmappedFields, "postregardingid"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="Post_Comments")
    @JsonIgnore
    public PostcommentCollectionRequest getPost_Comments() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("Post_Comments"), RequestHelper.getValue(unmappedFields, "Post_Comments"));
    }

    @NavigationProperty(name="Post_Likes")
    @JsonIgnore
    public PostlikeCollectionRequest getPost_Likes() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("Post_Likes"), RequestHelper.getValue(unmappedFields, "Post_Likes"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Post patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Post _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Post put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Post _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Post _copy() {
        Post _x = new Post();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.createdon = createdon;
        _x.type = type;
        _x.text = text;
        _x._organizationid_value = _organizationid_value;
        _x.source = source;
        _x._createdby_value = _createdby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._regardingobjectowningbusinessunit_value = _regardingobjectowningbusinessunit_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.modifiedon = modifiedon;
        _x._regardingobjectownerid_value = _regardingobjectownerid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.postid = postid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Post[");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("text=");
        b.append(this.text);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_regardingobjectowningbusinessunit_value=");
        b.append(this._regardingobjectowningbusinessunit_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_regardingobjectownerid_value=");
        b.append(this._regardingobjectownerid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("postid=");
        b.append(this.postid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
