package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "personaldocumenttemplateid", 
    "_owninguser_value", 
    "content", 
    "_createdonbehalfby_value", 
    "status", 
    "name", 
    "documenttype", 
    "clientdata", 
    "modifiedon", 
    "_createdby_value", 
    "_modifiedby_value", 
    "_ownerid_value", 
    "_owningteam_value", 
    "languagecode", 
    "description", 
    "_owningbusinessunit_value", 
    "versionnumber", 
    "associatedentitytypecode"})
@JsonInclude(Include.NON_NULL)
public class Personaldocumenttemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.personaldocumenttemplate";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("personaldocumenttemplateid")
    protected UUID personaldocumenttemplateid;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("status")
    protected Boolean status;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("documenttype")
    protected Integer documenttype;

    @JsonProperty("clientdata")
    protected String clientdata;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("associatedentitytypecode")
    protected String associatedentitytypecode;

    protected Personaldocumenttemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPersonaldocumenttemplate() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private UUID personaldocumenttemplateid;
        private UUID _owninguser_value;
        private String content;
        private UUID _createdonbehalfby_value;
        private Boolean status;
        private String name;
        private Integer documenttype;
        private String clientdata;
        private OffsetDateTime modifiedon;
        private UUID _createdby_value;
        private UUID _modifiedby_value;
        private UUID _ownerid_value;
        private UUID _owningteam_value;
        private Integer languagecode;
        private String description;
        private UUID _owningbusinessunit_value;
        private Long versionnumber;
        private String associatedentitytypecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder personaldocumenttemplateid(UUID personaldocumenttemplateid) {
            this.personaldocumenttemplateid = personaldocumenttemplateid;
            this.changedFields = changedFields.add("personaldocumenttemplateid");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder status(Boolean status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder documenttype(Integer documenttype) {
            this.documenttype = documenttype;
            this.changedFields = changedFields.add("documenttype");
            return this;
        }

        public Builder clientdata(String clientdata) {
            this.clientdata = clientdata;
            this.changedFields = changedFields.add("clientdata");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder associatedentitytypecode(String associatedentitytypecode) {
            this.associatedentitytypecode = associatedentitytypecode;
            this.changedFields = changedFields.add("associatedentitytypecode");
            return this;
        }

        public Personaldocumenttemplate build() {
            Personaldocumenttemplate _x = new Personaldocumenttemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.personaldocumenttemplate";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x.personaldocumenttemplateid = personaldocumenttemplateid;
            _x._owninguser_value = _owninguser_value;
            _x.content = content;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.status = status;
            _x.name = name;
            _x.documenttype = documenttype;
            _x.clientdata = clientdata;
            _x.modifiedon = modifiedon;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._ownerid_value = _ownerid_value;
            _x._owningteam_value = _owningteam_value;
            _x.languagecode = languagecode;
            _x.description = description;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.versionnumber = versionnumber;
            _x.associatedentitytypecode = associatedentitytypecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && personaldocumenttemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(personaldocumenttemplateid, UUID.class));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Personaldocumenttemplate with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Personaldocumenttemplate withCreatedon(OffsetDateTime createdon) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="personaldocumenttemplateid")
    @JsonIgnore
    public Optional<UUID> getPersonaldocumenttemplateid() {
        return Optional.ofNullable(personaldocumenttemplateid);
    }

    public Personaldocumenttemplate withPersonaldocumenttemplateid(UUID personaldocumenttemplateid) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("personaldocumenttemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.personaldocumenttemplateid = personaldocumenttemplateid;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Personaldocumenttemplate with_owninguser_value(UUID _owninguser_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public Personaldocumenttemplate withContent(String content) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.content = content;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Personaldocumenttemplate with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Boolean> getStatus() {
        return Optional.ofNullable(status);
    }

    public Personaldocumenttemplate withStatus(Boolean status) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.status = status;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Personaldocumenttemplate withName(String name) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.name = name;
        return _x;
    }

    @Property(name="documenttype")
    @JsonIgnore
    public Optional<Integer> getDocumenttype() {
        return Optional.ofNullable(documenttype);
    }

    public Personaldocumenttemplate withDocumenttype(Integer documenttype) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("documenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.documenttype = documenttype;
        return _x;
    }

    @Property(name="clientdata")
    @JsonIgnore
    public Optional<String> getClientdata() {
        return Optional.ofNullable(clientdata);
    }

    public Personaldocumenttemplate withClientdata(String clientdata) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("clientdata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.clientdata = clientdata;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Personaldocumenttemplate withModifiedon(OffsetDateTime modifiedon) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Personaldocumenttemplate with_createdby_value(UUID _createdby_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Personaldocumenttemplate with_modifiedby_value(UUID _modifiedby_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Personaldocumenttemplate with_ownerid_value(UUID _ownerid_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Personaldocumenttemplate with_owningteam_value(UUID _owningteam_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Personaldocumenttemplate withLanguagecode(Integer languagecode) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Personaldocumenttemplate withDescription(String description) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Personaldocumenttemplate with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Personaldocumenttemplate withVersionnumber(Long versionnumber) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="associatedentitytypecode")
    @JsonIgnore
    public Optional<String> getAssociatedentitytypecode() {
        return Optional.ofNullable(associatedentitytypecode);
    }

    public Personaldocumenttemplate withAssociatedentitytypecode(String associatedentitytypecode) {
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = changedFields.add("associatedentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.personaldocumenttemplate");
        _x.associatedentitytypecode = associatedentitytypecode;
        return _x;
    }

    public Personaldocumenttemplate withUnmappedField(String name, Object value) {
        Personaldocumenttemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Personaldocumenttemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Personaldocumenttemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Personaldocumenttemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Personaldocumenttemplate _copy() {
        Personaldocumenttemplate _x = new Personaldocumenttemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x.personaldocumenttemplateid = personaldocumenttemplateid;
        _x._owninguser_value = _owninguser_value;
        _x.content = content;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.status = status;
        _x.name = name;
        _x.documenttype = documenttype;
        _x.clientdata = clientdata;
        _x.modifiedon = modifiedon;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._ownerid_value = _ownerid_value;
        _x._owningteam_value = _owningteam_value;
        _x.languagecode = languagecode;
        _x.description = description;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.versionnumber = versionnumber;
        _x.associatedentitytypecode = associatedentitytypecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Personaldocumenttemplate[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("personaldocumenttemplateid=");
        b.append(this.personaldocumenttemplateid);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("documenttype=");
        b.append(this.documenttype);
        b.append(", ");
        b.append("clientdata=");
        b.append(this.clientdata);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("associatedentitytypecode=");
        b.append(this.associatedentitytypecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
