package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_msdyn_aiodlabelid_value", 
    "statecode", 
    "_owninguser_value", 
    "msdyn_aiodtrainingboundingboxid", 
    "_owningteam_value", 
    "_msdyn_aiodtrainingimageid_value", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "msdyn_width", 
    "_ownerid_value", 
    "importsequencenumber", 
    "_modifiedby_value", 
    "_owningbusinessunit_value", 
    "msdyn_name", 
    "overriddencreatedon", 
    "modifiedon", 
    "createdon", 
    "_createdonbehalfby_value", 
    "msdyn_height", 
    "msdyn_top", 
    "timezoneruleversionnumber", 
    "versionnumber", 
    "msdyn_left", 
    "statuscode", 
    "utcconversiontimezonecode"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aiodtrainingboundingbox extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox";
    }

    @JsonProperty("_msdyn_aiodlabelid_value")
    protected UUID _msdyn_aiodlabelid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("msdyn_aiodtrainingboundingboxid")
    protected UUID msdyn_aiodtrainingboundingboxid;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_msdyn_aiodtrainingimageid_value")
    protected UUID _msdyn_aiodtrainingimageid_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("msdyn_width")
    protected Double msdyn_width;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("msdyn_height")
    protected Double msdyn_height;

    @JsonProperty("msdyn_top")
    protected Double msdyn_top;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("msdyn_left")
    protected Double msdyn_left;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    protected Msdyn_aiodtrainingboundingbox() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aiodtrainingboundingbox() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _msdyn_aiodlabelid_value;
        private Integer statecode;
        private UUID _owninguser_value;
        private UUID msdyn_aiodtrainingboundingboxid;
        private UUID _owningteam_value;
        private UUID _msdyn_aiodtrainingimageid_value;
        private UUID _createdby_value;
        private UUID _modifiedonbehalfby_value;
        private Double msdyn_width;
        private UUID _ownerid_value;
        private Integer importsequencenumber;
        private UUID _modifiedby_value;
        private UUID _owningbusinessunit_value;
        private String msdyn_name;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private Double msdyn_height;
        private Double msdyn_top;
        private Integer timezoneruleversionnumber;
        private Long versionnumber;
        private Double msdyn_left;
        private Integer statuscode;
        private Integer utcconversiontimezonecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _msdyn_aiodlabelid_value(UUID _msdyn_aiodlabelid_value) {
            this._msdyn_aiodlabelid_value = _msdyn_aiodlabelid_value;
            this.changedFields = changedFields.add("_msdyn_aiodlabelid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder msdyn_aiodtrainingboundingboxid(UUID msdyn_aiodtrainingboundingboxid) {
            this.msdyn_aiodtrainingboundingboxid = msdyn_aiodtrainingboundingboxid;
            this.changedFields = changedFields.add("msdyn_aiodtrainingboundingboxid");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _msdyn_aiodtrainingimageid_value(UUID _msdyn_aiodtrainingimageid_value) {
            this._msdyn_aiodtrainingimageid_value = _msdyn_aiodtrainingimageid_value;
            this.changedFields = changedFields.add("_msdyn_aiodtrainingimageid_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder msdyn_width(Double msdyn_width) {
            this.msdyn_width = msdyn_width;
            this.changedFields = changedFields.add("msdyn_width");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder msdyn_height(Double msdyn_height) {
            this.msdyn_height = msdyn_height;
            this.changedFields = changedFields.add("msdyn_height");
            return this;
        }

        public Builder msdyn_top(Double msdyn_top) {
            this.msdyn_top = msdyn_top;
            this.changedFields = changedFields.add("msdyn_top");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder msdyn_left(Double msdyn_left) {
            this.msdyn_left = msdyn_left;
            this.changedFields = changedFields.add("msdyn_left");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Msdyn_aiodtrainingboundingbox build() {
            Msdyn_aiodtrainingboundingbox _x = new Msdyn_aiodtrainingboundingbox();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox";
            _x._msdyn_aiodlabelid_value = _msdyn_aiodlabelid_value;
            _x.statecode = statecode;
            _x._owninguser_value = _owninguser_value;
            _x.msdyn_aiodtrainingboundingboxid = msdyn_aiodtrainingboundingboxid;
            _x._owningteam_value = _owningteam_value;
            _x._msdyn_aiodtrainingimageid_value = _msdyn_aiodtrainingimageid_value;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.msdyn_width = msdyn_width;
            _x._ownerid_value = _ownerid_value;
            _x.importsequencenumber = importsequencenumber;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_name = msdyn_name;
            _x.overriddencreatedon = overriddencreatedon;
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.msdyn_height = msdyn_height;
            _x.msdyn_top = msdyn_top;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.versionnumber = versionnumber;
            _x.msdyn_left = msdyn_left;
            _x.statuscode = statuscode;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aiodtrainingboundingboxid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class));
        }
    }

    @Property(name="_msdyn_aiodlabelid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_aiodlabelid_value() {
        return Optional.ofNullable(_msdyn_aiodlabelid_value);
    }

    public Msdyn_aiodtrainingboundingbox with_msdyn_aiodlabelid_value(UUID _msdyn_aiodlabelid_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aiodlabelid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._msdyn_aiodlabelid_value = _msdyn_aiodlabelid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aiodtrainingboundingbox withStatecode(Integer statecode) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aiodtrainingboundingbox with_owninguser_value(UUID _owninguser_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="msdyn_aiodtrainingboundingboxid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_aiodtrainingboundingboxid() {
        return Optional.ofNullable(msdyn_aiodtrainingboundingboxid);
    }

    public Msdyn_aiodtrainingboundingbox withMsdyn_aiodtrainingboundingboxid(UUID msdyn_aiodtrainingboundingboxid) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aiodtrainingboundingboxid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.msdyn_aiodtrainingboundingboxid = msdyn_aiodtrainingboundingboxid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aiodtrainingboundingbox with_owningteam_value(UUID _owningteam_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_msdyn_aiodtrainingimageid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_aiodtrainingimageid_value() {
        return Optional.ofNullable(_msdyn_aiodtrainingimageid_value);
    }

    public Msdyn_aiodtrainingboundingbox with_msdyn_aiodtrainingimageid_value(UUID _msdyn_aiodtrainingimageid_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_aiodtrainingimageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._msdyn_aiodtrainingimageid_value = _msdyn_aiodtrainingimageid_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aiodtrainingboundingbox with_createdby_value(UUID _createdby_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aiodtrainingboundingbox with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_width")
    @JsonIgnore
    public Optional<Double> getMsdyn_width() {
        return Optional.ofNullable(msdyn_width);
    }

    public Msdyn_aiodtrainingboundingbox withMsdyn_width(Double msdyn_width) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("msdyn_width");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.msdyn_width = msdyn_width;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aiodtrainingboundingbox with_ownerid_value(UUID _ownerid_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aiodtrainingboundingbox withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aiodtrainingboundingbox with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aiodtrainingboundingbox with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aiodtrainingboundingbox withMsdyn_name(String msdyn_name) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aiodtrainingboundingbox withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aiodtrainingboundingbox withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aiodtrainingboundingbox withCreatedon(OffsetDateTime createdon) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aiodtrainingboundingbox with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_height")
    @JsonIgnore
    public Optional<Double> getMsdyn_height() {
        return Optional.ofNullable(msdyn_height);
    }

    public Msdyn_aiodtrainingboundingbox withMsdyn_height(Double msdyn_height) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("msdyn_height");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.msdyn_height = msdyn_height;
        return _x;
    }

    @Property(name="msdyn_top")
    @JsonIgnore
    public Optional<Double> getMsdyn_top() {
        return Optional.ofNullable(msdyn_top);
    }

    public Msdyn_aiodtrainingboundingbox withMsdyn_top(Double msdyn_top) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("msdyn_top");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.msdyn_top = msdyn_top;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aiodtrainingboundingbox withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aiodtrainingboundingbox withVersionnumber(Long versionnumber) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="msdyn_left")
    @JsonIgnore
    public Optional<Double> getMsdyn_left() {
        return Optional.ofNullable(msdyn_left);
    }

    public Msdyn_aiodtrainingboundingbox withMsdyn_left(Double msdyn_left) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("msdyn_left");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.msdyn_left = msdyn_left;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aiodtrainingboundingbox withStatuscode(Integer statuscode) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aiodtrainingboundingbox withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aiodtrainingboundingbox");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    public Msdyn_aiodtrainingboundingbox withUnmappedField(String name, Object value) {
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aiodtrainingboundingbox_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aiodtrainingboundingbox_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_aiodtrainingboundingbox_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aiodtrainingboundingbox_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aiodtrainingboundingbox_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aiodtrainingboundingbox_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aiodtrainingboundingbox_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aiodtrainingboundingbox_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aiodtrainingboundingbox_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aiodtrainingboundingbox_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aiodtrainingboundingbox_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_AIOdLabelId")
    @JsonIgnore
    public Msdyn_aiodlabelRequest getMsdyn_AIOdLabelId() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("msdyn_AIOdLabelId"), RequestHelper.getValue(unmappedFields, "msdyn_AIOdLabelId"));
    }

    @NavigationProperty(name="msdyn_AIOdTrainingImageId")
    @JsonIgnore
    public Msdyn_aiodtrainingimageRequest getMsdyn_AIOdTrainingImageId() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("msdyn_AIOdTrainingImageId"), RequestHelper.getValue(unmappedFields, "msdyn_AIOdTrainingImageId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodtrainingboundingbox patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aiodtrainingboundingbox put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aiodtrainingboundingbox _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aiodtrainingboundingbox _copy() {
        Msdyn_aiodtrainingboundingbox _x = new Msdyn_aiodtrainingboundingbox();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._msdyn_aiodlabelid_value = _msdyn_aiodlabelid_value;
        _x.statecode = statecode;
        _x._owninguser_value = _owninguser_value;
        _x.msdyn_aiodtrainingboundingboxid = msdyn_aiodtrainingboundingboxid;
        _x._owningteam_value = _owningteam_value;
        _x._msdyn_aiodtrainingimageid_value = _msdyn_aiodtrainingimageid_value;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.msdyn_width = msdyn_width;
        _x._ownerid_value = _ownerid_value;
        _x.importsequencenumber = importsequencenumber;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_name = msdyn_name;
        _x.overriddencreatedon = overriddencreatedon;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.msdyn_height = msdyn_height;
        _x.msdyn_top = msdyn_top;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.versionnumber = versionnumber;
        _x.msdyn_left = msdyn_left;
        _x.statuscode = statuscode;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aiodtrainingboundingbox[");
        b.append("_msdyn_aiodlabelid_value=");
        b.append(this._msdyn_aiodlabelid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("msdyn_aiodtrainingboundingboxid=");
        b.append(this.msdyn_aiodtrainingboundingboxid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_msdyn_aiodtrainingimageid_value=");
        b.append(this._msdyn_aiodtrainingimageid_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("msdyn_width=");
        b.append(this.msdyn_width);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("msdyn_height=");
        b.append(this.msdyn_height);
        b.append(", ");
        b.append("msdyn_top=");
        b.append(this.msdyn_top);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("msdyn_left=");
        b.append(this.msdyn_left);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
