package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BatchPredictionResponse;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.PredictResponse;
import microsoft.dynamics.crm.complex.PredictionSchemaResponse;
import microsoft.dynamics.crm.complex.SchedulePredictionResponse;
import microsoft.dynamics.crm.complex.ScheduleRetrainResponse;
import microsoft.dynamics.crm.complex.UnschedulePredictionResponse;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetscontainerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_name", 
    "msdyn_modelcreationcontext", 
    "solutionid", 
    "componentstate", 
    "createdon", 
    "_modifiedby_value", 
    "overriddencreatedon", 
    "timezoneruleversionnumber", 
    "overwritetime", 
    "_msdyn_activerunconfigurationid_value", 
    "msdyn_sharewithorganizationoncreate", 
    "_owningteam_value", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "introducedversion", 
    "_createdonbehalfby_value", 
    "importsequencenumber", 
    "ismanaged", 
    "msdyn_aimodelidunique", 
    "_owninguser_value", 
    "_msdyn_scheduleinferenceworkflowid_value", 
    "modifiedon", 
    "utcconversiontimezonecode", 
    "_ownerid_value", 
    "versionnumber", 
    "_msdyn_retrainworkflowid_value", 
    "statuscode", 
    "_createdby_value", 
    "msdyn_aimodelid", 
    "iscustomizable", 
    "_msdyn_templateid_value", 
    "_owningbusinessunit_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_aimodel extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_aimodel";
    }

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_modelcreationcontext")
    protected String msdyn_modelcreationcontext;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_msdyn_activerunconfigurationid_value")
    protected UUID _msdyn_activerunconfigurationid_value;

    @JsonProperty("msdyn_sharewithorganizationoncreate")
    protected Boolean msdyn_sharewithorganizationoncreate;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("msdyn_aimodelidunique")
    protected UUID msdyn_aimodelidunique;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_msdyn_scheduleinferenceworkflowid_value")
    protected UUID _msdyn_scheduleinferenceworkflowid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_msdyn_retrainworkflowid_value")
    protected UUID _msdyn_retrainworkflowid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("msdyn_aimodelid")
    protected UUID msdyn_aimodelid;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("_msdyn_templateid_value")
    protected UUID _msdyn_templateid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    protected Msdyn_aimodel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_aimodel() {
        return new Builder();
    }

    public static final class Builder {
        private String msdyn_name;
        private String msdyn_modelcreationcontext;
        private UUID solutionid;
        private Integer componentstate;
        private OffsetDateTime createdon;
        private UUID _modifiedby_value;
        private OffsetDateTime overriddencreatedon;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime overwritetime;
        private UUID _msdyn_activerunconfigurationid_value;
        private Boolean msdyn_sharewithorganizationoncreate;
        private UUID _owningteam_value;
        private Integer statecode;
        private UUID _modifiedonbehalfby_value;
        private String introducedversion;
        private UUID _createdonbehalfby_value;
        private Integer importsequencenumber;
        private Boolean ismanaged;
        private UUID msdyn_aimodelidunique;
        private UUID _owninguser_value;
        private UUID _msdyn_scheduleinferenceworkflowid_value;
        private OffsetDateTime modifiedon;
        private Integer utcconversiontimezonecode;
        private UUID _ownerid_value;
        private Long versionnumber;
        private UUID _msdyn_retrainworkflowid_value;
        private Integer statuscode;
        private UUID _createdby_value;
        private UUID msdyn_aimodelid;
        private BooleanManagedProperty iscustomizable;
        private UUID _msdyn_templateid_value;
        private UUID _owningbusinessunit_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_modelcreationcontext(String msdyn_modelcreationcontext) {
            this.msdyn_modelcreationcontext = msdyn_modelcreationcontext;
            this.changedFields = changedFields.add("msdyn_modelcreationcontext");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _msdyn_activerunconfigurationid_value(UUID _msdyn_activerunconfigurationid_value) {
            this._msdyn_activerunconfigurationid_value = _msdyn_activerunconfigurationid_value;
            this.changedFields = changedFields.add("_msdyn_activerunconfigurationid_value");
            return this;
        }

        public Builder msdyn_sharewithorganizationoncreate(Boolean msdyn_sharewithorganizationoncreate) {
            this.msdyn_sharewithorganizationoncreate = msdyn_sharewithorganizationoncreate;
            this.changedFields = changedFields.add("msdyn_sharewithorganizationoncreate");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder msdyn_aimodelidunique(UUID msdyn_aimodelidunique) {
            this.msdyn_aimodelidunique = msdyn_aimodelidunique;
            this.changedFields = changedFields.add("msdyn_aimodelidunique");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _msdyn_scheduleinferenceworkflowid_value(UUID _msdyn_scheduleinferenceworkflowid_value) {
            this._msdyn_scheduleinferenceworkflowid_value = _msdyn_scheduleinferenceworkflowid_value;
            this.changedFields = changedFields.add("_msdyn_scheduleinferenceworkflowid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _msdyn_retrainworkflowid_value(UUID _msdyn_retrainworkflowid_value) {
            this._msdyn_retrainworkflowid_value = _msdyn_retrainworkflowid_value;
            this.changedFields = changedFields.add("_msdyn_retrainworkflowid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder msdyn_aimodelid(UUID msdyn_aimodelid) {
            this.msdyn_aimodelid = msdyn_aimodelid;
            this.changedFields = changedFields.add("msdyn_aimodelid");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder _msdyn_templateid_value(UUID _msdyn_templateid_value) {
            this._msdyn_templateid_value = _msdyn_templateid_value;
            this.changedFields = changedFields.add("_msdyn_templateid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Msdyn_aimodel build() {
            Msdyn_aimodel _x = new Msdyn_aimodel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_aimodel";
            _x.msdyn_name = msdyn_name;
            _x.msdyn_modelcreationcontext = msdyn_modelcreationcontext;
            _x.solutionid = solutionid;
            _x.componentstate = componentstate;
            _x.createdon = createdon;
            _x._modifiedby_value = _modifiedby_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.overwritetime = overwritetime;
            _x._msdyn_activerunconfigurationid_value = _msdyn_activerunconfigurationid_value;
            _x.msdyn_sharewithorganizationoncreate = msdyn_sharewithorganizationoncreate;
            _x._owningteam_value = _owningteam_value;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.introducedversion = introducedversion;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.ismanaged = ismanaged;
            _x.msdyn_aimodelidunique = msdyn_aimodelidunique;
            _x._owninguser_value = _owninguser_value;
            _x._msdyn_scheduleinferenceworkflowid_value = _msdyn_scheduleinferenceworkflowid_value;
            _x.modifiedon = modifiedon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._ownerid_value = _ownerid_value;
            _x.versionnumber = versionnumber;
            _x._msdyn_retrainworkflowid_value = _msdyn_retrainworkflowid_value;
            _x.statuscode = statuscode;
            _x._createdby_value = _createdby_value;
            _x.msdyn_aimodelid = msdyn_aimodelid;
            _x.iscustomizable = iscustomizable;
            _x._msdyn_templateid_value = _msdyn_templateid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_aimodelid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_aimodelid, UUID.class));
        }
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_aimodel withMsdyn_name(String msdyn_name) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_modelcreationcontext")
    @JsonIgnore
    public Optional<String> getMsdyn_modelcreationcontext() {
        return Optional.ofNullable(msdyn_modelcreationcontext);
    }

    public Msdyn_aimodel withMsdyn_modelcreationcontext(String msdyn_modelcreationcontext) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("msdyn_modelcreationcontext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.msdyn_modelcreationcontext = msdyn_modelcreationcontext;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Msdyn_aimodel withSolutionid(UUID solutionid) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Msdyn_aimodel withComponentstate(Integer componentstate) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_aimodel withCreatedon(OffsetDateTime createdon) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_aimodel with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_aimodel withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_aimodel withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Msdyn_aimodel withOverwritetime(OffsetDateTime overwritetime) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_msdyn_activerunconfigurationid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_activerunconfigurationid_value() {
        return Optional.ofNullable(_msdyn_activerunconfigurationid_value);
    }

    public Msdyn_aimodel with_msdyn_activerunconfigurationid_value(UUID _msdyn_activerunconfigurationid_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_activerunconfigurationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._msdyn_activerunconfigurationid_value = _msdyn_activerunconfigurationid_value;
        return _x;
    }

    @Property(name="msdyn_sharewithorganizationoncreate")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_sharewithorganizationoncreate() {
        return Optional.ofNullable(msdyn_sharewithorganizationoncreate);
    }

    public Msdyn_aimodel withMsdyn_sharewithorganizationoncreate(Boolean msdyn_sharewithorganizationoncreate) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sharewithorganizationoncreate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.msdyn_sharewithorganizationoncreate = msdyn_sharewithorganizationoncreate;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_aimodel with_owningteam_value(UUID _owningteam_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_aimodel withStatecode(Integer statecode) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_aimodel with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Msdyn_aimodel withIntroducedversion(String introducedversion) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_aimodel with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_aimodel withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Msdyn_aimodel withIsmanaged(Boolean ismanaged) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="msdyn_aimodelidunique")
    @JsonIgnore
    public Optional<UUID> getMsdyn_aimodelidunique() {
        return Optional.ofNullable(msdyn_aimodelidunique);
    }

    public Msdyn_aimodel withMsdyn_aimodelidunique(UUID msdyn_aimodelidunique) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aimodelidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.msdyn_aimodelidunique = msdyn_aimodelidunique;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_aimodel with_owninguser_value(UUID _owninguser_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_msdyn_scheduleinferenceworkflowid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_scheduleinferenceworkflowid_value() {
        return Optional.ofNullable(_msdyn_scheduleinferenceworkflowid_value);
    }

    public Msdyn_aimodel with_msdyn_scheduleinferenceworkflowid_value(UUID _msdyn_scheduleinferenceworkflowid_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_scheduleinferenceworkflowid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._msdyn_scheduleinferenceworkflowid_value = _msdyn_scheduleinferenceworkflowid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_aimodel withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_aimodel withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_aimodel with_ownerid_value(UUID _ownerid_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_aimodel withVersionnumber(Long versionnumber) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_msdyn_retrainworkflowid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_retrainworkflowid_value() {
        return Optional.ofNullable(_msdyn_retrainworkflowid_value);
    }

    public Msdyn_aimodel with_msdyn_retrainworkflowid_value(UUID _msdyn_retrainworkflowid_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_retrainworkflowid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._msdyn_retrainworkflowid_value = _msdyn_retrainworkflowid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_aimodel withStatuscode(Integer statuscode) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_aimodel with_createdby_value(UUID _createdby_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="msdyn_aimodelid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_aimodelid() {
        return Optional.ofNullable(msdyn_aimodelid);
    }

    public Msdyn_aimodel withMsdyn_aimodelid(UUID msdyn_aimodelid) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("msdyn_aimodelid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.msdyn_aimodelid = msdyn_aimodelid;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Msdyn_aimodel withIscustomizable(BooleanManagedProperty iscustomizable) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="_msdyn_templateid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_templateid_value() {
        return Optional.ofNullable(_msdyn_templateid_value);
    }

    public Msdyn_aimodel with_msdyn_templateid_value(UUID _msdyn_templateid_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_templateid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._msdyn_templateid_value = _msdyn_templateid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_aimodel with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_aimodel _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_aimodel");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    public Msdyn_aimodel withUnmappedField(String name, Object value) {
        Msdyn_aimodel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_aimodel_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_aimodel_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_aimodel_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_aimodel_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_aimodel_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_aimodel_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_aimodel_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_aimodel_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_aimodel_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_aimodel_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_aimodel_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_aimodel_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_aimodel_Annotations")
    @JsonIgnore
    public AnnotationCollectionRequest getMsdyn_aimodel_Annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_Annotations"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_Annotations"));
    }

    @NavigationProperty(name="msdyn_aimodel_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationCollectionRequest getMsdyn_aimodel_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("msdyn_aimodel_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "msdyn_aimodel_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="msdyn_retrainworkflowid")
    @JsonIgnore
    public WorkflowRequest getMsdyn_retrainworkflowid() {
        return new WorkflowRequest(contextPath.addSegment("msdyn_retrainworkflowid"), RequestHelper.getValue(unmappedFields, "msdyn_retrainworkflowid"));
    }

    @NavigationProperty(name="msdyn_TemplateId")
    @JsonIgnore
    public Msdyn_aitemplateRequest getMsdyn_TemplateId() {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("msdyn_TemplateId"), RequestHelper.getValue(unmappedFields, "msdyn_TemplateId"));
    }

    @NavigationProperty(name="msdyn_AIBDatasetsContainer_msdyn_AIModelI")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerCollectionRequest getMsdyn_AIBDatasetsContainer_msdyn_AIModelI() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("msdyn_AIBDatasetsContainer_msdyn_AIModelI"), RequestHelper.getValue(unmappedFields, "msdyn_AIBDatasetsContainer_msdyn_AIModelI"));
    }

    @NavigationProperty(name="msdyn_scheduleinferenceworkflowid")
    @JsonIgnore
    public WorkflowRequest getMsdyn_scheduleinferenceworkflowid() {
        return new WorkflowRequest(contextPath.addSegment("msdyn_scheduleinferenceworkflowid"), RequestHelper.getValue(unmappedFields, "msdyn_scheduleinferenceworkflowid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aimodel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aimodel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_aimodel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_aimodel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_aimodel _copy() {
        Msdyn_aimodel _x = new Msdyn_aimodel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_modelcreationcontext = msdyn_modelcreationcontext;
        _x.solutionid = solutionid;
        _x.componentstate = componentstate;
        _x.createdon = createdon;
        _x._modifiedby_value = _modifiedby_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.overwritetime = overwritetime;
        _x._msdyn_activerunconfigurationid_value = _msdyn_activerunconfigurationid_value;
        _x.msdyn_sharewithorganizationoncreate = msdyn_sharewithorganizationoncreate;
        _x._owningteam_value = _owningteam_value;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.introducedversion = introducedversion;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.ismanaged = ismanaged;
        _x.msdyn_aimodelidunique = msdyn_aimodelidunique;
        _x._owninguser_value = _owninguser_value;
        _x._msdyn_scheduleinferenceworkflowid_value = _msdyn_scheduleinferenceworkflowid_value;
        _x.modifiedon = modifiedon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._ownerid_value = _ownerid_value;
        _x.versionnumber = versionnumber;
        _x._msdyn_retrainworkflowid_value = _msdyn_retrainworkflowid_value;
        _x.statuscode = statuscode;
        _x._createdby_value = _createdby_value;
        _x.msdyn_aimodelid = msdyn_aimodelid;
        _x.iscustomizable = iscustomizable;
        _x._msdyn_templateid_value = _msdyn_templateid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Action(name = "BatchPrediction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<BatchPredictionResponse> batchPrediction(String version) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<BatchPredictionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.BatchPrediction"), BatchPredictionResponse.class, _parameters);
    }

    @Action(name = "Predict")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PredictResponse> predict(String version, String request, Crmbaseentity recordId, Crmbaseentity requestv2) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("request", "Edm.String", Checks.checkIsAscii(request))
            .put("recordId", "Microsoft.Dynamics.CRM.crmbaseentity", recordId)
            .put("requestv2", "Microsoft.Dynamics.CRM.crmbaseentity", requestv2)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PredictResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Predict"), PredictResponse.class, _parameters);
    }

    @Action(name = "PredictByReference")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity> predictByReference(String version, String targetRecordId) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Preconditions.checkNotNull(targetRecordId, "targetRecordId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("targetRecordId", "Edm.String", Checks.checkIsAscii(targetRecordId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Crmbaseentity>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PredictByReference"), Crmbaseentity.class, _parameters);
    }

    @Action(name = "PredictionSchema")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PredictionSchemaResponse> predictionSchema(String version, String predictionMode) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("predictionMode", "Edm.String", Checks.checkIsAscii(predictionMode))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PredictionSchemaResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.PredictionSchema"), PredictionSchemaResponse.class, _parameters);
    }

    @Action(name = "SchedulePrediction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<SchedulePredictionResponse> schedulePrediction(String version, Boolean predictImmediately, Boolean cleanupRequired) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("predictImmediately", "Edm.Boolean", predictImmediately)
            .put("cleanupRequired", "Edm.Boolean", cleanupRequired)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<SchedulePredictionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SchedulePrediction"), SchedulePredictionResponse.class, _parameters);
    }

    @Action(name = "ScheduleRetrain")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ScheduleRetrainResponse> scheduleRetrain(String recurrence, String version) {
        Preconditions.checkNotNull(recurrence, "recurrence cannot be null");
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("recurrence", "Edm.String", Checks.checkIsAscii(recurrence))
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ScheduleRetrainResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ScheduleRetrain"), ScheduleRetrainResponse.class, _parameters);
    }

    @Action(name = "UnschedulePrediction")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UnschedulePredictionResponse> unschedulePrediction(String version, Boolean skipStatusUpdate) {
        Preconditions.checkNotNull(version, "version cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("version", "Edm.String", Checks.checkIsAscii(version))
            .put("skipStatusUpdate", "Edm.Boolean", skipStatusUpdate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UnschedulePredictionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.UnschedulePrediction"), UnschedulePredictionResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_aimodel[");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_modelcreationcontext=");
        b.append(this.msdyn_modelcreationcontext);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_msdyn_activerunconfigurationid_value=");
        b.append(this._msdyn_activerunconfigurationid_value);
        b.append(", ");
        b.append("msdyn_sharewithorganizationoncreate=");
        b.append(this.msdyn_sharewithorganizationoncreate);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("msdyn_aimodelidunique=");
        b.append(this.msdyn_aimodelidunique);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_msdyn_scheduleinferenceworkflowid_value=");
        b.append(this._msdyn_scheduleinferenceworkflowid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_msdyn_retrainworkflowid_value=");
        b.append(this._msdyn_retrainworkflowid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("msdyn_aimodelid=");
        b.append(this.msdyn_aimodelid);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("_msdyn_templateid_value=");
        b.append(this._msdyn_templateid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
