package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.AssociatedMenuConfiguration;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.enums.RelationshipType;
import microsoft.dynamics.crm.enums.SecurityTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "Entity1AssociatedMenuConfiguration", 
    "Entity2AssociatedMenuConfiguration", 
    "Entity1LogicalName", 
    "Entity2LogicalName", 
    "IntersectEntityName", 
    "Entity1IntersectAttribute", 
    "Entity2IntersectAttribute", 
    "Entity1NavigationPropertyName", 
    "Entity2NavigationPropertyName"})
@JsonInclude(Include.NON_NULL)
public class ManyToManyRelationshipMetadata extends RelationshipMetadataBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata";
    }

    @JsonProperty("Entity1AssociatedMenuConfiguration")
    protected AssociatedMenuConfiguration entity1AssociatedMenuConfiguration;

    @JsonProperty("Entity2AssociatedMenuConfiguration")
    protected AssociatedMenuConfiguration entity2AssociatedMenuConfiguration;

    @JsonProperty("Entity1LogicalName")
    protected String entity1LogicalName;

    @JsonProperty("Entity2LogicalName")
    protected String entity2LogicalName;

    @JsonProperty("IntersectEntityName")
    protected String intersectEntityName;

    @JsonProperty("Entity1IntersectAttribute")
    protected String entity1IntersectAttribute;

    @JsonProperty("Entity2IntersectAttribute")
    protected String entity2IntersectAttribute;

    @JsonProperty("Entity1NavigationPropertyName")
    protected String entity1NavigationPropertyName;

    @JsonProperty("Entity2NavigationPropertyName")
    protected String entity2NavigationPropertyName;

    protected ManyToManyRelationshipMetadata() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderManyToManyRelationshipMetadata() {
        return new Builder();
    }

    public static final class Builder {
        private UUID metadataId;
        private Boolean hasChanged;
        private Boolean isCustomRelationship;
        private BooleanManagedProperty isCustomizable;
        private Boolean isValidForAdvancedFind;
        private String schemaName;
        private SecurityTypes securityTypes;
        private Boolean isManaged;
        private RelationshipType relationshipType;
        private String introducedVersion;
        private AssociatedMenuConfiguration entity1AssociatedMenuConfiguration;
        private AssociatedMenuConfiguration entity2AssociatedMenuConfiguration;
        private String entity1LogicalName;
        private String entity2LogicalName;
        private String intersectEntityName;
        private String entity1IntersectAttribute;
        private String entity2IntersectAttribute;
        private String entity1NavigationPropertyName;
        private String entity2NavigationPropertyName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public Builder isCustomRelationship(Boolean isCustomRelationship) {
            this.isCustomRelationship = isCustomRelationship;
            this.changedFields = changedFields.add("IsCustomRelationship");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isValidForAdvancedFind(Boolean isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder securityTypes(SecurityTypes securityTypes) {
            this.securityTypes = securityTypes;
            this.changedFields = changedFields.add("SecurityTypes");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType = relationshipType;
            this.changedFields = changedFields.add("RelationshipType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entity1AssociatedMenuConfiguration(AssociatedMenuConfiguration entity1AssociatedMenuConfiguration) {
            this.entity1AssociatedMenuConfiguration = entity1AssociatedMenuConfiguration;
            this.changedFields = changedFields.add("Entity1AssociatedMenuConfiguration");
            return this;
        }

        public Builder entity2AssociatedMenuConfiguration(AssociatedMenuConfiguration entity2AssociatedMenuConfiguration) {
            this.entity2AssociatedMenuConfiguration = entity2AssociatedMenuConfiguration;
            this.changedFields = changedFields.add("Entity2AssociatedMenuConfiguration");
            return this;
        }

        public Builder entity1LogicalName(String entity1LogicalName) {
            this.entity1LogicalName = entity1LogicalName;
            this.changedFields = changedFields.add("Entity1LogicalName");
            return this;
        }

        public Builder entity2LogicalName(String entity2LogicalName) {
            this.entity2LogicalName = entity2LogicalName;
            this.changedFields = changedFields.add("Entity2LogicalName");
            return this;
        }

        public Builder intersectEntityName(String intersectEntityName) {
            this.intersectEntityName = intersectEntityName;
            this.changedFields = changedFields.add("IntersectEntityName");
            return this;
        }

        public Builder entity1IntersectAttribute(String entity1IntersectAttribute) {
            this.entity1IntersectAttribute = entity1IntersectAttribute;
            this.changedFields = changedFields.add("Entity1IntersectAttribute");
            return this;
        }

        public Builder entity2IntersectAttribute(String entity2IntersectAttribute) {
            this.entity2IntersectAttribute = entity2IntersectAttribute;
            this.changedFields = changedFields.add("Entity2IntersectAttribute");
            return this;
        }

        public Builder entity1NavigationPropertyName(String entity1NavigationPropertyName) {
            this.entity1NavigationPropertyName = entity1NavigationPropertyName;
            this.changedFields = changedFields.add("Entity1NavigationPropertyName");
            return this;
        }

        public Builder entity2NavigationPropertyName(String entity2NavigationPropertyName) {
            this.entity2NavigationPropertyName = entity2NavigationPropertyName;
            this.changedFields = changedFields.add("Entity2NavigationPropertyName");
            return this;
        }

        public ManyToManyRelationshipMetadata build() {
            ManyToManyRelationshipMetadata _x = new ManyToManyRelationshipMetadata();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata";
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            _x.isCustomRelationship = isCustomRelationship;
            _x.isCustomizable = isCustomizable;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.schemaName = schemaName;
            _x.securityTypes = securityTypes;
            _x.isManaged = isManaged;
            _x.relationshipType = relationshipType;
            _x.introducedVersion = introducedVersion;
            _x.entity1AssociatedMenuConfiguration = entity1AssociatedMenuConfiguration;
            _x.entity2AssociatedMenuConfiguration = entity2AssociatedMenuConfiguration;
            _x.entity1LogicalName = entity1LogicalName;
            _x.entity2LogicalName = entity2LogicalName;
            _x.intersectEntityName = intersectEntityName;
            _x.entity1IntersectAttribute = entity1IntersectAttribute;
            _x.entity2IntersectAttribute = entity2IntersectAttribute;
            _x.entity1NavigationPropertyName = entity1NavigationPropertyName;
            _x.entity2NavigationPropertyName = entity2NavigationPropertyName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && metadataId != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(metadataId, UUID.class));
        }
    }

    @Property(name="Entity1AssociatedMenuConfiguration")
    @JsonIgnore
    public Optional<AssociatedMenuConfiguration> getEntity1AssociatedMenuConfiguration() {
        return Optional.ofNullable(entity1AssociatedMenuConfiguration);
    }

    public ManyToManyRelationshipMetadata withEntity1AssociatedMenuConfiguration(AssociatedMenuConfiguration entity1AssociatedMenuConfiguration) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity1AssociatedMenuConfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity1AssociatedMenuConfiguration = entity1AssociatedMenuConfiguration;
        return _x;
    }

    @Property(name="Entity2AssociatedMenuConfiguration")
    @JsonIgnore
    public Optional<AssociatedMenuConfiguration> getEntity2AssociatedMenuConfiguration() {
        return Optional.ofNullable(entity2AssociatedMenuConfiguration);
    }

    public ManyToManyRelationshipMetadata withEntity2AssociatedMenuConfiguration(AssociatedMenuConfiguration entity2AssociatedMenuConfiguration) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity2AssociatedMenuConfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity2AssociatedMenuConfiguration = entity2AssociatedMenuConfiguration;
        return _x;
    }

    @Property(name="Entity1LogicalName")
    @JsonIgnore
    public Optional<String> getEntity1LogicalName() {
        return Optional.ofNullable(entity1LogicalName);
    }

    public ManyToManyRelationshipMetadata withEntity1LogicalName(String entity1LogicalName) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity1LogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity1LogicalName = entity1LogicalName;
        return _x;
    }

    @Property(name="Entity2LogicalName")
    @JsonIgnore
    public Optional<String> getEntity2LogicalName() {
        return Optional.ofNullable(entity2LogicalName);
    }

    public ManyToManyRelationshipMetadata withEntity2LogicalName(String entity2LogicalName) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity2LogicalName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity2LogicalName = entity2LogicalName;
        return _x;
    }

    @Property(name="IntersectEntityName")
    @JsonIgnore
    public Optional<String> getIntersectEntityName() {
        return Optional.ofNullable(intersectEntityName);
    }

    public ManyToManyRelationshipMetadata withIntersectEntityName(String intersectEntityName) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("IntersectEntityName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.intersectEntityName = intersectEntityName;
        return _x;
    }

    @Property(name="Entity1IntersectAttribute")
    @JsonIgnore
    public Optional<String> getEntity1IntersectAttribute() {
        return Optional.ofNullable(entity1IntersectAttribute);
    }

    public ManyToManyRelationshipMetadata withEntity1IntersectAttribute(String entity1IntersectAttribute) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity1IntersectAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity1IntersectAttribute = entity1IntersectAttribute;
        return _x;
    }

    @Property(name="Entity2IntersectAttribute")
    @JsonIgnore
    public Optional<String> getEntity2IntersectAttribute() {
        return Optional.ofNullable(entity2IntersectAttribute);
    }

    public ManyToManyRelationshipMetadata withEntity2IntersectAttribute(String entity2IntersectAttribute) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity2IntersectAttribute");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity2IntersectAttribute = entity2IntersectAttribute;
        return _x;
    }

    @Property(name="Entity1NavigationPropertyName")
    @JsonIgnore
    public Optional<String> getEntity1NavigationPropertyName() {
        return Optional.ofNullable(entity1NavigationPropertyName);
    }

    public ManyToManyRelationshipMetadata withEntity1NavigationPropertyName(String entity1NavigationPropertyName) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity1NavigationPropertyName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity1NavigationPropertyName = entity1NavigationPropertyName;
        return _x;
    }

    @Property(name="Entity2NavigationPropertyName")
    @JsonIgnore
    public Optional<String> getEntity2NavigationPropertyName() {
        return Optional.ofNullable(entity2NavigationPropertyName);
    }

    public ManyToManyRelationshipMetadata withEntity2NavigationPropertyName(String entity2NavigationPropertyName) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = changedFields.add("Entity2NavigationPropertyName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ManyToManyRelationshipMetadata");
        _x.entity2NavigationPropertyName = entity2NavigationPropertyName;
        return _x;
    }

    public ManyToManyRelationshipMetadata withUnmappedField(String name, Object value) {
        ManyToManyRelationshipMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManyToManyRelationshipMetadata patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ManyToManyRelationshipMetadata put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ManyToManyRelationshipMetadata _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ManyToManyRelationshipMetadata _copy() {
        ManyToManyRelationshipMetadata _x = new ManyToManyRelationshipMetadata();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        _x.isCustomRelationship = isCustomRelationship;
        _x.isCustomizable = isCustomizable;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.schemaName = schemaName;
        _x.securityTypes = securityTypes;
        _x.isManaged = isManaged;
        _x.relationshipType = relationshipType;
        _x.introducedVersion = introducedVersion;
        _x.entity1AssociatedMenuConfiguration = entity1AssociatedMenuConfiguration;
        _x.entity2AssociatedMenuConfiguration = entity2AssociatedMenuConfiguration;
        _x.entity1LogicalName = entity1LogicalName;
        _x.entity2LogicalName = entity2LogicalName;
        _x.intersectEntityName = intersectEntityName;
        _x.entity1IntersectAttribute = entity1IntersectAttribute;
        _x.entity2IntersectAttribute = entity2IntersectAttribute;
        _x.entity1NavigationPropertyName = entity1NavigationPropertyName;
        _x.entity2NavigationPropertyName = entity2NavigationPropertyName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ManyToManyRelationshipMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("IsCustomRelationship=");
        b.append(this.isCustomRelationship);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("SecurityTypes=");
        b.append(this.securityTypes);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("RelationshipType=");
        b.append(this.relationshipType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("Entity1AssociatedMenuConfiguration=");
        b.append(this.entity1AssociatedMenuConfiguration);
        b.append(", ");
        b.append("Entity2AssociatedMenuConfiguration=");
        b.append(this.entity2AssociatedMenuConfiguration);
        b.append(", ");
        b.append("Entity1LogicalName=");
        b.append(this.entity1LogicalName);
        b.append(", ");
        b.append("Entity2LogicalName=");
        b.append(this.entity2LogicalName);
        b.append(", ");
        b.append("IntersectEntityName=");
        b.append(this.intersectEntityName);
        b.append(", ");
        b.append("Entity1IntersectAttribute=");
        b.append(this.entity1IntersectAttribute);
        b.append(", ");
        b.append("Entity2IntersectAttribute=");
        b.append(this.entity2IntersectAttribute);
        b.append(", ");
        b.append("Entity1NavigationPropertyName=");
        b.append(this.entity1NavigationPropertyName);
        b.append(", ");
        b.append("Entity2NavigationPropertyName=");
        b.append(this.entity2NavigationPropertyName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
