package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "emailactivityid", 
    "emailinteractiontime", 
    "_owningbusinessunit_value", 
    "interactionreplyid", 
    "exchangerate", 
    "interactionforemailid", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "_owninguser_value", 
    "interactionlocation", 
    "emailaddress", 
    "versionnumber", 
    "_createdby_value", 
    "statecode", 
    "name", 
    "emailinteractionreplyid", 
    "overriddencreatedon", 
    "timezoneruleversionnumber", 
    "createdon", 
    "utcconversiontimezonecode", 
    "interactionrepliedby", 
    "_owningteam_value", 
    "interactionpartyid", 
    "importsequencenumber", 
    "interactedcomponenttext", 
    "_modifiedonbehalfby_value", 
    "_transactioncurrencyid_value", 
    "statuscode", 
    "_modifiedby_value", 
    "interactiontype", 
    "_ownerid_value", 
    "interactionuseragent"})
@JsonInclude(Include.NON_NULL)
public class Interactionforemail extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.interactionforemail";
    }

    @JsonProperty("emailactivityid")
    protected UUID emailactivityid;

    @JsonProperty("emailinteractiontime")
    protected OffsetDateTime emailinteractiontime;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("interactionreplyid")
    protected String interactionreplyid;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("interactionforemailid")
    protected UUID interactionforemailid;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("interactionlocation")
    protected String interactionlocation;

    @JsonProperty("emailaddress")
    protected String emailaddress;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("emailinteractionreplyid")
    protected UUID emailinteractionreplyid;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("interactionrepliedby")
    protected String interactionrepliedby;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("interactionpartyid")
    protected UUID interactionpartyid;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("interactedcomponenttext")
    protected String interactedcomponenttext;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("interactiontype")
    protected Integer interactiontype;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("interactionuseragent")
    protected String interactionuseragent;

    protected Interactionforemail() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderInteractionforemail() {
        return new Builder();
    }

    public static final class Builder {
        private UUID emailactivityid;
        private OffsetDateTime emailinteractiontime;
        private UUID _owningbusinessunit_value;
        private String interactionreplyid;
        private BigDecimal exchangerate;
        private UUID interactionforemailid;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private UUID _owninguser_value;
        private String interactionlocation;
        private String emailaddress;
        private Long versionnumber;
        private UUID _createdby_value;
        private Integer statecode;
        private String name;
        private UUID emailinteractionreplyid;
        private OffsetDateTime overriddencreatedon;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime createdon;
        private Integer utcconversiontimezonecode;
        private String interactionrepliedby;
        private UUID _owningteam_value;
        private UUID interactionpartyid;
        private Integer importsequencenumber;
        private String interactedcomponenttext;
        private UUID _modifiedonbehalfby_value;
        private UUID _transactioncurrencyid_value;
        private Integer statuscode;
        private UUID _modifiedby_value;
        private Integer interactiontype;
        private UUID _ownerid_value;
        private String interactionuseragent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder emailactivityid(UUID emailactivityid) {
            this.emailactivityid = emailactivityid;
            this.changedFields = changedFields.add("emailactivityid");
            return this;
        }

        public Builder emailinteractiontime(OffsetDateTime emailinteractiontime) {
            this.emailinteractiontime = emailinteractiontime;
            this.changedFields = changedFields.add("emailinteractiontime");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder interactionreplyid(String interactionreplyid) {
            this.interactionreplyid = interactionreplyid;
            this.changedFields = changedFields.add("interactionreplyid");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder interactionforemailid(UUID interactionforemailid) {
            this.interactionforemailid = interactionforemailid;
            this.changedFields = changedFields.add("interactionforemailid");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder interactionlocation(String interactionlocation) {
            this.interactionlocation = interactionlocation;
            this.changedFields = changedFields.add("interactionlocation");
            return this;
        }

        public Builder emailaddress(String emailaddress) {
            this.emailaddress = emailaddress;
            this.changedFields = changedFields.add("emailaddress");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder emailinteractionreplyid(UUID emailinteractionreplyid) {
            this.emailinteractionreplyid = emailinteractionreplyid;
            this.changedFields = changedFields.add("emailinteractionreplyid");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder interactionrepliedby(String interactionrepliedby) {
            this.interactionrepliedby = interactionrepliedby;
            this.changedFields = changedFields.add("interactionrepliedby");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder interactionpartyid(UUID interactionpartyid) {
            this.interactionpartyid = interactionpartyid;
            this.changedFields = changedFields.add("interactionpartyid");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder interactedcomponenttext(String interactedcomponenttext) {
            this.interactedcomponenttext = interactedcomponenttext;
            this.changedFields = changedFields.add("interactedcomponenttext");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder interactiontype(Integer interactiontype) {
            this.interactiontype = interactiontype;
            this.changedFields = changedFields.add("interactiontype");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder interactionuseragent(String interactionuseragent) {
            this.interactionuseragent = interactionuseragent;
            this.changedFields = changedFields.add("interactionuseragent");
            return this;
        }

        public Interactionforemail build() {
            Interactionforemail _x = new Interactionforemail();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.interactionforemail";
            _x.emailactivityid = emailactivityid;
            _x.emailinteractiontime = emailinteractiontime;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.interactionreplyid = interactionreplyid;
            _x.exchangerate = exchangerate;
            _x.interactionforemailid = interactionforemailid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x._owninguser_value = _owninguser_value;
            _x.interactionlocation = interactionlocation;
            _x.emailaddress = emailaddress;
            _x.versionnumber = versionnumber;
            _x._createdby_value = _createdby_value;
            _x.statecode = statecode;
            _x.name = name;
            _x.emailinteractionreplyid = emailinteractionreplyid;
            _x.overriddencreatedon = overriddencreatedon;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.createdon = createdon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.interactionrepliedby = interactionrepliedby;
            _x._owningteam_value = _owningteam_value;
            _x.interactionpartyid = interactionpartyid;
            _x.importsequencenumber = importsequencenumber;
            _x.interactedcomponenttext = interactedcomponenttext;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.statuscode = statuscode;
            _x._modifiedby_value = _modifiedby_value;
            _x.interactiontype = interactiontype;
            _x._ownerid_value = _ownerid_value;
            _x.interactionuseragent = interactionuseragent;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && interactionforemailid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(interactionforemailid, UUID.class));
        }
    }

    @Property(name="emailactivityid")
    @JsonIgnore
    public Optional<UUID> getEmailactivityid() {
        return Optional.ofNullable(emailactivityid);
    }

    public Interactionforemail withEmailactivityid(UUID emailactivityid) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("emailactivityid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.emailactivityid = emailactivityid;
        return _x;
    }

    @Property(name="emailinteractiontime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEmailinteractiontime() {
        return Optional.ofNullable(emailinteractiontime);
    }

    public Interactionforemail withEmailinteractiontime(OffsetDateTime emailinteractiontime) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("emailinteractiontime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.emailinteractiontime = emailinteractiontime;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Interactionforemail with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="interactionreplyid")
    @JsonIgnore
    public Optional<String> getInteractionreplyid() {
        return Optional.ofNullable(interactionreplyid);
    }

    public Interactionforemail withInteractionreplyid(String interactionreplyid) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactionreplyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactionreplyid = interactionreplyid;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Interactionforemail withExchangerate(BigDecimal exchangerate) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="interactionforemailid")
    @JsonIgnore
    public Optional<UUID> getInteractionforemailid() {
        return Optional.ofNullable(interactionforemailid);
    }

    public Interactionforemail withInteractionforemailid(UUID interactionforemailid) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactionforemailid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactionforemailid = interactionforemailid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Interactionforemail with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Interactionforemail withModifiedon(OffsetDateTime modifiedon) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Interactionforemail with_owninguser_value(UUID _owninguser_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="interactionlocation")
    @JsonIgnore
    public Optional<String> getInteractionlocation() {
        return Optional.ofNullable(interactionlocation);
    }

    public Interactionforemail withInteractionlocation(String interactionlocation) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactionlocation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactionlocation = interactionlocation;
        return _x;
    }

    @Property(name="emailaddress")
    @JsonIgnore
    public Optional<String> getEmailaddress() {
        return Optional.ofNullable(emailaddress);
    }

    public Interactionforemail withEmailaddress(String emailaddress) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("emailaddress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.emailaddress = emailaddress;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Interactionforemail withVersionnumber(Long versionnumber) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Interactionforemail with_createdby_value(UUID _createdby_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Interactionforemail withStatecode(Integer statecode) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Interactionforemail withName(String name) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.name = name;
        return _x;
    }

    @Property(name="emailinteractionreplyid")
    @JsonIgnore
    public Optional<UUID> getEmailinteractionreplyid() {
        return Optional.ofNullable(emailinteractionreplyid);
    }

    public Interactionforemail withEmailinteractionreplyid(UUID emailinteractionreplyid) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("emailinteractionreplyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.emailinteractionreplyid = emailinteractionreplyid;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Interactionforemail withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Interactionforemail withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Interactionforemail withCreatedon(OffsetDateTime createdon) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Interactionforemail withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="interactionrepliedby")
    @JsonIgnore
    public Optional<String> getInteractionrepliedby() {
        return Optional.ofNullable(interactionrepliedby);
    }

    public Interactionforemail withInteractionrepliedby(String interactionrepliedby) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactionrepliedby");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactionrepliedby = interactionrepliedby;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Interactionforemail with_owningteam_value(UUID _owningteam_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="interactionpartyid")
    @JsonIgnore
    public Optional<UUID> getInteractionpartyid() {
        return Optional.ofNullable(interactionpartyid);
    }

    public Interactionforemail withInteractionpartyid(UUID interactionpartyid) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactionpartyid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactionpartyid = interactionpartyid;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Interactionforemail withImportsequencenumber(Integer importsequencenumber) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="interactedcomponenttext")
    @JsonIgnore
    public Optional<String> getInteractedcomponenttext() {
        return Optional.ofNullable(interactedcomponenttext);
    }

    public Interactionforemail withInteractedcomponenttext(String interactedcomponenttext) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactedcomponenttext");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactedcomponenttext = interactedcomponenttext;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Interactionforemail with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Interactionforemail with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Interactionforemail withStatuscode(Integer statuscode) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Interactionforemail with_modifiedby_value(UUID _modifiedby_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="interactiontype")
    @JsonIgnore
    public Optional<Integer> getInteractiontype() {
        return Optional.ofNullable(interactiontype);
    }

    public Interactionforemail withInteractiontype(Integer interactiontype) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactiontype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactiontype = interactiontype;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Interactionforemail with_ownerid_value(UUID _ownerid_value) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="interactionuseragent")
    @JsonIgnore
    public Optional<String> getInteractionuseragent() {
        return Optional.ofNullable(interactionuseragent);
    }

    public Interactionforemail withInteractionuseragent(String interactionuseragent) {
        Interactionforemail _x = _copy();
        _x.changedFields = changedFields.add("interactionuseragent");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.interactionforemail");
        _x.interactionuseragent = interactionuseragent;
        return _x;
    }

    public Interactionforemail withUnmappedField(String name, Object value) {
        Interactionforemail _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdbyname")
    @JsonIgnore
    public SystemuserRequest getCreatedbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdbyname"), RequestHelper.getValue(unmappedFields, "createdbyname"));
    }

    @NavigationProperty(name="createdonbehalfbyname")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfbyname"), RequestHelper.getValue(unmappedFields, "createdonbehalfbyname"));
    }

    @NavigationProperty(name="modifiedbyname")
    @JsonIgnore
    public SystemuserRequest getModifiedbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedbyname"), RequestHelper.getValue(unmappedFields, "modifiedbyname"));
    }

    @NavigationProperty(name="modifiedonbehalfbyname")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfbyname() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfbyname"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfbyname"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="new_interactionforemail_ActivityPointers")
    @JsonIgnore
    public ActivitypointerCollectionRequest getNew_interactionforemail_ActivityPointers() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("new_interactionforemail_ActivityPointers"), RequestHelper.getValue(unmappedFields, "new_interactionforemail_ActivityPointers"));
    }

    @NavigationProperty(name="new_interactionforemail_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getNew_interactionforemail_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("new_interactionforemail_AsyncOperations"), RequestHelper.getValue(unmappedFields, "new_interactionforemail_AsyncOperations"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Interactionforemail patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Interactionforemail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Interactionforemail put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Interactionforemail _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Interactionforemail _copy() {
        Interactionforemail _x = new Interactionforemail();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.emailactivityid = emailactivityid;
        _x.emailinteractiontime = emailinteractiontime;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.interactionreplyid = interactionreplyid;
        _x.exchangerate = exchangerate;
        _x.interactionforemailid = interactionforemailid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x._owninguser_value = _owninguser_value;
        _x.interactionlocation = interactionlocation;
        _x.emailaddress = emailaddress;
        _x.versionnumber = versionnumber;
        _x._createdby_value = _createdby_value;
        _x.statecode = statecode;
        _x.name = name;
        _x.emailinteractionreplyid = emailinteractionreplyid;
        _x.overriddencreatedon = overriddencreatedon;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.createdon = createdon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.interactionrepliedby = interactionrepliedby;
        _x._owningteam_value = _owningteam_value;
        _x.interactionpartyid = interactionpartyid;
        _x.importsequencenumber = importsequencenumber;
        _x.interactedcomponenttext = interactedcomponenttext;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.statuscode = statuscode;
        _x._modifiedby_value = _modifiedby_value;
        _x.interactiontype = interactiontype;
        _x._ownerid_value = _ownerid_value;
        _x.interactionuseragent = interactionuseragent;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Interactionforemail[");
        b.append("emailactivityid=");
        b.append(this.emailactivityid);
        b.append(", ");
        b.append("emailinteractiontime=");
        b.append(this.emailinteractiontime);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("interactionreplyid=");
        b.append(this.interactionreplyid);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("interactionforemailid=");
        b.append(this.interactionforemailid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("interactionlocation=");
        b.append(this.interactionlocation);
        b.append(", ");
        b.append("emailaddress=");
        b.append(this.emailaddress);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("emailinteractionreplyid=");
        b.append(this.emailinteractionreplyid);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("interactionrepliedby=");
        b.append(this.interactionrepliedby);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("interactionpartyid=");
        b.append(this.interactionpartyid);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("interactedcomponenttext=");
        b.append(this.interactedcomponenttext);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("interactiontype=");
        b.append(this.interactiontype);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("interactionuseragent=");
        b.append(this.interactionuseragent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
