package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "sendnotification", 
    "_createdonbehalfby_value", 
    "modifiedon", 
    "_modifiedby_value", 
    "createdon", 
    "statecode", 
    "_modifiedonbehalfby_value", 
    "_owningbusinessunit_value", 
    "sequence", 
    "statuscode", 
    "_ownerid_value", 
    "name", 
    "_owninguser_value", 
    "emailaddress", 
    "modecode", 
    "importid", 
    "_owningteam_value", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Import extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.import";
    }

    @JsonProperty("sendnotification")
    protected Boolean sendnotification;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("sequence")
    protected Integer sequence;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("emailaddress")
    protected String emailaddress;

    @JsonProperty("modecode")
    protected Integer modecode;

    @JsonProperty("importid")
    protected UUID importid;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    protected Import() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImport() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean sendnotification;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime modifiedon;
        private UUID _modifiedby_value;
        private OffsetDateTime createdon;
        private Integer statecode;
        private UUID _modifiedonbehalfby_value;
        private UUID _owningbusinessunit_value;
        private Integer sequence;
        private Integer statuscode;
        private UUID _ownerid_value;
        private String name;
        private UUID _owninguser_value;
        private String emailaddress;
        private Integer modecode;
        private UUID importid;
        private UUID _owningteam_value;
        private UUID _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder sendnotification(Boolean sendnotification) {
            this.sendnotification = sendnotification;
            this.changedFields = changedFields.add("sendnotification");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            this.changedFields = changedFields.add("sequence");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder emailaddress(String emailaddress) {
            this.emailaddress = emailaddress;
            this.changedFields = changedFields.add("emailaddress");
            return this;
        }

        public Builder modecode(Integer modecode) {
            this.modecode = modecode;
            this.changedFields = changedFields.add("modecode");
            return this;
        }

        public Builder importid(UUID importid) {
            this.importid = importid;
            this.changedFields = changedFields.add("importid");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Import build() {
            Import _x = new Import();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.import";
            _x.sendnotification = sendnotification;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.createdon = createdon;
            _x.statecode = statecode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.sequence = sequence;
            _x.statuscode = statuscode;
            _x._ownerid_value = _ownerid_value;
            _x.name = name;
            _x._owninguser_value = _owninguser_value;
            _x.emailaddress = emailaddress;
            _x.modecode = modecode;
            _x.importid = importid;
            _x._owningteam_value = _owningteam_value;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importid, UUID.class));
        }
    }

    @Property(name="sendnotification")
    @JsonIgnore
    public Optional<Boolean> getSendnotification() {
        return Optional.ofNullable(sendnotification);
    }

    public Import withSendnotification(Boolean sendnotification) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("sendnotification");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.sendnotification = sendnotification;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Import with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Import withModifiedon(OffsetDateTime modifiedon) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Import with_modifiedby_value(UUID _modifiedby_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Import withCreatedon(OffsetDateTime createdon) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Import withStatecode(Integer statecode) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Import with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Import with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="sequence")
    @JsonIgnore
    public Optional<Integer> getSequence() {
        return Optional.ofNullable(sequence);
    }

    public Import withSequence(Integer sequence) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("sequence");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.sequence = sequence;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Import withStatuscode(Integer statuscode) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Import with_ownerid_value(UUID _ownerid_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Import withName(String name) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.name = name;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Import with_owninguser_value(UUID _owninguser_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="emailaddress")
    @JsonIgnore
    public Optional<String> getEmailaddress() {
        return Optional.ofNullable(emailaddress);
    }

    public Import withEmailaddress(String emailaddress) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("emailaddress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.emailaddress = emailaddress;
        return _x;
    }

    @Property(name="modecode")
    @JsonIgnore
    public Optional<Integer> getModecode() {
        return Optional.ofNullable(modecode);
    }

    public Import withModecode(Integer modecode) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("modecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.modecode = modecode;
        return _x;
    }

    @Property(name="importid")
    @JsonIgnore
    public Optional<UUID> getImportid() {
        return Optional.ofNullable(importid);
    }

    public Import withImportid(UUID importid) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("importid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x.importid = importid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Import with_owningteam_value(UUID _owningteam_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Import with_createdby_value(UUID _createdby_value) {
        Import _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.import");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Import withUnmappedField(String name, Object value) {
        Import _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="Import_ImportFile")
    @JsonIgnore
    public ImportfileCollectionRequest getImport_ImportFile() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("Import_ImportFile"), RequestHelper.getValue(unmappedFields, "Import_ImportFile"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="Import_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getImport_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Import_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Import_BulkDeleteFailures"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="Import_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getImport_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Import_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Import_AsyncOperations"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Import patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Import _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Import put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Import _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Import _copy() {
        Import _x = new Import();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.sendnotification = sendnotification;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.createdon = createdon;
        _x.statecode = statecode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.sequence = sequence;
        _x.statuscode = statuscode;
        _x._ownerid_value = _ownerid_value;
        _x.name = name;
        _x._owninguser_value = _owninguser_value;
        _x.emailaddress = emailaddress;
        _x.modecode = modecode;
        _x.importid = importid;
        _x._owningteam_value = _owningteam_value;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Action(name = "ImportRecordsImport")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Asyncoperation> importRecordsImport() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Asyncoperation>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ImportRecordsImport"), Asyncoperation.class, _parameters);
    }

    @Action(name = "ParseImport")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Asyncoperation> parseImport() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Asyncoperation>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ParseImport"), Asyncoperation.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Import[");
        b.append("sendnotification=");
        b.append(this.sendnotification);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("sequence=");
        b.append(this.sequence);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("emailaddress=");
        b.append(this.emailaddress);
        b.append(", ");
        b.append("modecode=");
        b.append(this.modecode);
        b.append(", ");
        b.append("importid=");
        b.append(this.importid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
