package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "overriddencreatedon", 
    "_owninguser_value", 
    "_ownerid_value", 
    "ggw_application_status", 
    "timezoneruleversionnumber", 
    "_ggw_teamid_value", 
    "_owningbusinessunit_value", 
    "statecode", 
    "versionnumber", 
    "importsequencenumber", 
    "modifiedon", 
    "_modifiedby_value", 
    "_owningteam_value", 
    "_ggw_crewid_value", 
    "statuscode", 
    "_modifiedonbehalfby_value", 
    "ggw_team_applicationid", 
    "ggw_name", 
    "utcconversiontimezonecode", 
    "_createdonbehalfby_value", 
    "createdon", 
    "_createdby_value"})
@JsonInclude(Include.NON_NULL)
public class Ggw_team_application extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ggw_team_application";
    }

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("ggw_application_status")
    protected Integer ggw_application_status;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_ggw_teamid_value")
    protected UUID _ggw_teamid_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("_ggw_crewid_value")
    protected UUID _ggw_crewid_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("ggw_team_applicationid")
    protected UUID ggw_team_applicationid;

    @JsonProperty("ggw_name")
    protected String ggw_name;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    protected Ggw_team_application() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderGgw_team_application() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime overriddencreatedon;
        private UUID _owninguser_value;
        private UUID _ownerid_value;
        private Integer ggw_application_status;
        private Integer timezoneruleversionnumber;
        private UUID _ggw_teamid_value;
        private UUID _owningbusinessunit_value;
        private Integer statecode;
        private Long versionnumber;
        private Integer importsequencenumber;
        private OffsetDateTime modifiedon;
        private UUID _modifiedby_value;
        private UUID _owningteam_value;
        private UUID _ggw_crewid_value;
        private Integer statuscode;
        private UUID _modifiedonbehalfby_value;
        private UUID ggw_team_applicationid;
        private String ggw_name;
        private Integer utcconversiontimezonecode;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private UUID _createdby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder ggw_application_status(Integer ggw_application_status) {
            this.ggw_application_status = ggw_application_status;
            this.changedFields = changedFields.add("ggw_application_status");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _ggw_teamid_value(UUID _ggw_teamid_value) {
            this._ggw_teamid_value = _ggw_teamid_value;
            this.changedFields = changedFields.add("_ggw_teamid_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder _ggw_crewid_value(UUID _ggw_crewid_value) {
            this._ggw_crewid_value = _ggw_crewid_value;
            this.changedFields = changedFields.add("_ggw_crewid_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder ggw_team_applicationid(UUID ggw_team_applicationid) {
            this.ggw_team_applicationid = ggw_team_applicationid;
            this.changedFields = changedFields.add("ggw_team_applicationid");
            return this;
        }

        public Builder ggw_name(String ggw_name) {
            this.ggw_name = ggw_name;
            this.changedFields = changedFields.add("ggw_name");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Ggw_team_application build() {
            Ggw_team_application _x = new Ggw_team_application();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ggw_team_application";
            _x.overriddencreatedon = overriddencreatedon;
            _x._owninguser_value = _owninguser_value;
            _x._ownerid_value = _ownerid_value;
            _x.ggw_application_status = ggw_application_status;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._ggw_teamid_value = _ggw_teamid_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.statecode = statecode;
            _x.versionnumber = versionnumber;
            _x.importsequencenumber = importsequencenumber;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x._owningteam_value = _owningteam_value;
            _x._ggw_crewid_value = _ggw_crewid_value;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.ggw_team_applicationid = ggw_team_applicationid;
            _x.ggw_name = ggw_name;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ggw_team_applicationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ggw_team_applicationid, UUID.class));
        }
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Ggw_team_application withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Ggw_team_application with_owninguser_value(UUID _owninguser_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Ggw_team_application with_ownerid_value(UUID _ownerid_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="ggw_application_status")
    @JsonIgnore
    public Optional<Integer> getGgw_application_status() {
        return Optional.ofNullable(ggw_application_status);
    }

    public Ggw_team_application withGgw_application_status(Integer ggw_application_status) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("ggw_application_status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.ggw_application_status = ggw_application_status;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Ggw_team_application withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_ggw_teamid_value")
    @JsonIgnore
    public Optional<UUID> get_ggw_teamid_value() {
        return Optional.ofNullable(_ggw_teamid_value);
    }

    public Ggw_team_application with_ggw_teamid_value(UUID _ggw_teamid_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_ggw_teamid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._ggw_teamid_value = _ggw_teamid_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Ggw_team_application with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Ggw_team_application withStatecode(Integer statecode) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Ggw_team_application withVersionnumber(Long versionnumber) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Ggw_team_application withImportsequencenumber(Integer importsequencenumber) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Ggw_team_application withModifiedon(OffsetDateTime modifiedon) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Ggw_team_application with_modifiedby_value(UUID _modifiedby_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Ggw_team_application with_owningteam_value(UUID _owningteam_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="_ggw_crewid_value")
    @JsonIgnore
    public Optional<UUID> get_ggw_crewid_value() {
        return Optional.ofNullable(_ggw_crewid_value);
    }

    public Ggw_team_application with_ggw_crewid_value(UUID _ggw_crewid_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_ggw_crewid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._ggw_crewid_value = _ggw_crewid_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Ggw_team_application withStatuscode(Integer statuscode) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Ggw_team_application with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="ggw_team_applicationid")
    @JsonIgnore
    public Optional<UUID> getGgw_team_applicationid() {
        return Optional.ofNullable(ggw_team_applicationid);
    }

    public Ggw_team_application withGgw_team_applicationid(UUID ggw_team_applicationid) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("ggw_team_applicationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.ggw_team_applicationid = ggw_team_applicationid;
        return _x;
    }

    @Property(name="ggw_name")
    @JsonIgnore
    public Optional<String> getGgw_name() {
        return Optional.ofNullable(ggw_name);
    }

    public Ggw_team_application withGgw_name(String ggw_name) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("ggw_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.ggw_name = ggw_name;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Ggw_team_application withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Ggw_team_application with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Ggw_team_application withCreatedon(OffsetDateTime createdon) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Ggw_team_application with_createdby_value(UUID _createdby_value) {
        Ggw_team_application _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ggw_team_application");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    public Ggw_team_application withUnmappedField(String name, Object value) {
        Ggw_team_application _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="ggw_team_application_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getGgw_team_application_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("ggw_team_application_SyncErrors"), RequestHelper.getValue(unmappedFields, "ggw_team_application_SyncErrors"));
    }

    @NavigationProperty(name="ggw_team_application_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGgw_team_application_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("ggw_team_application_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "ggw_team_application_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="ggw_team_application_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getGgw_team_application_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("ggw_team_application_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "ggw_team_application_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="ggw_team_application_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getGgw_team_application_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("ggw_team_application_AsyncOperations"), RequestHelper.getValue(unmappedFields, "ggw_team_application_AsyncOperations"));
    }

    @NavigationProperty(name="ggw_team_application_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getGgw_team_application_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("ggw_team_application_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "ggw_team_application_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="ggw_team_application_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getGgw_team_application_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("ggw_team_application_ProcessSession"), RequestHelper.getValue(unmappedFields, "ggw_team_application_ProcessSession"));
    }

    @NavigationProperty(name="ggw_team_application_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getGgw_team_application_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("ggw_team_application_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "ggw_team_application_BulkDeleteFailures"));
    }

    @NavigationProperty(name="ggw_team_application_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getGgw_team_application_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("ggw_team_application_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "ggw_team_application_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="ggw_CrewId")
    @JsonIgnore
    public Ggw_crewRequest getGgw_CrewId() {
        return new Ggw_crewRequest(contextPath.addSegment("ggw_CrewId"), RequestHelper.getValue(unmappedFields, "ggw_CrewId"));
    }

    @NavigationProperty(name="ggw_TeamId")
    @JsonIgnore
    public Ggw_teamRequest getGgw_TeamId() {
        return new Ggw_teamRequest(contextPath.addSegment("ggw_TeamId"), RequestHelper.getValue(unmappedFields, "ggw_TeamId"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_team_application patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Ggw_team_application _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ggw_team_application put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Ggw_team_application _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Ggw_team_application _copy() {
        Ggw_team_application _x = new Ggw_team_application();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.overriddencreatedon = overriddencreatedon;
        _x._owninguser_value = _owninguser_value;
        _x._ownerid_value = _ownerid_value;
        _x.ggw_application_status = ggw_application_status;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._ggw_teamid_value = _ggw_teamid_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.statecode = statecode;
        _x.versionnumber = versionnumber;
        _x.importsequencenumber = importsequencenumber;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x._owningteam_value = _owningteam_value;
        _x._ggw_crewid_value = _ggw_crewid_value;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.ggw_team_applicationid = ggw_team_applicationid;
        _x.ggw_name = ggw_name;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ggw_team_application[");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("ggw_application_status=");
        b.append(this.ggw_application_status);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_ggw_teamid_value=");
        b.append(this._ggw_teamid_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("_ggw_crewid_value=");
        b.append(this._ggw_crewid_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("ggw_team_applicationid=");
        b.append(this.ggw_team_applicationid);
        b.append(", ");
        b.append("ggw_name=");
        b.append(this.ggw_name);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
