package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "customdisplaystring", 
    "modifiedon", 
    "_organizationid_value", 
    "componentstate", 
    "languagecode", 
    "ismanaged", 
    "displaystringid", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "customcomment", 
    "displaystringidunique", 
    "formatparameters", 
    "_createdonbehalfby_value", 
    "publisheddisplaystring", 
    "versionnumber", 
    "overwritetime", 
    "_createdby_value", 
    "displaystringkey", 
    "_modifiedby_value", 
    "solutionid"})
@JsonInclude(Include.NON_NULL)
public class Displaystring extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.displaystring";
    }

    @JsonProperty("customdisplaystring")
    protected String customdisplaystring;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("displaystringid")
    protected UUID displaystringid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("customcomment")
    protected String customcomment;

    @JsonProperty("displaystringidunique")
    protected UUID displaystringidunique;

    @JsonProperty("formatparameters")
    protected Integer formatparameters;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("publisheddisplaystring")
    protected String publisheddisplaystring;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("displaystringkey")
    protected String displaystringkey;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    protected Displaystring() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDisplaystring() {
        return new Builder();
    }

    public static final class Builder {
        private String customdisplaystring;
        private OffsetDateTime modifiedon;
        private UUID _organizationid_value;
        private Integer componentstate;
        private Integer languagecode;
        private Boolean ismanaged;
        private UUID displaystringid;
        private UUID _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private String customcomment;
        private UUID displaystringidunique;
        private Integer formatparameters;
        private UUID _createdonbehalfby_value;
        private String publisheddisplaystring;
        private Long versionnumber;
        private OffsetDateTime overwritetime;
        private UUID _createdby_value;
        private String displaystringkey;
        private UUID _modifiedby_value;
        private UUID solutionid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder customdisplaystring(String customdisplaystring) {
            this.customdisplaystring = customdisplaystring;
            this.changedFields = changedFields.add("customdisplaystring");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder displaystringid(UUID displaystringid) {
            this.displaystringid = displaystringid;
            this.changedFields = changedFields.add("displaystringid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder customcomment(String customcomment) {
            this.customcomment = customcomment;
            this.changedFields = changedFields.add("customcomment");
            return this;
        }

        public Builder displaystringidunique(UUID displaystringidunique) {
            this.displaystringidunique = displaystringidunique;
            this.changedFields = changedFields.add("displaystringidunique");
            return this;
        }

        public Builder formatparameters(Integer formatparameters) {
            this.formatparameters = formatparameters;
            this.changedFields = changedFields.add("formatparameters");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder publisheddisplaystring(String publisheddisplaystring) {
            this.publisheddisplaystring = publisheddisplaystring;
            this.changedFields = changedFields.add("publisheddisplaystring");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder displaystringkey(String displaystringkey) {
            this.displaystringkey = displaystringkey;
            this.changedFields = changedFields.add("displaystringkey");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Displaystring build() {
            Displaystring _x = new Displaystring();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.displaystring";
            _x.customdisplaystring = customdisplaystring;
            _x.modifiedon = modifiedon;
            _x._organizationid_value = _organizationid_value;
            _x.componentstate = componentstate;
            _x.languagecode = languagecode;
            _x.ismanaged = ismanaged;
            _x.displaystringid = displaystringid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x.customcomment = customcomment;
            _x.displaystringidunique = displaystringidunique;
            _x.formatparameters = formatparameters;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.publisheddisplaystring = publisheddisplaystring;
            _x.versionnumber = versionnumber;
            _x.overwritetime = overwritetime;
            _x._createdby_value = _createdby_value;
            _x.displaystringkey = displaystringkey;
            _x._modifiedby_value = _modifiedby_value;
            _x.solutionid = solutionid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && displaystringid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(displaystringid, UUID.class));
        }
    }

    @Property(name="customdisplaystring")
    @JsonIgnore
    public Optional<String> getCustomdisplaystring() {
        return Optional.ofNullable(customdisplaystring);
    }

    public Displaystring withCustomdisplaystring(String customdisplaystring) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("customdisplaystring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.customdisplaystring = customdisplaystring;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Displaystring withModifiedon(OffsetDateTime modifiedon) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Displaystring with_organizationid_value(UUID _organizationid_value) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Displaystring withComponentstate(Integer componentstate) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Displaystring withLanguagecode(Integer languagecode) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Displaystring withIsmanaged(Boolean ismanaged) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="displaystringid")
    @JsonIgnore
    public Optional<UUID> getDisplaystringid() {
        return Optional.ofNullable(displaystringid);
    }

    public Displaystring withDisplaystringid(UUID displaystringid) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("displaystringid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.displaystringid = displaystringid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Displaystring with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Displaystring withCreatedon(OffsetDateTime createdon) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="customcomment")
    @JsonIgnore
    public Optional<String> getCustomcomment() {
        return Optional.ofNullable(customcomment);
    }

    public Displaystring withCustomcomment(String customcomment) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("customcomment");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.customcomment = customcomment;
        return _x;
    }

    @Property(name="displaystringidunique")
    @JsonIgnore
    public Optional<UUID> getDisplaystringidunique() {
        return Optional.ofNullable(displaystringidunique);
    }

    public Displaystring withDisplaystringidunique(UUID displaystringidunique) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("displaystringidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.displaystringidunique = displaystringidunique;
        return _x;
    }

    @Property(name="formatparameters")
    @JsonIgnore
    public Optional<Integer> getFormatparameters() {
        return Optional.ofNullable(formatparameters);
    }

    public Displaystring withFormatparameters(Integer formatparameters) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("formatparameters");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.formatparameters = formatparameters;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Displaystring with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="publisheddisplaystring")
    @JsonIgnore
    public Optional<String> getPublisheddisplaystring() {
        return Optional.ofNullable(publisheddisplaystring);
    }

    public Displaystring withPublisheddisplaystring(String publisheddisplaystring) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("publisheddisplaystring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.publisheddisplaystring = publisheddisplaystring;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Displaystring withVersionnumber(Long versionnumber) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Displaystring withOverwritetime(OffsetDateTime overwritetime) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Displaystring with_createdby_value(UUID _createdby_value) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="displaystringkey")
    @JsonIgnore
    public Optional<String> getDisplaystringkey() {
        return Optional.ofNullable(displaystringkey);
    }

    public Displaystring withDisplaystringkey(String displaystringkey) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("displaystringkey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.displaystringkey = displaystringkey;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Displaystring with_modifiedby_value(UUID _modifiedby_value) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Displaystring withSolutionid(UUID solutionid) {
        Displaystring _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.displaystring");
        _x.solutionid = solutionid;
        return _x;
    }

    public Displaystring withUnmappedField(String name, Object value) {
        Displaystring _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="DisplayString_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getDisplayString_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("DisplayString_AsyncOperations"), RequestHelper.getValue(unmappedFields, "DisplayString_AsyncOperations"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="DisplayString_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getDisplayString_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("DisplayString_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "DisplayString_BulkDeleteFailures"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Displaystring patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Displaystring _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Displaystring put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Displaystring _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Displaystring _copy() {
        Displaystring _x = new Displaystring();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.customdisplaystring = customdisplaystring;
        _x.modifiedon = modifiedon;
        _x._organizationid_value = _organizationid_value;
        _x.componentstate = componentstate;
        _x.languagecode = languagecode;
        _x.ismanaged = ismanaged;
        _x.displaystringid = displaystringid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x.customcomment = customcomment;
        _x.displaystringidunique = displaystringidunique;
        _x.formatparameters = formatparameters;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.publisheddisplaystring = publisheddisplaystring;
        _x.versionnumber = versionnumber;
        _x.overwritetime = overwritetime;
        _x._createdby_value = _createdby_value;
        _x.displaystringkey = displaystringkey;
        _x._modifiedby_value = _modifiedby_value;
        _x.solutionid = solutionid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Displaystring[");
        b.append("customdisplaystring=");
        b.append(this.customdisplaystring);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("displaystringid=");
        b.append(this.displaystringid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("customcomment=");
        b.append(this.customcomment);
        b.append(", ");
        b.append("displaystringidunique=");
        b.append(this.displaystringidunique);
        b.append(", ");
        b.append("formatparameters=");
        b.append(this.formatparameters);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("publisheddisplaystring=");
        b.append(this.publisheddisplaystring);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("displaystringkey=");
        b.append(this.displaystringkey);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
