package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionreferenceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "connectoridunique", 
    "_owninguser_value", 
    "iconblob_url", 
    "_createdonbehalfby_value", 
    "iscustomizable", 
    "description", 
    "overwritetime", 
    "displayname", 
    "_modifiedonbehalfby_value", 
    "timezoneruleversionnumber", 
    "name", 
    "_ownerid_value", 
    "connectortype", 
    "connectorinternalid", 
    "createdon", 
    "componentstate", 
    "solutionid", 
    "connectorid", 
    "statecode", 
    "ismanaged", 
    "modifiedon", 
    "iconbrandcolor", 
    "_owningbusinessunit_value", 
    "_modifiedby_value", 
    "utcconversiontimezonecode", 
    "versionnumber", 
    "introducedversion", 
    "openapidefinition", 
    "connectionparameters", 
    "_createdby_value", 
    "policytemplateinstances", 
    "importsequencenumber", 
    "iconblob", 
    "iconblobid", 
    "statuscode", 
    "iconblob_timestamp", 
    "_owningteam_value", 
    "overriddencreatedon"})
@JsonInclude(Include.NON_NULL)
public class Connector extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.connector";
    }

    @JsonProperty("connectoridunique")
    protected UUID connectoridunique;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("iconblob_url")
    protected String iconblob_url;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("displayname")
    protected String displayname;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("connectortype")
    protected Integer connectortype;

    @JsonProperty("connectorinternalid")
    protected String connectorinternalid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("connectorid")
    protected UUID connectorid;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("iconbrandcolor")
    protected String iconbrandcolor;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("openapidefinition")
    protected String openapidefinition;

    @JsonProperty("connectionparameters")
    protected String connectionparameters;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("policytemplateinstances")
    protected String policytemplateinstances;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("iconblob")
    protected byte[] iconblob;

    @JsonProperty("iconblobid")
    protected UUID iconblobid;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("iconblob_timestamp")
    protected Long iconblob_timestamp;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    protected Connector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnector() {
        return new Builder();
    }

    public static final class Builder {
        private UUID connectoridunique;
        private UUID _owninguser_value;
        private String iconblob_url;
        private UUID _createdonbehalfby_value;
        private BooleanManagedProperty iscustomizable;
        private String description;
        private OffsetDateTime overwritetime;
        private String displayname;
        private UUID _modifiedonbehalfby_value;
        private Integer timezoneruleversionnumber;
        private String name;
        private UUID _ownerid_value;
        private Integer connectortype;
        private String connectorinternalid;
        private OffsetDateTime createdon;
        private Integer componentstate;
        private UUID solutionid;
        private UUID connectorid;
        private Integer statecode;
        private Boolean ismanaged;
        private OffsetDateTime modifiedon;
        private String iconbrandcolor;
        private UUID _owningbusinessunit_value;
        private UUID _modifiedby_value;
        private Integer utcconversiontimezonecode;
        private Long versionnumber;
        private String introducedversion;
        private String openapidefinition;
        private String connectionparameters;
        private UUID _createdby_value;
        private String policytemplateinstances;
        private Integer importsequencenumber;
        private byte[] iconblob;
        private UUID iconblobid;
        private Integer statuscode;
        private Long iconblob_timestamp;
        private UUID _owningteam_value;
        private OffsetDateTime overriddencreatedon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder connectoridunique(UUID connectoridunique) {
            this.connectoridunique = connectoridunique;
            this.changedFields = changedFields.add("connectoridunique");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder iconblob_url(String iconblob_url) {
            this.iconblob_url = iconblob_url;
            this.changedFields = changedFields.add("iconblob_url");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder displayname(String displayname) {
            this.displayname = displayname;
            this.changedFields = changedFields.add("displayname");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder connectortype(Integer connectortype) {
            this.connectortype = connectortype;
            this.changedFields = changedFields.add("connectortype");
            return this;
        }

        public Builder connectorinternalid(String connectorinternalid) {
            this.connectorinternalid = connectorinternalid;
            this.changedFields = changedFields.add("connectorinternalid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder connectorid(UUID connectorid) {
            this.connectorid = connectorid;
            this.changedFields = changedFields.add("connectorid");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder iconbrandcolor(String iconbrandcolor) {
            this.iconbrandcolor = iconbrandcolor;
            this.changedFields = changedFields.add("iconbrandcolor");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder openapidefinition(String openapidefinition) {
            this.openapidefinition = openapidefinition;
            this.changedFields = changedFields.add("openapidefinition");
            return this;
        }

        public Builder connectionparameters(String connectionparameters) {
            this.connectionparameters = connectionparameters;
            this.changedFields = changedFields.add("connectionparameters");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder policytemplateinstances(String policytemplateinstances) {
            this.policytemplateinstances = policytemplateinstances;
            this.changedFields = changedFields.add("policytemplateinstances");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder iconblob(byte[] iconblob) {
            this.iconblob = iconblob;
            this.changedFields = changedFields.add("iconblob");
            return this;
        }

        public Builder iconblobid(UUID iconblobid) {
            this.iconblobid = iconblobid;
            this.changedFields = changedFields.add("iconblobid");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder iconblob_timestamp(Long iconblob_timestamp) {
            this.iconblob_timestamp = iconblob_timestamp;
            this.changedFields = changedFields.add("iconblob_timestamp");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Connector build() {
            Connector _x = new Connector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.connector";
            _x.connectoridunique = connectoridunique;
            _x._owninguser_value = _owninguser_value;
            _x.iconblob_url = iconblob_url;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.iscustomizable = iscustomizable;
            _x.description = description;
            _x.overwritetime = overwritetime;
            _x.displayname = displayname;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.name = name;
            _x._ownerid_value = _ownerid_value;
            _x.connectortype = connectortype;
            _x.connectorinternalid = connectorinternalid;
            _x.createdon = createdon;
            _x.componentstate = componentstate;
            _x.solutionid = solutionid;
            _x.connectorid = connectorid;
            _x.statecode = statecode;
            _x.ismanaged = ismanaged;
            _x.modifiedon = modifiedon;
            _x.iconbrandcolor = iconbrandcolor;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.versionnumber = versionnumber;
            _x.introducedversion = introducedversion;
            _x.openapidefinition = openapidefinition;
            _x.connectionparameters = connectionparameters;
            _x._createdby_value = _createdby_value;
            _x.policytemplateinstances = policytemplateinstances;
            _x.importsequencenumber = importsequencenumber;
            _x.iconblob = iconblob;
            _x.iconblobid = iconblobid;
            _x.statuscode = statuscode;
            _x.iconblob_timestamp = iconblob_timestamp;
            _x._owningteam_value = _owningteam_value;
            _x.overriddencreatedon = overriddencreatedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && connectorid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(connectorid, UUID.class));
        }
    }

    @Property(name="connectoridunique")
    @JsonIgnore
    public Optional<UUID> getConnectoridunique() {
        return Optional.ofNullable(connectoridunique);
    }

    public Connector withConnectoridunique(UUID connectoridunique) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("connectoridunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.connectoridunique = connectoridunique;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Connector with_owninguser_value(UUID _owninguser_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="iconblob_url")
    @JsonIgnore
    public Optional<String> getIconblob_url() {
        return Optional.ofNullable(iconblob_url);
    }

    public Connector withIconblob_url(String iconblob_url) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("iconblob_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.iconblob_url = iconblob_url;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Connector with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Connector withIscustomizable(BooleanManagedProperty iscustomizable) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Connector withDescription(String description) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.description = description;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Connector withOverwritetime(OffsetDateTime overwritetime) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="displayname")
    @JsonIgnore
    public Optional<String> getDisplayname() {
        return Optional.ofNullable(displayname);
    }

    public Connector withDisplayname(String displayname) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("displayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.displayname = displayname;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Connector with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Connector withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Connector withName(String name) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.name = name;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Connector with_ownerid_value(UUID _ownerid_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="connectortype")
    @JsonIgnore
    public Optional<Integer> getConnectortype() {
        return Optional.ofNullable(connectortype);
    }

    public Connector withConnectortype(Integer connectortype) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("connectortype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.connectortype = connectortype;
        return _x;
    }

    @Property(name="connectorinternalid")
    @JsonIgnore
    public Optional<String> getConnectorinternalid() {
        return Optional.ofNullable(connectorinternalid);
    }

    public Connector withConnectorinternalid(String connectorinternalid) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("connectorinternalid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.connectorinternalid = connectorinternalid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Connector withCreatedon(OffsetDateTime createdon) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Connector withComponentstate(Integer componentstate) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Connector withSolutionid(UUID solutionid) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="connectorid")
    @JsonIgnore
    public Optional<UUID> getConnectorid() {
        return Optional.ofNullable(connectorid);
    }

    public Connector withConnectorid(UUID connectorid) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("connectorid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.connectorid = connectorid;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Connector withStatecode(Integer statecode) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Connector withIsmanaged(Boolean ismanaged) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Connector withModifiedon(OffsetDateTime modifiedon) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="iconbrandcolor")
    @JsonIgnore
    public Optional<String> getIconbrandcolor() {
        return Optional.ofNullable(iconbrandcolor);
    }

    public Connector withIconbrandcolor(String iconbrandcolor) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("iconbrandcolor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.iconbrandcolor = iconbrandcolor;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Connector with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Connector with_modifiedby_value(UUID _modifiedby_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Connector withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Connector withVersionnumber(Long versionnumber) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Connector withIntroducedversion(String introducedversion) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="openapidefinition")
    @JsonIgnore
    public Optional<String> getOpenapidefinition() {
        return Optional.ofNullable(openapidefinition);
    }

    public Connector withOpenapidefinition(String openapidefinition) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("openapidefinition");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.openapidefinition = openapidefinition;
        return _x;
    }

    @Property(name="connectionparameters")
    @JsonIgnore
    public Optional<String> getConnectionparameters() {
        return Optional.ofNullable(connectionparameters);
    }

    public Connector withConnectionparameters(String connectionparameters) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("connectionparameters");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.connectionparameters = connectionparameters;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Connector with_createdby_value(UUID _createdby_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="policytemplateinstances")
    @JsonIgnore
    public Optional<String> getPolicytemplateinstances() {
        return Optional.ofNullable(policytemplateinstances);
    }

    public Connector withPolicytemplateinstances(String policytemplateinstances) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("policytemplateinstances");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.policytemplateinstances = policytemplateinstances;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Connector withImportsequencenumber(Integer importsequencenumber) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="iconblob")
    @JsonIgnore
    public Optional<byte[]> getIconblob() {
        return Optional.ofNullable(iconblob);
    }

    public Connector withIconblob(byte[] iconblob) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("iconblob");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.iconblob = iconblob;
        return _x;
    }

    @Property(name="iconblobid")
    @JsonIgnore
    public Optional<UUID> getIconblobid() {
        return Optional.ofNullable(iconblobid);
    }

    public Connector withIconblobid(UUID iconblobid) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("iconblobid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.iconblobid = iconblobid;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Connector withStatuscode(Integer statuscode) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="iconblob_timestamp")
    @JsonIgnore
    public Optional<Long> getIconblob_timestamp() {
        return Optional.ofNullable(iconblob_timestamp);
    }

    public Connector withIconblob_timestamp(Long iconblob_timestamp) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("iconblob_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.iconblob_timestamp = iconblob_timestamp;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Connector with_owningteam_value(UUID _owningteam_value) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Connector withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.connector");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    public Connector withUnmappedField(String name, Object value) {
        Connector _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="connector_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getConnector_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("connector_SyncErrors"), RequestHelper.getValue(unmappedFields, "connector_SyncErrors"));
    }

    @NavigationProperty(name="connector_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getConnector_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("connector_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "connector_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="connector_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getConnector_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("connector_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "connector_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="connector_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getConnector_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("connector_AsyncOperations"), RequestHelper.getValue(unmappedFields, "connector_AsyncOperations"));
    }

    @NavigationProperty(name="connector_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getConnector_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("connector_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "connector_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="connector_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getConnector_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("connector_ProcessSession"), RequestHelper.getValue(unmappedFields, "connector_ProcessSession"));
    }

    @NavigationProperty(name="connector_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getConnector_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("connector_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "connector_BulkDeleteFailures"));
    }

    @NavigationProperty(name="connector_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getConnector_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("connector_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "connector_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="connector_connectionreference")
    @JsonIgnore
    public ConnectionreferenceCollectionRequest getConnector_connectionreference() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("connector_connectionreference"), RequestHelper.getValue(unmappedFields, "connector_connectionreference"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Connector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Connector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Connector _copy() {
        Connector _x = new Connector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.connectoridunique = connectoridunique;
        _x._owninguser_value = _owninguser_value;
        _x.iconblob_url = iconblob_url;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.iscustomizable = iscustomizable;
        _x.description = description;
        _x.overwritetime = overwritetime;
        _x.displayname = displayname;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.name = name;
        _x._ownerid_value = _ownerid_value;
        _x.connectortype = connectortype;
        _x.connectorinternalid = connectorinternalid;
        _x.createdon = createdon;
        _x.componentstate = componentstate;
        _x.solutionid = solutionid;
        _x.connectorid = connectorid;
        _x.statecode = statecode;
        _x.ismanaged = ismanaged;
        _x.modifiedon = modifiedon;
        _x.iconbrandcolor = iconbrandcolor;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.versionnumber = versionnumber;
        _x.introducedversion = introducedversion;
        _x.openapidefinition = openapidefinition;
        _x.connectionparameters = connectionparameters;
        _x._createdby_value = _createdby_value;
        _x.policytemplateinstances = policytemplateinstances;
        _x.importsequencenumber = importsequencenumber;
        _x.iconblob = iconblob;
        _x.iconblobid = iconblobid;
        _x.statuscode = statuscode;
        _x.iconblob_timestamp = iconblob_timestamp;
        _x._owningteam_value = _owningteam_value;
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connector[");
        b.append("connectoridunique=");
        b.append(this.connectoridunique);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("iconblob_url=");
        b.append(this.iconblob_url);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("displayname=");
        b.append(this.displayname);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("connectortype=");
        b.append(this.connectortype);
        b.append(", ");
        b.append("connectorinternalid=");
        b.append(this.connectorinternalid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("connectorid=");
        b.append(this.connectorid);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("iconbrandcolor=");
        b.append(this.iconbrandcolor);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("openapidefinition=");
        b.append(this.openapidefinition);
        b.append(", ");
        b.append("connectionparameters=");
        b.append(this.connectionparameters);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("policytemplateinstances=");
        b.append(this.policytemplateinstances);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("iconblob=");
        b.append(this.iconblob);
        b.append(", ");
        b.append("iconblobid=");
        b.append(this.iconblobid);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("iconblob_timestamp=");
        b.append(this.iconblob_timestamp);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
