package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "annual", 
    "_modifiedby_value", 
    "effectiveon", 
    "_modifiedonbehalfby_value", 
    "createdon", 
    "_businessunitid_value", 
    "_transactioncurrencyid_value", 
    "_salespersonid_value", 
    "fiscalperiodtype", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "userfiscalcalendarid", 
    "utcconversiontimezonecode", 
    "annual_base", 
    "exchangerate", 
    "_createdby_value", 
    "timezoneruleversionnumber"})
@JsonInclude(Include.NON_NULL)
public class Annualfiscalcalendar extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.annualfiscalcalendar";
    }

    @JsonProperty("annual")
    protected BigDecimal annual;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("effectiveon")
    protected OffsetDateTime effectiveon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_businessunitid_value")
    protected UUID _businessunitid_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("_salespersonid_value")
    protected UUID _salespersonid_value;

    @JsonProperty("fiscalperiodtype")
    protected Integer fiscalperiodtype;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("userfiscalcalendarid")
    protected UUID userfiscalcalendarid;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("annual_base")
    protected BigDecimal annual_base;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    protected Annualfiscalcalendar() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAnnualfiscalcalendar() {
        return new Builder();
    }

    public static final class Builder {
        private BigDecimal annual;
        private UUID _modifiedby_value;
        private OffsetDateTime effectiveon;
        private UUID _modifiedonbehalfby_value;
        private OffsetDateTime createdon;
        private UUID _businessunitid_value;
        private UUID _transactioncurrencyid_value;
        private UUID _salespersonid_value;
        private Integer fiscalperiodtype;
        private OffsetDateTime modifiedon;
        private UUID _createdonbehalfby_value;
        private UUID userfiscalcalendarid;
        private Integer utcconversiontimezonecode;
        private BigDecimal annual_base;
        private BigDecimal exchangerate;
        private UUID _createdby_value;
        private Integer timezoneruleversionnumber;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder annual(BigDecimal annual) {
            this.annual = annual;
            this.changedFields = changedFields.add("annual");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder effectiveon(OffsetDateTime effectiveon) {
            this.effectiveon = effectiveon;
            this.changedFields = changedFields.add("effectiveon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _businessunitid_value(UUID _businessunitid_value) {
            this._businessunitid_value = _businessunitid_value;
            this.changedFields = changedFields.add("_businessunitid_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder _salespersonid_value(UUID _salespersonid_value) {
            this._salespersonid_value = _salespersonid_value;
            this.changedFields = changedFields.add("_salespersonid_value");
            return this;
        }

        public Builder fiscalperiodtype(Integer fiscalperiodtype) {
            this.fiscalperiodtype = fiscalperiodtype;
            this.changedFields = changedFields.add("fiscalperiodtype");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder userfiscalcalendarid(UUID userfiscalcalendarid) {
            this.userfiscalcalendarid = userfiscalcalendarid;
            this.changedFields = changedFields.add("userfiscalcalendarid");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder annual_base(BigDecimal annual_base) {
            this.annual_base = annual_base;
            this.changedFields = changedFields.add("annual_base");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Annualfiscalcalendar build() {
            Annualfiscalcalendar _x = new Annualfiscalcalendar();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.annualfiscalcalendar";
            _x.annual = annual;
            _x._modifiedby_value = _modifiedby_value;
            _x.effectiveon = effectiveon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.createdon = createdon;
            _x._businessunitid_value = _businessunitid_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x._salespersonid_value = _salespersonid_value;
            _x.fiscalperiodtype = fiscalperiodtype;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.userfiscalcalendarid = userfiscalcalendarid;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.annual_base = annual_base;
            _x.exchangerate = exchangerate;
            _x._createdby_value = _createdby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && userfiscalcalendarid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(userfiscalcalendarid, UUID.class));
        }
    }

    @Property(name="annual")
    @JsonIgnore
    public Optional<BigDecimal> getAnnual() {
        return Optional.ofNullable(annual);
    }

    public Annualfiscalcalendar withAnnual(BigDecimal annual) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("annual");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.annual = annual;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Annualfiscalcalendar with_modifiedby_value(UUID _modifiedby_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="effectiveon")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveon() {
        return Optional.ofNullable(effectiveon);
    }

    public Annualfiscalcalendar withEffectiveon(OffsetDateTime effectiveon) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("effectiveon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.effectiveon = effectiveon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Annualfiscalcalendar with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Annualfiscalcalendar withCreatedon(OffsetDateTime createdon) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_businessunitid_value")
    @JsonIgnore
    public Optional<UUID> get_businessunitid_value() {
        return Optional.ofNullable(_businessunitid_value);
    }

    public Annualfiscalcalendar with_businessunitid_value(UUID _businessunitid_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_businessunitid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._businessunitid_value = _businessunitid_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Annualfiscalcalendar with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="_salespersonid_value")
    @JsonIgnore
    public Optional<UUID> get_salespersonid_value() {
        return Optional.ofNullable(_salespersonid_value);
    }

    public Annualfiscalcalendar with_salespersonid_value(UUID _salespersonid_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_salespersonid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._salespersonid_value = _salespersonid_value;
        return _x;
    }

    @Property(name="fiscalperiodtype")
    @JsonIgnore
    public Optional<Integer> getFiscalperiodtype() {
        return Optional.ofNullable(fiscalperiodtype);
    }

    public Annualfiscalcalendar withFiscalperiodtype(Integer fiscalperiodtype) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("fiscalperiodtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.fiscalperiodtype = fiscalperiodtype;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Annualfiscalcalendar withModifiedon(OffsetDateTime modifiedon) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Annualfiscalcalendar with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="userfiscalcalendarid")
    @JsonIgnore
    public Optional<UUID> getUserfiscalcalendarid() {
        return Optional.ofNullable(userfiscalcalendarid);
    }

    public Annualfiscalcalendar withUserfiscalcalendarid(UUID userfiscalcalendarid) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("userfiscalcalendarid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.userfiscalcalendarid = userfiscalcalendarid;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Annualfiscalcalendar withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="annual_base")
    @JsonIgnore
    public Optional<BigDecimal> getAnnual_base() {
        return Optional.ofNullable(annual_base);
    }

    public Annualfiscalcalendar withAnnual_base(BigDecimal annual_base) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("annual_base");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.annual_base = annual_base;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Annualfiscalcalendar withExchangerate(BigDecimal exchangerate) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Annualfiscalcalendar with_createdby_value(UUID _createdby_value) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Annualfiscalcalendar withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.annualfiscalcalendar");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    public Annualfiscalcalendar withUnmappedField(String name, Object value) {
        Annualfiscalcalendar _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="AnnualFiscalCalendar_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getAnnualFiscalCalendar_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("AnnualFiscalCalendar_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "AnnualFiscalCalendar_BulkDeleteFailures"));
    }

    @NavigationProperty(name="AnnualFiscalCalendar_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getAnnualFiscalCalendar_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("AnnualFiscalCalendar_AsyncOperations"), RequestHelper.getValue(unmappedFields, "AnnualFiscalCalendar_AsyncOperations"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="salespersonid")
    @JsonIgnore
    public SystemuserRequest getSalespersonid() {
        return new SystemuserRequest(contextPath.addSegment("salespersonid"), RequestHelper.getValue(unmappedFields, "salespersonid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Annualfiscalcalendar patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Annualfiscalcalendar put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Annualfiscalcalendar _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Annualfiscalcalendar _copy() {
        Annualfiscalcalendar _x = new Annualfiscalcalendar();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.annual = annual;
        _x._modifiedby_value = _modifiedby_value;
        _x.effectiveon = effectiveon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.createdon = createdon;
        _x._businessunitid_value = _businessunitid_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x._salespersonid_value = _salespersonid_value;
        _x.fiscalperiodtype = fiscalperiodtype;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.userfiscalcalendarid = userfiscalcalendarid;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.annual_base = annual_base;
        _x.exchangerate = exchangerate;
        _x._createdby_value = _createdby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Annualfiscalcalendar[");
        b.append("annual=");
        b.append(this.annual);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("effectiveon=");
        b.append(this.effectiveon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_businessunitid_value=");
        b.append(this._businessunitid_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("_salespersonid_value=");
        b.append(this._salespersonid_value);
        b.append(", ");
        b.append("fiscalperiodtype=");
        b.append(this.fiscalperiodtype);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("userfiscalcalendarid=");
        b.append(this.userfiscalcalendarid);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("annual_base=");
        b.append(this.annual_base);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
