package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "Prefix", 
    "StoragePointer", 
    "FilePointer", 
    "FileSize", 
    "Otc", 
    "TargetObjectId", 
    "SetBodyToNull"})
@JsonInclude(Include.NON_NULL)
public class UpdatePointersRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Prefix")
    protected String prefix;

    @JsonProperty("StoragePointer")
    protected Integer storagePointer;

    @JsonProperty("FilePointer")
    protected UUID filePointer;

    @JsonProperty("FileSize")
    protected Long fileSize;

    @JsonProperty("Otc")
    protected Integer otc;

    @JsonProperty("TargetObjectId")
    protected UUID targetObjectId;

    @JsonProperty("SetBodyToNull")
    protected Boolean setBodyToNull;

    protected UpdatePointersRequest() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.UpdatePointersRequest";
    }

    @Property(name="Prefix")
    @JsonIgnore
    public Optional<String> getPrefix() {
        return Optional.ofNullable(prefix);
    }

    public UpdatePointersRequest withPrefix(String prefix) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.prefix = prefix;
        return _x;
    }

    @Property(name="StoragePointer")
    @JsonIgnore
    public Optional<Integer> getStoragePointer() {
        return Optional.ofNullable(storagePointer);
    }

    public UpdatePointersRequest withStoragePointer(Integer storagePointer) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.storagePointer = storagePointer;
        return _x;
    }

    @Property(name="FilePointer")
    @JsonIgnore
    public Optional<UUID> getFilePointer() {
        return Optional.ofNullable(filePointer);
    }

    public UpdatePointersRequest withFilePointer(UUID filePointer) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.filePointer = filePointer;
        return _x;
    }

    @Property(name="FileSize")
    @JsonIgnore
    public Optional<Long> getFileSize() {
        return Optional.ofNullable(fileSize);
    }

    public UpdatePointersRequest withFileSize(Long fileSize) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.fileSize = fileSize;
        return _x;
    }

    @Property(name="Otc")
    @JsonIgnore
    public Optional<Integer> getOtc() {
        return Optional.ofNullable(otc);
    }

    public UpdatePointersRequest withOtc(Integer otc) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.otc = otc;
        return _x;
    }

    @Property(name="TargetObjectId")
    @JsonIgnore
    public Optional<UUID> getTargetObjectId() {
        return Optional.ofNullable(targetObjectId);
    }

    public UpdatePointersRequest withTargetObjectId(UUID targetObjectId) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.targetObjectId = targetObjectId;
        return _x;
    }

    @Property(name="SetBodyToNull")
    @JsonIgnore
    public Optional<Boolean> getSetBodyToNull() {
        return Optional.ofNullable(setBodyToNull);
    }

    public UpdatePointersRequest withSetBodyToNull(Boolean setBodyToNull) {
        UpdatePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.setBodyToNull = setBodyToNull;
        return _x;
    }

    public UpdatePointersRequest withUnmappedField(String name, Object value) {
        UpdatePointersRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String prefix;
        private Integer storagePointer;
        private UUID filePointer;
        private Long fileSize;
        private Integer otc;
        private UUID targetObjectId;
        private Boolean setBodyToNull;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.changedFields = changedFields.add("Prefix");
            return this;
        }

        public Builder storagePointer(Integer storagePointer) {
            this.storagePointer = storagePointer;
            this.changedFields = changedFields.add("StoragePointer");
            return this;
        }

        public Builder filePointer(UUID filePointer) {
            this.filePointer = filePointer;
            this.changedFields = changedFields.add("FilePointer");
            return this;
        }

        public Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            this.changedFields = changedFields.add("FileSize");
            return this;
        }

        public Builder otc(Integer otc) {
            this.otc = otc;
            this.changedFields = changedFields.add("Otc");
            return this;
        }

        public Builder targetObjectId(UUID targetObjectId) {
            this.targetObjectId = targetObjectId;
            this.changedFields = changedFields.add("TargetObjectId");
            return this;
        }

        public Builder setBodyToNull(Boolean setBodyToNull) {
            this.setBodyToNull = setBodyToNull;
            this.changedFields = changedFields.add("SetBodyToNull");
            return this;
        }

        public UpdatePointersRequest build() {
            UpdatePointersRequest _x = new UpdatePointersRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.UpdatePointersRequest";
            _x.prefix = prefix;
            _x.storagePointer = storagePointer;
            _x.filePointer = filePointer;
            _x.fileSize = fileSize;
            _x.otc = otc;
            _x.targetObjectId = targetObjectId;
            _x.setBodyToNull = setBodyToNull;
            return _x;
        }
    }

    private UpdatePointersRequest _copy() {
        UpdatePointersRequest _x = new UpdatePointersRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.prefix = prefix;
        _x.storagePointer = storagePointer;
        _x.filePointer = filePointer;
        _x.fileSize = fileSize;
        _x.otc = otc;
        _x.targetObjectId = targetObjectId;
        _x.setBodyToNull = setBodyToNull;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UpdatePointersRequest[");
        b.append("Prefix=");
        b.append(this.prefix);
        b.append(", ");
        b.append("StoragePointer=");
        b.append(this.storagePointer);
        b.append(", ");
        b.append("FilePointer=");
        b.append(this.filePointer);
        b.append(", ");
        b.append("FileSize=");
        b.append(this.fileSize);
        b.append(", ");
        b.append("Otc=");
        b.append(this.otc);
        b.append(", ");
        b.append("TargetObjectId=");
        b.append(this.targetObjectId);
        b.append(", ");
        b.append("SetBodyToNull=");
        b.append(this.setBodyToNull);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
