package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "SolutionUniqueName", 
    "SolutionFriendlyName", 
    "SolutionDescription", 
    "PublisherUniqueName", 
    "PublisherFriendlyName", 
    "PreviousSolutionUniqueName", 
    "PreviousSolutionFriendlyName", 
    "PreviousPublisherUniqueName", 
    "PreviousPublisherFriendlyName", 
    "IsPatchSolution", 
    "IsManaged", 
    "PreviousIsManaged", 
    "SolutionVersion", 
    "PreviousSolutionVersion", 
    "PreviousPatchSolutionsNames"})
@JsonInclude(Include.NON_NULL)
public class SolutionDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("SolutionUniqueName")
    protected String solutionUniqueName;

    @JsonProperty("SolutionFriendlyName")
    protected String solutionFriendlyName;

    @JsonProperty("SolutionDescription")
    protected String solutionDescription;

    @JsonProperty("PublisherUniqueName")
    protected String publisherUniqueName;

    @JsonProperty("PublisherFriendlyName")
    protected String publisherFriendlyName;

    @JsonProperty("PreviousSolutionUniqueName")
    protected String previousSolutionUniqueName;

    @JsonProperty("PreviousSolutionFriendlyName")
    protected String previousSolutionFriendlyName;

    @JsonProperty("PreviousPublisherUniqueName")
    protected String previousPublisherUniqueName;

    @JsonProperty("PreviousPublisherFriendlyName")
    protected String previousPublisherFriendlyName;

    @JsonProperty("IsPatchSolution")
    protected Boolean isPatchSolution;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("PreviousIsManaged")
    protected Boolean previousIsManaged;

    @JsonProperty("SolutionVersion")
    protected String solutionVersion;

    @JsonProperty("PreviousSolutionVersion")
    protected String previousSolutionVersion;

    @JsonProperty("PreviousPatchSolutionsNames")
    protected List<String> previousPatchSolutionsNames;

    @JsonProperty("PreviousPatchSolutionsNames@nextLink")
    protected String previousPatchSolutionsNamesNextLink;

    protected SolutionDetails() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SolutionDetails";
    }

    @Property(name="SolutionUniqueName")
    @JsonIgnore
    public Optional<String> getSolutionUniqueName() {
        return Optional.ofNullable(solutionUniqueName);
    }

    public SolutionDetails withSolutionUniqueName(String solutionUniqueName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.solutionUniqueName = solutionUniqueName;
        return _x;
    }

    @Property(name="SolutionFriendlyName")
    @JsonIgnore
    public Optional<String> getSolutionFriendlyName() {
        return Optional.ofNullable(solutionFriendlyName);
    }

    public SolutionDetails withSolutionFriendlyName(String solutionFriendlyName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.solutionFriendlyName = solutionFriendlyName;
        return _x;
    }

    @Property(name="SolutionDescription")
    @JsonIgnore
    public Optional<String> getSolutionDescription() {
        return Optional.ofNullable(solutionDescription);
    }

    public SolutionDetails withSolutionDescription(String solutionDescription) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.solutionDescription = solutionDescription;
        return _x;
    }

    @Property(name="PublisherUniqueName")
    @JsonIgnore
    public Optional<String> getPublisherUniqueName() {
        return Optional.ofNullable(publisherUniqueName);
    }

    public SolutionDetails withPublisherUniqueName(String publisherUniqueName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.publisherUniqueName = publisherUniqueName;
        return _x;
    }

    @Property(name="PublisherFriendlyName")
    @JsonIgnore
    public Optional<String> getPublisherFriendlyName() {
        return Optional.ofNullable(publisherFriendlyName);
    }

    public SolutionDetails withPublisherFriendlyName(String publisherFriendlyName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.publisherFriendlyName = publisherFriendlyName;
        return _x;
    }

    @Property(name="PreviousSolutionUniqueName")
    @JsonIgnore
    public Optional<String> getPreviousSolutionUniqueName() {
        return Optional.ofNullable(previousSolutionUniqueName);
    }

    public SolutionDetails withPreviousSolutionUniqueName(String previousSolutionUniqueName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.previousSolutionUniqueName = previousSolutionUniqueName;
        return _x;
    }

    @Property(name="PreviousSolutionFriendlyName")
    @JsonIgnore
    public Optional<String> getPreviousSolutionFriendlyName() {
        return Optional.ofNullable(previousSolutionFriendlyName);
    }

    public SolutionDetails withPreviousSolutionFriendlyName(String previousSolutionFriendlyName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.previousSolutionFriendlyName = previousSolutionFriendlyName;
        return _x;
    }

    @Property(name="PreviousPublisherUniqueName")
    @JsonIgnore
    public Optional<String> getPreviousPublisherUniqueName() {
        return Optional.ofNullable(previousPublisherUniqueName);
    }

    public SolutionDetails withPreviousPublisherUniqueName(String previousPublisherUniqueName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.previousPublisherUniqueName = previousPublisherUniqueName;
        return _x;
    }

    @Property(name="PreviousPublisherFriendlyName")
    @JsonIgnore
    public Optional<String> getPreviousPublisherFriendlyName() {
        return Optional.ofNullable(previousPublisherFriendlyName);
    }

    public SolutionDetails withPreviousPublisherFriendlyName(String previousPublisherFriendlyName) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.previousPublisherFriendlyName = previousPublisherFriendlyName;
        return _x;
    }

    @Property(name="IsPatchSolution")
    @JsonIgnore
    public Optional<Boolean> getIsPatchSolution() {
        return Optional.ofNullable(isPatchSolution);
    }

    public SolutionDetails withIsPatchSolution(Boolean isPatchSolution) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.isPatchSolution = isPatchSolution;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public SolutionDetails withIsManaged(Boolean isManaged) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="PreviousIsManaged")
    @JsonIgnore
    public Optional<Boolean> getPreviousIsManaged() {
        return Optional.ofNullable(previousIsManaged);
    }

    public SolutionDetails withPreviousIsManaged(Boolean previousIsManaged) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.previousIsManaged = previousIsManaged;
        return _x;
    }

    @Property(name="SolutionVersion")
    @JsonIgnore
    public Optional<String> getSolutionVersion() {
        return Optional.ofNullable(solutionVersion);
    }

    public SolutionDetails withSolutionVersion(String solutionVersion) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.solutionVersion = solutionVersion;
        return _x;
    }

    @Property(name="PreviousSolutionVersion")
    @JsonIgnore
    public Optional<String> getPreviousSolutionVersion() {
        return Optional.ofNullable(previousSolutionVersion);
    }

    public SolutionDetails withPreviousSolutionVersion(String previousSolutionVersion) {
        SolutionDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionDetails");
        _x.previousSolutionVersion = previousSolutionVersion;
        return _x;
    }

    @Property(name="PreviousPatchSolutionsNames")
    @JsonIgnore
    public CollectionPage<String> getPreviousPatchSolutionsNames() {
        return new CollectionPage<String>(contextPath, String.class, this.previousPatchSolutionsNames, Optional.ofNullable(previousPatchSolutionsNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="PreviousPatchSolutionsNames")
    @JsonIgnore
    public CollectionPage<String> getPreviousPatchSolutionsNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.previousPatchSolutionsNames, Optional.ofNullable(previousPatchSolutionsNamesNextLink), Collections.emptyList(), options);
    }

    public SolutionDetails withUnmappedField(String name, Object value) {
        SolutionDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String solutionUniqueName;
        private String solutionFriendlyName;
        private String solutionDescription;
        private String publisherUniqueName;
        private String publisherFriendlyName;
        private String previousSolutionUniqueName;
        private String previousSolutionFriendlyName;
        private String previousPublisherUniqueName;
        private String previousPublisherFriendlyName;
        private Boolean isPatchSolution;
        private Boolean isManaged;
        private Boolean previousIsManaged;
        private String solutionVersion;
        private String previousSolutionVersion;
        private List<String> previousPatchSolutionsNames;
        private String previousPatchSolutionsNamesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutionUniqueName(String solutionUniqueName) {
            this.solutionUniqueName = solutionUniqueName;
            this.changedFields = changedFields.add("SolutionUniqueName");
            return this;
        }

        public Builder solutionFriendlyName(String solutionFriendlyName) {
            this.solutionFriendlyName = solutionFriendlyName;
            this.changedFields = changedFields.add("SolutionFriendlyName");
            return this;
        }

        public Builder solutionDescription(String solutionDescription) {
            this.solutionDescription = solutionDescription;
            this.changedFields = changedFields.add("SolutionDescription");
            return this;
        }

        public Builder publisherUniqueName(String publisherUniqueName) {
            this.publisherUniqueName = publisherUniqueName;
            this.changedFields = changedFields.add("PublisherUniqueName");
            return this;
        }

        public Builder publisherFriendlyName(String publisherFriendlyName) {
            this.publisherFriendlyName = publisherFriendlyName;
            this.changedFields = changedFields.add("PublisherFriendlyName");
            return this;
        }

        public Builder previousSolutionUniqueName(String previousSolutionUniqueName) {
            this.previousSolutionUniqueName = previousSolutionUniqueName;
            this.changedFields = changedFields.add("PreviousSolutionUniqueName");
            return this;
        }

        public Builder previousSolutionFriendlyName(String previousSolutionFriendlyName) {
            this.previousSolutionFriendlyName = previousSolutionFriendlyName;
            this.changedFields = changedFields.add("PreviousSolutionFriendlyName");
            return this;
        }

        public Builder previousPublisherUniqueName(String previousPublisherUniqueName) {
            this.previousPublisherUniqueName = previousPublisherUniqueName;
            this.changedFields = changedFields.add("PreviousPublisherUniqueName");
            return this;
        }

        public Builder previousPublisherFriendlyName(String previousPublisherFriendlyName) {
            this.previousPublisherFriendlyName = previousPublisherFriendlyName;
            this.changedFields = changedFields.add("PreviousPublisherFriendlyName");
            return this;
        }

        public Builder isPatchSolution(Boolean isPatchSolution) {
            this.isPatchSolution = isPatchSolution;
            this.changedFields = changedFields.add("IsPatchSolution");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder previousIsManaged(Boolean previousIsManaged) {
            this.previousIsManaged = previousIsManaged;
            this.changedFields = changedFields.add("PreviousIsManaged");
            return this;
        }

        public Builder solutionVersion(String solutionVersion) {
            this.solutionVersion = solutionVersion;
            this.changedFields = changedFields.add("SolutionVersion");
            return this;
        }

        public Builder previousSolutionVersion(String previousSolutionVersion) {
            this.previousSolutionVersion = previousSolutionVersion;
            this.changedFields = changedFields.add("PreviousSolutionVersion");
            return this;
        }

        public Builder previousPatchSolutionsNames(List<String> previousPatchSolutionsNames) {
            this.previousPatchSolutionsNames = previousPatchSolutionsNames;
            this.changedFields = changedFields.add("PreviousPatchSolutionsNames");
            return this;
        }

        public Builder previousPatchSolutionsNames(String... previousPatchSolutionsNames) {
            return previousPatchSolutionsNames(Arrays.asList(previousPatchSolutionsNames));
        }

        public Builder previousPatchSolutionsNamesNextLink(String previousPatchSolutionsNamesNextLink) {
            this.previousPatchSolutionsNamesNextLink = previousPatchSolutionsNamesNextLink;
            this.changedFields = changedFields.add("PreviousPatchSolutionsNames");
            return this;
        }

        public SolutionDetails build() {
            SolutionDetails _x = new SolutionDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SolutionDetails";
            _x.solutionUniqueName = solutionUniqueName;
            _x.solutionFriendlyName = solutionFriendlyName;
            _x.solutionDescription = solutionDescription;
            _x.publisherUniqueName = publisherUniqueName;
            _x.publisherFriendlyName = publisherFriendlyName;
            _x.previousSolutionUniqueName = previousSolutionUniqueName;
            _x.previousSolutionFriendlyName = previousSolutionFriendlyName;
            _x.previousPublisherUniqueName = previousPublisherUniqueName;
            _x.previousPublisherFriendlyName = previousPublisherFriendlyName;
            _x.isPatchSolution = isPatchSolution;
            _x.isManaged = isManaged;
            _x.previousIsManaged = previousIsManaged;
            _x.solutionVersion = solutionVersion;
            _x.previousSolutionVersion = previousSolutionVersion;
            _x.previousPatchSolutionsNames = previousPatchSolutionsNames;
            _x.previousPatchSolutionsNamesNextLink = previousPatchSolutionsNamesNextLink;
            return _x;
        }
    }

    private SolutionDetails _copy() {
        SolutionDetails _x = new SolutionDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionUniqueName = solutionUniqueName;
        _x.solutionFriendlyName = solutionFriendlyName;
        _x.solutionDescription = solutionDescription;
        _x.publisherUniqueName = publisherUniqueName;
        _x.publisherFriendlyName = publisherFriendlyName;
        _x.previousSolutionUniqueName = previousSolutionUniqueName;
        _x.previousSolutionFriendlyName = previousSolutionFriendlyName;
        _x.previousPublisherUniqueName = previousPublisherUniqueName;
        _x.previousPublisherFriendlyName = previousPublisherFriendlyName;
        _x.isPatchSolution = isPatchSolution;
        _x.isManaged = isManaged;
        _x.previousIsManaged = previousIsManaged;
        _x.solutionVersion = solutionVersion;
        _x.previousSolutionVersion = previousSolutionVersion;
        _x.previousPatchSolutionsNames = previousPatchSolutionsNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SolutionDetails[");
        b.append("SolutionUniqueName=");
        b.append(this.solutionUniqueName);
        b.append(", ");
        b.append("SolutionFriendlyName=");
        b.append(this.solutionFriendlyName);
        b.append(", ");
        b.append("SolutionDescription=");
        b.append(this.solutionDescription);
        b.append(", ");
        b.append("PublisherUniqueName=");
        b.append(this.publisherUniqueName);
        b.append(", ");
        b.append("PublisherFriendlyName=");
        b.append(this.publisherFriendlyName);
        b.append(", ");
        b.append("PreviousSolutionUniqueName=");
        b.append(this.previousSolutionUniqueName);
        b.append(", ");
        b.append("PreviousSolutionFriendlyName=");
        b.append(this.previousSolutionFriendlyName);
        b.append(", ");
        b.append("PreviousPublisherUniqueName=");
        b.append(this.previousPublisherUniqueName);
        b.append(", ");
        b.append("PreviousPublisherFriendlyName=");
        b.append(this.previousPublisherFriendlyName);
        b.append(", ");
        b.append("IsPatchSolution=");
        b.append(this.isPatchSolution);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("PreviousIsManaged=");
        b.append(this.previousIsManaged);
        b.append(", ");
        b.append("SolutionVersion=");
        b.append(this.solutionVersion);
        b.append(", ");
        b.append("PreviousSolutionVersion=");
        b.append(this.previousSolutionVersion);
        b.append(", ");
        b.append("PreviousPatchSolutionsNames=");
        b.append(this.previousPatchSolutionsNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
