package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ErrorCode", 
    "QueryColumnSet"})
@JsonInclude(Include.NON_NULL)
public class QuickFindResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ErrorCode")
    protected Integer errorCode;

    @JsonProperty("QueryColumnSet")
    protected List<String> queryColumnSet;

    @JsonProperty("QueryColumnSet@nextLink")
    protected String queryColumnSetNextLink;

    protected QuickFindResult() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QuickFindResult";
    }

    @Property(name="ErrorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    public QuickFindResult withErrorCode(Integer errorCode) {
        QuickFindResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QuickFindResult");
        _x.errorCode = errorCode;
        return _x;
    }

    @Property(name="QueryColumnSet")
    @JsonIgnore
    public CollectionPage<String> getQueryColumnSet() {
        return new CollectionPage<String>(contextPath, String.class, this.queryColumnSet, Optional.ofNullable(queryColumnSetNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="QueryColumnSet")
    @JsonIgnore
    public CollectionPage<String> getQueryColumnSet(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.queryColumnSet, Optional.ofNullable(queryColumnSetNextLink), Collections.emptyList(), options);
    }

    public QuickFindResult withUnmappedField(String name, Object value) {
        QuickFindResult _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer errorCode;
        private List<String> queryColumnSet;
        private String queryColumnSetNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("ErrorCode");
            return this;
        }

        public Builder queryColumnSet(List<String> queryColumnSet) {
            this.queryColumnSet = queryColumnSet;
            this.changedFields = changedFields.add("QueryColumnSet");
            return this;
        }

        public Builder queryColumnSet(String... queryColumnSet) {
            return queryColumnSet(Arrays.asList(queryColumnSet));
        }

        public Builder queryColumnSetNextLink(String queryColumnSetNextLink) {
            this.queryColumnSetNextLink = queryColumnSetNextLink;
            this.changedFields = changedFields.add("QueryColumnSet");
            return this;
        }

        public QuickFindResult build() {
            QuickFindResult _x = new QuickFindResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.QuickFindResult";
            _x.errorCode = errorCode;
            _x.queryColumnSet = queryColumnSet;
            _x.queryColumnSetNextLink = queryColumnSetNextLink;
            return _x;
        }
    }

    private QuickFindResult _copy() {
        QuickFindResult _x = new QuickFindResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.errorCode = errorCode;
        _x.queryColumnSet = queryColumnSet;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QuickFindResult[");
        b.append("ErrorCode=");
        b.append(this.errorCode);
        b.append(", ");
        b.append("QueryColumnSet=");
        b.append(this.queryColumnSet);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
