package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "TimeInfos"})
@JsonInclude(Include.NON_NULL)
public class QueryScheduleResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("TimeInfos")
    protected List<TimeInfo> timeInfos;

    @JsonProperty("TimeInfos@nextLink")
    protected String timeInfosNextLink;

    protected QueryScheduleResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QueryScheduleResponse";
    }

    @Property(name="TimeInfos")
    @JsonIgnore
    public CollectionPage<TimeInfo> getTimeInfos() {
        return new CollectionPage<TimeInfo>(contextPath, TimeInfo.class, this.timeInfos, Optional.ofNullable(timeInfosNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="TimeInfos")
    @JsonIgnore
    public CollectionPage<TimeInfo> getTimeInfos(HttpRequestOptions options) {
        return new CollectionPage<TimeInfo>(contextPath, TimeInfo.class, this.timeInfos, Optional.ofNullable(timeInfosNextLink), Collections.emptyList(), options);
    }

    public QueryScheduleResponse withUnmappedField(String name, Object value) {
        QueryScheduleResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<TimeInfo> timeInfos;
        private String timeInfosNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder timeInfos(List<TimeInfo> timeInfos) {
            this.timeInfos = timeInfos;
            this.changedFields = changedFields.add("TimeInfos");
            return this;
        }

        public Builder timeInfos(TimeInfo... timeInfos) {
            return timeInfos(Arrays.asList(timeInfos));
        }

        public Builder timeInfosNextLink(String timeInfosNextLink) {
            this.timeInfosNextLink = timeInfosNextLink;
            this.changedFields = changedFields.add("TimeInfos");
            return this;
        }

        public QueryScheduleResponse build() {
            QueryScheduleResponse _x = new QueryScheduleResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.QueryScheduleResponse";
            _x.timeInfos = timeInfos;
            _x.timeInfosNextLink = timeInfosNextLink;
            return _x;
        }
    }

    private QueryScheduleResponse _copy() {
        QueryScheduleResponse _x = new QueryScheduleResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.timeInfos = timeInfos;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QueryScheduleResponse[");
        b.append("TimeInfos=");
        b.append(this.timeInfos);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
