package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "QueryId", 
    "ReturnedTypeCode", 
    "ComponentState", 
    "Name", 
    "Description", 
    "FetchXml", 
    "LayoutXml", 
    "IsDefault", 
    "ModifiedOn", 
    "QueryApi", 
    "QueryType", 
    "IsCustomizable"})
@JsonInclude(Include.NON_NULL)
public class QueryMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("QueryId")
    protected String queryId;

    @JsonProperty("ReturnedTypeCode")
    protected String returnedTypeCode;

    @JsonProperty("ComponentState")
    protected Integer componentState;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("FetchXml")
    protected String fetchXml;

    @JsonProperty("LayoutXml")
    protected String layoutXml;

    @JsonProperty("IsDefault")
    protected Boolean isDefault;

    @JsonProperty("ModifiedOn")
    protected String modifiedOn;

    @JsonProperty("QueryApi")
    protected String queryApi;

    @JsonProperty("QueryType")
    protected Integer queryType;

    @JsonProperty("IsCustomizable")
    protected Boolean isCustomizable;

    protected QueryMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.QueryMetadata";
    }

    @Property(name="QueryId")
    @JsonIgnore
    public Optional<String> getQueryId() {
        return Optional.ofNullable(queryId);
    }

    public QueryMetadata withQueryId(String queryId) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.queryId = queryId;
        return _x;
    }

    @Property(name="ReturnedTypeCode")
    @JsonIgnore
    public Optional<String> getReturnedTypeCode() {
        return Optional.ofNullable(returnedTypeCode);
    }

    public QueryMetadata withReturnedTypeCode(String returnedTypeCode) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.returnedTypeCode = returnedTypeCode;
        return _x;
    }

    @Property(name="ComponentState")
    @JsonIgnore
    public Optional<Integer> getComponentState() {
        return Optional.ofNullable(componentState);
    }

    public QueryMetadata withComponentState(Integer componentState) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.componentState = componentState;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public QueryMetadata withName(String name) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.name = name;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public QueryMetadata withDescription(String description) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="FetchXml")
    @JsonIgnore
    public Optional<String> getFetchXml() {
        return Optional.ofNullable(fetchXml);
    }

    public QueryMetadata withFetchXml(String fetchXml) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.fetchXml = fetchXml;
        return _x;
    }

    @Property(name="LayoutXml")
    @JsonIgnore
    public Optional<String> getLayoutXml() {
        return Optional.ofNullable(layoutXml);
    }

    public QueryMetadata withLayoutXml(String layoutXml) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.layoutXml = layoutXml;
        return _x;
    }

    @Property(name="IsDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public QueryMetadata withIsDefault(Boolean isDefault) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="ModifiedOn")
    @JsonIgnore
    public Optional<String> getModifiedOn() {
        return Optional.ofNullable(modifiedOn);
    }

    public QueryMetadata withModifiedOn(String modifiedOn) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.modifiedOn = modifiedOn;
        return _x;
    }

    @Property(name="QueryApi")
    @JsonIgnore
    public Optional<String> getQueryApi() {
        return Optional.ofNullable(queryApi);
    }

    public QueryMetadata withQueryApi(String queryApi) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.queryApi = queryApi;
        return _x;
    }

    @Property(name="QueryType")
    @JsonIgnore
    public Optional<Integer> getQueryType() {
        return Optional.ofNullable(queryType);
    }

    public QueryMetadata withQueryType(Integer queryType) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.queryType = queryType;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<Boolean> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public QueryMetadata withIsCustomizable(Boolean isCustomizable) {
        QueryMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.QueryMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    public QueryMetadata withUnmappedField(String name, Object value) {
        QueryMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String queryId;
        private String returnedTypeCode;
        private Integer componentState;
        private String name;
        private String description;
        private String fetchXml;
        private String layoutXml;
        private Boolean isDefault;
        private String modifiedOn;
        private String queryApi;
        private Integer queryType;
        private Boolean isCustomizable;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder queryId(String queryId) {
            this.queryId = queryId;
            this.changedFields = changedFields.add("QueryId");
            return this;
        }

        public Builder returnedTypeCode(String returnedTypeCode) {
            this.returnedTypeCode = returnedTypeCode;
            this.changedFields = changedFields.add("ReturnedTypeCode");
            return this;
        }

        public Builder componentState(Integer componentState) {
            this.componentState = componentState;
            this.changedFields = changedFields.add("ComponentState");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder fetchXml(String fetchXml) {
            this.fetchXml = fetchXml;
            this.changedFields = changedFields.add("FetchXml");
            return this;
        }

        public Builder layoutXml(String layoutXml) {
            this.layoutXml = layoutXml;
            this.changedFields = changedFields.add("LayoutXml");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("IsDefault");
            return this;
        }

        public Builder modifiedOn(String modifiedOn) {
            this.modifiedOn = modifiedOn;
            this.changedFields = changedFields.add("ModifiedOn");
            return this;
        }

        public Builder queryApi(String queryApi) {
            this.queryApi = queryApi;
            this.changedFields = changedFields.add("QueryApi");
            return this;
        }

        public Builder queryType(Integer queryType) {
            this.queryType = queryType;
            this.changedFields = changedFields.add("QueryType");
            return this;
        }

        public Builder isCustomizable(Boolean isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public QueryMetadata build() {
            QueryMetadata _x = new QueryMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.QueryMetadata";
            _x.queryId = queryId;
            _x.returnedTypeCode = returnedTypeCode;
            _x.componentState = componentState;
            _x.name = name;
            _x.description = description;
            _x.fetchXml = fetchXml;
            _x.layoutXml = layoutXml;
            _x.isDefault = isDefault;
            _x.modifiedOn = modifiedOn;
            _x.queryApi = queryApi;
            _x.queryType = queryType;
            _x.isCustomizable = isCustomizable;
            return _x;
        }
    }

    private QueryMetadata _copy() {
        QueryMetadata _x = new QueryMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.queryId = queryId;
        _x.returnedTypeCode = returnedTypeCode;
        _x.componentState = componentState;
        _x.name = name;
        _x.description = description;
        _x.fetchXml = fetchXml;
        _x.layoutXml = layoutXml;
        _x.isDefault = isDefault;
        _x.modifiedOn = modifiedOn;
        _x.queryApi = queryApi;
        _x.queryType = queryType;
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("QueryMetadata[");
        b.append("QueryId=");
        b.append(this.queryId);
        b.append(", ");
        b.append("ReturnedTypeCode=");
        b.append(this.returnedTypeCode);
        b.append(", ");
        b.append("ComponentState=");
        b.append(this.componentState);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("FetchXml=");
        b.append(this.fetchXml);
        b.append(", ");
        b.append("LayoutXml=");
        b.append(this.layoutXml);
        b.append(", ");
        b.append("IsDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("ModifiedOn=");
        b.append(this.modifiedOn);
        b.append(", ");
        b.append("QueryApi=");
        b.append(this.queryApi);
        b.append(", ");
        b.append("QueryType=");
        b.append(this.queryType);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
