package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "PageNumber", 
    "Count", 
    "ReturnTotalRecordCount", 
    "PagingCookie"})
@JsonInclude(Include.NON_NULL)
public class PagingInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PageNumber")
    protected Integer pageNumber;

    @JsonProperty("Count")
    protected Integer count;

    @JsonProperty("ReturnTotalRecordCount")
    protected Boolean returnTotalRecordCount;

    @JsonProperty("PagingCookie")
    protected String pagingCookie;

    protected PagingInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.PagingInfo";
    }

    @Property(name="PageNumber")
    @JsonIgnore
    public Optional<Integer> getPageNumber() {
        return Optional.ofNullable(pageNumber);
    }

    public PagingInfo withPageNumber(Integer pageNumber) {
        PagingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.PagingInfo");
        _x.pageNumber = pageNumber;
        return _x;
    }

    @Property(name="Count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public PagingInfo withCount(Integer count) {
        PagingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.PagingInfo");
        _x.count = count;
        return _x;
    }

    @Property(name="ReturnTotalRecordCount")
    @JsonIgnore
    public Optional<Boolean> getReturnTotalRecordCount() {
        return Optional.ofNullable(returnTotalRecordCount);
    }

    public PagingInfo withReturnTotalRecordCount(Boolean returnTotalRecordCount) {
        PagingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.PagingInfo");
        _x.returnTotalRecordCount = returnTotalRecordCount;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(pagingCookie);
    }

    public PagingInfo withPagingCookie(String pagingCookie) {
        PagingInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.PagingInfo");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    public PagingInfo withUnmappedField(String name, Object value) {
        PagingInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer pageNumber;
        private Integer count;
        private Boolean returnTotalRecordCount;
        private String pagingCookie;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder pageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
            this.changedFields = changedFields.add("PageNumber");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("Count");
            return this;
        }

        public Builder returnTotalRecordCount(Boolean returnTotalRecordCount) {
            this.returnTotalRecordCount = returnTotalRecordCount;
            this.changedFields = changedFields.add("ReturnTotalRecordCount");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = changedFields.add("PagingCookie");
            return this;
        }

        public PagingInfo build() {
            PagingInfo _x = new PagingInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.PagingInfo";
            _x.pageNumber = pageNumber;
            _x.count = count;
            _x.returnTotalRecordCount = returnTotalRecordCount;
            _x.pagingCookie = pagingCookie;
            return _x;
        }
    }

    private PagingInfo _copy() {
        PagingInfo _x = new PagingInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.pageNumber = pageNumber;
        _x.count = count;
        _x.returnTotalRecordCount = returnTotalRecordCount;
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PagingInfo[");
        b.append("PageNumber=");
        b.append(this.pageNumber);
        b.append(", ");
        b.append("Count=");
        b.append(this.count);
        b.append(", ");
        b.append("ReturnTotalRecordCount=");
        b.append(this.returnTotalRecordCount);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
