package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "RequiredComponentSchemaName", 
    "RequiredComponentDisplayName", 
    "RequiredComponentParentSchemaName", 
    "RequiredComponentParentDisplayName", 
    "RequiredComponentId", 
    "RequiredSolutionName", 
    "RequiredComponentType", 
    "DependentComponentSchemaName", 
    "DependentComponentDisplayName", 
    "DependentComponentParentSchemaName", 
    "DependentComponentParentDisplayName", 
    "DependentComponentType", 
    "DependentComponentId"})
@JsonInclude(Include.NON_NULL)
public class MissingDependency implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("RequiredComponentSchemaName")
    protected String requiredComponentSchemaName;

    @JsonProperty("RequiredComponentDisplayName")
    protected String requiredComponentDisplayName;

    @JsonProperty("RequiredComponentParentSchemaName")
    protected String requiredComponentParentSchemaName;

    @JsonProperty("RequiredComponentParentDisplayName")
    protected String requiredComponentParentDisplayName;

    @JsonProperty("RequiredComponentId")
    protected UUID requiredComponentId;

    @JsonProperty("RequiredSolutionName")
    protected String requiredSolutionName;

    @JsonProperty("RequiredComponentType")
    protected String requiredComponentType;

    @JsonProperty("DependentComponentSchemaName")
    protected String dependentComponentSchemaName;

    @JsonProperty("DependentComponentDisplayName")
    protected String dependentComponentDisplayName;

    @JsonProperty("DependentComponentParentSchemaName")
    protected String dependentComponentParentSchemaName;

    @JsonProperty("DependentComponentParentDisplayName")
    protected String dependentComponentParentDisplayName;

    @JsonProperty("DependentComponentType")
    protected String dependentComponentType;

    @JsonProperty("DependentComponentId")
    protected UUID dependentComponentId;

    protected MissingDependency() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MissingDependency";
    }

    @Property(name="RequiredComponentSchemaName")
    @JsonIgnore
    public Optional<String> getRequiredComponentSchemaName() {
        return Optional.ofNullable(requiredComponentSchemaName);
    }

    public MissingDependency withRequiredComponentSchemaName(String requiredComponentSchemaName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredComponentSchemaName = requiredComponentSchemaName;
        return _x;
    }

    @Property(name="RequiredComponentDisplayName")
    @JsonIgnore
    public Optional<String> getRequiredComponentDisplayName() {
        return Optional.ofNullable(requiredComponentDisplayName);
    }

    public MissingDependency withRequiredComponentDisplayName(String requiredComponentDisplayName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredComponentDisplayName = requiredComponentDisplayName;
        return _x;
    }

    @Property(name="RequiredComponentParentSchemaName")
    @JsonIgnore
    public Optional<String> getRequiredComponentParentSchemaName() {
        return Optional.ofNullable(requiredComponentParentSchemaName);
    }

    public MissingDependency withRequiredComponentParentSchemaName(String requiredComponentParentSchemaName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredComponentParentSchemaName = requiredComponentParentSchemaName;
        return _x;
    }

    @Property(name="RequiredComponentParentDisplayName")
    @JsonIgnore
    public Optional<String> getRequiredComponentParentDisplayName() {
        return Optional.ofNullable(requiredComponentParentDisplayName);
    }

    public MissingDependency withRequiredComponentParentDisplayName(String requiredComponentParentDisplayName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredComponentParentDisplayName = requiredComponentParentDisplayName;
        return _x;
    }

    @Property(name="RequiredComponentId")
    @JsonIgnore
    public Optional<UUID> getRequiredComponentId() {
        return Optional.ofNullable(requiredComponentId);
    }

    public MissingDependency withRequiredComponentId(UUID requiredComponentId) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredComponentId = requiredComponentId;
        return _x;
    }

    @Property(name="RequiredSolutionName")
    @JsonIgnore
    public Optional<String> getRequiredSolutionName() {
        return Optional.ofNullable(requiredSolutionName);
    }

    public MissingDependency withRequiredSolutionName(String requiredSolutionName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredSolutionName = requiredSolutionName;
        return _x;
    }

    @Property(name="RequiredComponentType")
    @JsonIgnore
    public Optional<String> getRequiredComponentType() {
        return Optional.ofNullable(requiredComponentType);
    }

    public MissingDependency withRequiredComponentType(String requiredComponentType) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.requiredComponentType = requiredComponentType;
        return _x;
    }

    @Property(name="DependentComponentSchemaName")
    @JsonIgnore
    public Optional<String> getDependentComponentSchemaName() {
        return Optional.ofNullable(dependentComponentSchemaName);
    }

    public MissingDependency withDependentComponentSchemaName(String dependentComponentSchemaName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.dependentComponentSchemaName = dependentComponentSchemaName;
        return _x;
    }

    @Property(name="DependentComponentDisplayName")
    @JsonIgnore
    public Optional<String> getDependentComponentDisplayName() {
        return Optional.ofNullable(dependentComponentDisplayName);
    }

    public MissingDependency withDependentComponentDisplayName(String dependentComponentDisplayName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.dependentComponentDisplayName = dependentComponentDisplayName;
        return _x;
    }

    @Property(name="DependentComponentParentSchemaName")
    @JsonIgnore
    public Optional<String> getDependentComponentParentSchemaName() {
        return Optional.ofNullable(dependentComponentParentSchemaName);
    }

    public MissingDependency withDependentComponentParentSchemaName(String dependentComponentParentSchemaName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.dependentComponentParentSchemaName = dependentComponentParentSchemaName;
        return _x;
    }

    @Property(name="DependentComponentParentDisplayName")
    @JsonIgnore
    public Optional<String> getDependentComponentParentDisplayName() {
        return Optional.ofNullable(dependentComponentParentDisplayName);
    }

    public MissingDependency withDependentComponentParentDisplayName(String dependentComponentParentDisplayName) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.dependentComponentParentDisplayName = dependentComponentParentDisplayName;
        return _x;
    }

    @Property(name="DependentComponentType")
    @JsonIgnore
    public Optional<String> getDependentComponentType() {
        return Optional.ofNullable(dependentComponentType);
    }

    public MissingDependency withDependentComponentType(String dependentComponentType) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.dependentComponentType = dependentComponentType;
        return _x;
    }

    @Property(name="DependentComponentId")
    @JsonIgnore
    public Optional<UUID> getDependentComponentId() {
        return Optional.ofNullable(dependentComponentId);
    }

    public MissingDependency withDependentComponentId(UUID dependentComponentId) {
        MissingDependency _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MissingDependency");
        _x.dependentComponentId = dependentComponentId;
        return _x;
    }

    public MissingDependency withUnmappedField(String name, Object value) {
        MissingDependency _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String requiredComponentSchemaName;
        private String requiredComponentDisplayName;
        private String requiredComponentParentSchemaName;
        private String requiredComponentParentDisplayName;
        private UUID requiredComponentId;
        private String requiredSolutionName;
        private String requiredComponentType;
        private String dependentComponentSchemaName;
        private String dependentComponentDisplayName;
        private String dependentComponentParentSchemaName;
        private String dependentComponentParentDisplayName;
        private String dependentComponentType;
        private UUID dependentComponentId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder requiredComponentSchemaName(String requiredComponentSchemaName) {
            this.requiredComponentSchemaName = requiredComponentSchemaName;
            this.changedFields = changedFields.add("RequiredComponentSchemaName");
            return this;
        }

        public Builder requiredComponentDisplayName(String requiredComponentDisplayName) {
            this.requiredComponentDisplayName = requiredComponentDisplayName;
            this.changedFields = changedFields.add("RequiredComponentDisplayName");
            return this;
        }

        public Builder requiredComponentParentSchemaName(String requiredComponentParentSchemaName) {
            this.requiredComponentParentSchemaName = requiredComponentParentSchemaName;
            this.changedFields = changedFields.add("RequiredComponentParentSchemaName");
            return this;
        }

        public Builder requiredComponentParentDisplayName(String requiredComponentParentDisplayName) {
            this.requiredComponentParentDisplayName = requiredComponentParentDisplayName;
            this.changedFields = changedFields.add("RequiredComponentParentDisplayName");
            return this;
        }

        public Builder requiredComponentId(UUID requiredComponentId) {
            this.requiredComponentId = requiredComponentId;
            this.changedFields = changedFields.add("RequiredComponentId");
            return this;
        }

        public Builder requiredSolutionName(String requiredSolutionName) {
            this.requiredSolutionName = requiredSolutionName;
            this.changedFields = changedFields.add("RequiredSolutionName");
            return this;
        }

        public Builder requiredComponentType(String requiredComponentType) {
            this.requiredComponentType = requiredComponentType;
            this.changedFields = changedFields.add("RequiredComponentType");
            return this;
        }

        public Builder dependentComponentSchemaName(String dependentComponentSchemaName) {
            this.dependentComponentSchemaName = dependentComponentSchemaName;
            this.changedFields = changedFields.add("DependentComponentSchemaName");
            return this;
        }

        public Builder dependentComponentDisplayName(String dependentComponentDisplayName) {
            this.dependentComponentDisplayName = dependentComponentDisplayName;
            this.changedFields = changedFields.add("DependentComponentDisplayName");
            return this;
        }

        public Builder dependentComponentParentSchemaName(String dependentComponentParentSchemaName) {
            this.dependentComponentParentSchemaName = dependentComponentParentSchemaName;
            this.changedFields = changedFields.add("DependentComponentParentSchemaName");
            return this;
        }

        public Builder dependentComponentParentDisplayName(String dependentComponentParentDisplayName) {
            this.dependentComponentParentDisplayName = dependentComponentParentDisplayName;
            this.changedFields = changedFields.add("DependentComponentParentDisplayName");
            return this;
        }

        public Builder dependentComponentType(String dependentComponentType) {
            this.dependentComponentType = dependentComponentType;
            this.changedFields = changedFields.add("DependentComponentType");
            return this;
        }

        public Builder dependentComponentId(UUID dependentComponentId) {
            this.dependentComponentId = dependentComponentId;
            this.changedFields = changedFields.add("DependentComponentId");
            return this;
        }

        public MissingDependency build() {
            MissingDependency _x = new MissingDependency();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MissingDependency";
            _x.requiredComponentSchemaName = requiredComponentSchemaName;
            _x.requiredComponentDisplayName = requiredComponentDisplayName;
            _x.requiredComponentParentSchemaName = requiredComponentParentSchemaName;
            _x.requiredComponentParentDisplayName = requiredComponentParentDisplayName;
            _x.requiredComponentId = requiredComponentId;
            _x.requiredSolutionName = requiredSolutionName;
            _x.requiredComponentType = requiredComponentType;
            _x.dependentComponentSchemaName = dependentComponentSchemaName;
            _x.dependentComponentDisplayName = dependentComponentDisplayName;
            _x.dependentComponentParentSchemaName = dependentComponentParentSchemaName;
            _x.dependentComponentParentDisplayName = dependentComponentParentDisplayName;
            _x.dependentComponentType = dependentComponentType;
            _x.dependentComponentId = dependentComponentId;
            return _x;
        }
    }

    private MissingDependency _copy() {
        MissingDependency _x = new MissingDependency();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.requiredComponentSchemaName = requiredComponentSchemaName;
        _x.requiredComponentDisplayName = requiredComponentDisplayName;
        _x.requiredComponentParentSchemaName = requiredComponentParentSchemaName;
        _x.requiredComponentParentDisplayName = requiredComponentParentDisplayName;
        _x.requiredComponentId = requiredComponentId;
        _x.requiredSolutionName = requiredSolutionName;
        _x.requiredComponentType = requiredComponentType;
        _x.dependentComponentSchemaName = dependentComponentSchemaName;
        _x.dependentComponentDisplayName = dependentComponentDisplayName;
        _x.dependentComponentParentSchemaName = dependentComponentParentSchemaName;
        _x.dependentComponentParentDisplayName = dependentComponentParentDisplayName;
        _x.dependentComponentType = dependentComponentType;
        _x.dependentComponentId = dependentComponentId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MissingDependency[");
        b.append("RequiredComponentSchemaName=");
        b.append(this.requiredComponentSchemaName);
        b.append(", ");
        b.append("RequiredComponentDisplayName=");
        b.append(this.requiredComponentDisplayName);
        b.append(", ");
        b.append("RequiredComponentParentSchemaName=");
        b.append(this.requiredComponentParentSchemaName);
        b.append(", ");
        b.append("RequiredComponentParentDisplayName=");
        b.append(this.requiredComponentParentDisplayName);
        b.append(", ");
        b.append("RequiredComponentId=");
        b.append(this.requiredComponentId);
        b.append(", ");
        b.append("RequiredSolutionName=");
        b.append(this.requiredSolutionName);
        b.append(", ");
        b.append("RequiredComponentType=");
        b.append(this.requiredComponentType);
        b.append(", ");
        b.append("DependentComponentSchemaName=");
        b.append(this.dependentComponentSchemaName);
        b.append(", ");
        b.append("DependentComponentDisplayName=");
        b.append(this.dependentComponentDisplayName);
        b.append(", ");
        b.append("DependentComponentParentSchemaName=");
        b.append(this.dependentComponentParentSchemaName);
        b.append(", ");
        b.append("DependentComponentParentDisplayName=");
        b.append(this.dependentComponentParentDisplayName);
        b.append(", ");
        b.append("DependentComponentType=");
        b.append(this.dependentComponentType);
        b.append(", ");
        b.append("DependentComponentId=");
        b.append(this.dependentComponentId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
