package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.DependencyDepth;

@JsonPropertyOrder({
    "@odata.type", 
    "MetadataType", 
    "MetadataSubtype", 
    "EntityLogicalName", 
    "MetadataId", 
    "MetadataName", 
    "MetadataNames", 
    "GetDefault", 
    "DependencyDepth", 
    "ChangedAfter", 
    "Exclude", 
    "AppId", 
    "UserMetadataDelta", 
    "SystemMetadataDelta"})
@JsonInclude(Include.NON_NULL)
public class MetadataQuery implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MetadataType")
    protected String metadataType;

    @JsonProperty("MetadataSubtype")
    protected String metadataSubtype;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("MetadataId")
    protected UUID metadataId;

    @JsonProperty("MetadataName")
    protected String metadataName;

    @JsonProperty("MetadataNames")
    protected List<String> metadataNames;

    @JsonProperty("MetadataNames@nextLink")
    protected String metadataNamesNextLink;

    @JsonProperty("GetDefault")
    protected Boolean getDefault;

    @JsonProperty("DependencyDepth")
    protected DependencyDepth dependencyDepth;

    @JsonProperty("ChangedAfter")
    protected String changedAfter;

    @JsonProperty("Exclude")
    protected List<UUID> exclude;

    @JsonProperty("Exclude@nextLink")
    protected String excludeNextLink;

    @JsonProperty("AppId")
    protected UUID appId;

    @JsonProperty("UserMetadataDelta")
    protected String userMetadataDelta;

    @JsonProperty("SystemMetadataDelta")
    protected String systemMetadataDelta;

    protected MetadataQuery() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataQuery";
    }

    @Property(name="MetadataType")
    @JsonIgnore
    public Optional<String> getMetadataType() {
        return Optional.ofNullable(metadataType);
    }

    public MetadataQuery withMetadataType(String metadataType) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataType = metadataType;
        return _x;
    }

    @Property(name="MetadataSubtype")
    @JsonIgnore
    public Optional<String> getMetadataSubtype() {
        return Optional.ofNullable(metadataSubtype);
    }

    public MetadataQuery withMetadataSubtype(String metadataSubtype) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataSubtype = metadataSubtype;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public MetadataQuery withEntityLogicalName(String entityLogicalName) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public MetadataQuery withMetadataId(UUID metadataId) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="MetadataName")
    @JsonIgnore
    public Optional<String> getMetadataName() {
        return Optional.ofNullable(metadataName);
    }

    public MetadataQuery withMetadataName(String metadataName) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.metadataName = metadataName;
        return _x;
    }

    @Property(name="MetadataNames")
    @JsonIgnore
    public CollectionPage<String> getMetadataNames() {
        return new CollectionPage<String>(contextPath, String.class, this.metadataNames, Optional.ofNullable(metadataNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="MetadataNames")
    @JsonIgnore
    public CollectionPage<String> getMetadataNames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.metadataNames, Optional.ofNullable(metadataNamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="GetDefault")
    @JsonIgnore
    public Optional<Boolean> getGetDefault() {
        return Optional.ofNullable(getDefault);
    }

    public MetadataQuery withGetDefault(Boolean getDefault) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.getDefault = getDefault;
        return _x;
    }

    @Property(name="DependencyDepth")
    @JsonIgnore
    public Optional<DependencyDepth> getDependencyDepth() {
        return Optional.ofNullable(dependencyDepth);
    }

    public MetadataQuery withDependencyDepth(DependencyDepth dependencyDepth) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.dependencyDepth = dependencyDepth;
        return _x;
    }

    @Property(name="ChangedAfter")
    @JsonIgnore
    public Optional<String> getChangedAfter() {
        return Optional.ofNullable(changedAfter);
    }

    public MetadataQuery withChangedAfter(String changedAfter) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.changedAfter = changedAfter;
        return _x;
    }

    @Property(name="Exclude")
    @JsonIgnore
    public CollectionPage<UUID> getExclude() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.exclude, Optional.ofNullable(excludeNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Exclude")
    @JsonIgnore
    public CollectionPage<UUID> getExclude(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.exclude, Optional.ofNullable(excludeNextLink), Collections.emptyList(), options);
    }

    @Property(name="AppId")
    @JsonIgnore
    public Optional<UUID> getAppId() {
        return Optional.ofNullable(appId);
    }

    public MetadataQuery withAppId(UUID appId) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.appId = appId;
        return _x;
    }

    @Property(name="UserMetadataDelta")
    @JsonIgnore
    public Optional<String> getUserMetadataDelta() {
        return Optional.ofNullable(userMetadataDelta);
    }

    public MetadataQuery withUserMetadataDelta(String userMetadataDelta) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.userMetadataDelta = userMetadataDelta;
        return _x;
    }

    @Property(name="SystemMetadataDelta")
    @JsonIgnore
    public Optional<String> getSystemMetadataDelta() {
        return Optional.ofNullable(systemMetadataDelta);
    }

    public MetadataQuery withSystemMetadataDelta(String systemMetadataDelta) {
        MetadataQuery _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataQuery");
        _x.systemMetadataDelta = systemMetadataDelta;
        return _x;
    }

    public MetadataQuery withUnmappedField(String name, Object value) {
        MetadataQuery _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String metadataType;
        private String metadataSubtype;
        private String entityLogicalName;
        private UUID metadataId;
        private String metadataName;
        private List<String> metadataNames;
        private String metadataNamesNextLink;
        private Boolean getDefault;
        private DependencyDepth dependencyDepth;
        private String changedAfter;
        private List<UUID> exclude;
        private String excludeNextLink;
        private UUID appId;
        private String userMetadataDelta;
        private String systemMetadataDelta;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataType(String metadataType) {
            this.metadataType = metadataType;
            this.changedFields = changedFields.add("MetadataType");
            return this;
        }

        public Builder metadataSubtype(String metadataSubtype) {
            this.metadataSubtype = metadataSubtype;
            this.changedFields = changedFields.add("MetadataSubtype");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder metadataName(String metadataName) {
            this.metadataName = metadataName;
            this.changedFields = changedFields.add("MetadataName");
            return this;
        }

        public Builder metadataNames(List<String> metadataNames) {
            this.metadataNames = metadataNames;
            this.changedFields = changedFields.add("MetadataNames");
            return this;
        }

        public Builder metadataNames(String... metadataNames) {
            return metadataNames(Arrays.asList(metadataNames));
        }

        public Builder metadataNamesNextLink(String metadataNamesNextLink) {
            this.metadataNamesNextLink = metadataNamesNextLink;
            this.changedFields = changedFields.add("MetadataNames");
            return this;
        }

        public Builder getDefault(Boolean getDefault) {
            this.getDefault = getDefault;
            this.changedFields = changedFields.add("GetDefault");
            return this;
        }

        public Builder dependencyDepth(DependencyDepth dependencyDepth) {
            this.dependencyDepth = dependencyDepth;
            this.changedFields = changedFields.add("DependencyDepth");
            return this;
        }

        public Builder changedAfter(String changedAfter) {
            this.changedAfter = changedAfter;
            this.changedFields = changedFields.add("ChangedAfter");
            return this;
        }

        public Builder exclude(List<UUID> exclude) {
            this.exclude = exclude;
            this.changedFields = changedFields.add("Exclude");
            return this;
        }

        public Builder exclude(UUID... exclude) {
            return exclude(Arrays.asList(exclude));
        }

        public Builder excludeNextLink(String excludeNextLink) {
            this.excludeNextLink = excludeNextLink;
            this.changedFields = changedFields.add("Exclude");
            return this;
        }

        public Builder appId(UUID appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("AppId");
            return this;
        }

        public Builder userMetadataDelta(String userMetadataDelta) {
            this.userMetadataDelta = userMetadataDelta;
            this.changedFields = changedFields.add("UserMetadataDelta");
            return this;
        }

        public Builder systemMetadataDelta(String systemMetadataDelta) {
            this.systemMetadataDelta = systemMetadataDelta;
            this.changedFields = changedFields.add("SystemMetadataDelta");
            return this;
        }

        public MetadataQuery build() {
            MetadataQuery _x = new MetadataQuery();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataQuery";
            _x.metadataType = metadataType;
            _x.metadataSubtype = metadataSubtype;
            _x.entityLogicalName = entityLogicalName;
            _x.metadataId = metadataId;
            _x.metadataName = metadataName;
            _x.metadataNames = metadataNames;
            _x.metadataNamesNextLink = metadataNamesNextLink;
            _x.getDefault = getDefault;
            _x.dependencyDepth = dependencyDepth;
            _x.changedAfter = changedAfter;
            _x.exclude = exclude;
            _x.excludeNextLink = excludeNextLink;
            _x.appId = appId;
            _x.userMetadataDelta = userMetadataDelta;
            _x.systemMetadataDelta = systemMetadataDelta;
            return _x;
        }
    }

    private MetadataQuery _copy() {
        MetadataQuery _x = new MetadataQuery();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataType = metadataType;
        _x.metadataSubtype = metadataSubtype;
        _x.entityLogicalName = entityLogicalName;
        _x.metadataId = metadataId;
        _x.metadataName = metadataName;
        _x.metadataNames = metadataNames;
        _x.getDefault = getDefault;
        _x.dependencyDepth = dependencyDepth;
        _x.changedAfter = changedAfter;
        _x.exclude = exclude;
        _x.appId = appId;
        _x.userMetadataDelta = userMetadataDelta;
        _x.systemMetadataDelta = systemMetadataDelta;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataQuery[");
        b.append("MetadataType=");
        b.append(this.metadataType);
        b.append(", ");
        b.append("MetadataSubtype=");
        b.append(this.metadataSubtype);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("MetadataName=");
        b.append(this.metadataName);
        b.append(", ");
        b.append("MetadataNames=");
        b.append(this.metadataNames);
        b.append(", ");
        b.append("GetDefault=");
        b.append(this.getDefault);
        b.append(", ");
        b.append("DependencyDepth=");
        b.append(this.dependencyDepth);
        b.append(", ");
        b.append("ChangedAfter=");
        b.append(this.changedAfter);
        b.append(", ");
        b.append("Exclude=");
        b.append(this.exclude);
        b.append(", ");
        b.append("AppId=");
        b.append(this.appId);
        b.append(", ");
        b.append("UserMetadataDelta=");
        b.append(this.userMetadataDelta);
        b.append(", ");
        b.append("SystemMetadataDelta=");
        b.append(this.systemMetadataDelta);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
