package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ObjectTypeCode", 
    "FilePointers"})
@JsonInclude(Include.NON_NULL)
public class EntityFilePointersRequest implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ObjectTypeCode")
    protected Integer objectTypeCode;

    @JsonProperty("FilePointers")
    protected List<String> filePointers;

    @JsonProperty("FilePointers@nextLink")
    protected String filePointersNextLink;

    protected EntityFilePointersRequest() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityFilePointersRequest";
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(objectTypeCode);
    }

    public EntityFilePointersRequest withObjectTypeCode(Integer objectTypeCode) {
        EntityFilePointersRequest _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityFilePointersRequest");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="FilePointers")
    @JsonIgnore
    public CollectionPage<String> getFilePointers() {
        return new CollectionPage<String>(contextPath, String.class, this.filePointers, Optional.ofNullable(filePointersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="FilePointers")
    @JsonIgnore
    public CollectionPage<String> getFilePointers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.filePointers, Optional.ofNullable(filePointersNextLink), Collections.emptyList(), options);
    }

    public EntityFilePointersRequest withUnmappedField(String name, Object value) {
        EntityFilePointersRequest _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer objectTypeCode;
        private List<String> filePointers;
        private String filePointersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder filePointers(List<String> filePointers) {
            this.filePointers = filePointers;
            this.changedFields = changedFields.add("FilePointers");
            return this;
        }

        public Builder filePointers(String... filePointers) {
            return filePointers(Arrays.asList(filePointers));
        }

        public Builder filePointersNextLink(String filePointersNextLink) {
            this.filePointersNextLink = filePointersNextLink;
            this.changedFields = changedFields.add("FilePointers");
            return this;
        }

        public EntityFilePointersRequest build() {
            EntityFilePointersRequest _x = new EntityFilePointersRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityFilePointersRequest";
            _x.objectTypeCode = objectTypeCode;
            _x.filePointers = filePointers;
            _x.filePointersNextLink = filePointersNextLink;
            return _x;
        }
    }

    private EntityFilePointersRequest _copy() {
        EntityFilePointersRequest _x = new EntityFilePointersRequest();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objectTypeCode = objectTypeCode;
        _x.filePointers = filePointers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityFilePointersRequest[");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("FilePointers=");
        b.append(this.filePointers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
