package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder({
    "@odata.type", 
    "TrueOption", 
    "FalseOption", 
    "Description", 
    "DisplayName", 
    "IsCustomOptionSet", 
    "IsGlobal", 
    "IsManaged", 
    "IsCustomizable", 
    "Name", 
    "ExternalTypeName", 
    "OptionSetType", 
    "IntroducedVersion", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class ComplexBooleanOptionSetMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("TrueOption")
    protected OptionMetadata trueOption;

    @JsonProperty("FalseOption")
    protected OptionMetadata falseOption;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("IsCustomOptionSet")
    protected Boolean isCustomOptionSet;

    @JsonProperty("IsGlobal")
    protected Boolean isGlobal;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("ExternalTypeName")
    protected String externalTypeName;

    @JsonProperty("OptionSetType")
    protected OptionSetType optionSetType;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("MetadataId")
    protected UUID metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected ComplexBooleanOptionSetMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata";
    }

    @Property(name="TrueOption")
    @JsonIgnore
    public Optional<OptionMetadata> getTrueOption() {
        return Optional.ofNullable(trueOption);
    }

    public ComplexBooleanOptionSetMetadata withTrueOption(OptionMetadata trueOption) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.trueOption = trueOption;
        return _x;
    }

    @Property(name="FalseOption")
    @JsonIgnore
    public Optional<OptionMetadata> getFalseOption() {
        return Optional.ofNullable(falseOption);
    }

    public ComplexBooleanOptionSetMetadata withFalseOption(OptionMetadata falseOption) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.falseOption = falseOption;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public ComplexBooleanOptionSetMetadata withDescription(Label description) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ComplexBooleanOptionSetMetadata withDisplayName(Label displayName) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="IsCustomOptionSet")
    @JsonIgnore
    public Optional<Boolean> getIsCustomOptionSet() {
        return Optional.ofNullable(isCustomOptionSet);
    }

    public ComplexBooleanOptionSetMetadata withIsCustomOptionSet(Boolean isCustomOptionSet) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.isCustomOptionSet = isCustomOptionSet;
        return _x;
    }

    @Property(name="IsGlobal")
    @JsonIgnore
    public Optional<Boolean> getIsGlobal() {
        return Optional.ofNullable(isGlobal);
    }

    public ComplexBooleanOptionSetMetadata withIsGlobal(Boolean isGlobal) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.isGlobal = isGlobal;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public ComplexBooleanOptionSetMetadata withIsManaged(Boolean isManaged) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public ComplexBooleanOptionSetMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ComplexBooleanOptionSetMetadata withName(String name) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.name = name;
        return _x;
    }

    @Property(name="ExternalTypeName")
    @JsonIgnore
    public Optional<String> getExternalTypeName() {
        return Optional.ofNullable(externalTypeName);
    }

    public ComplexBooleanOptionSetMetadata withExternalTypeName(String externalTypeName) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.externalTypeName = externalTypeName;
        return _x;
    }

    @Property(name="OptionSetType")
    @JsonIgnore
    public Optional<OptionSetType> getOptionSetType() {
        return Optional.ofNullable(optionSetType);
    }

    public ComplexBooleanOptionSetMetadata withOptionSetType(OptionSetType optionSetType) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.optionSetType = optionSetType;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public ComplexBooleanOptionSetMetadata withIntroducedVersion(String introducedVersion) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public ComplexBooleanOptionSetMetadata withMetadataId(UUID metadataId) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public ComplexBooleanOptionSetMetadata withHasChanged(Boolean hasChanged) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public ComplexBooleanOptionSetMetadata withUnmappedField(String name, Object value) {
        ComplexBooleanOptionSetMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OptionMetadata trueOption;
        private OptionMetadata falseOption;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private UUID metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder trueOption(OptionMetadata trueOption) {
            this.trueOption = trueOption;
            this.changedFields = changedFields.add("TrueOption");
            return this;
        }

        public Builder falseOption(OptionMetadata falseOption) {
            this.falseOption = falseOption;
            this.changedFields = changedFields.add("FalseOption");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public ComplexBooleanOptionSetMetadata build() {
            ComplexBooleanOptionSetMetadata _x = new ComplexBooleanOptionSetMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ComplexBooleanOptionSetMetadata";
            _x.trueOption = trueOption;
            _x.falseOption = falseOption;
            _x.description = description;
            _x.displayName = displayName;
            _x.isCustomOptionSet = isCustomOptionSet;
            _x.isGlobal = isGlobal;
            _x.isManaged = isManaged;
            _x.isCustomizable = isCustomizable;
            _x.name = name;
            _x.externalTypeName = externalTypeName;
            _x.optionSetType = optionSetType;
            _x.introducedVersion = introducedVersion;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private ComplexBooleanOptionSetMetadata _copy() {
        ComplexBooleanOptionSetMetadata _x = new ComplexBooleanOptionSetMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.trueOption = trueOption;
        _x.falseOption = falseOption;
        _x.description = description;
        _x.displayName = displayName;
        _x.isCustomOptionSet = isCustomOptionSet;
        _x.isGlobal = isGlobal;
        _x.isManaged = isManaged;
        _x.isCustomizable = isCustomizable;
        _x.name = name;
        _x.externalTypeName = externalTypeName;
        _x.optionSetType = optionSetType;
        _x.introducedVersion = introducedVersion;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplexBooleanOptionSetMetadata[");
        b.append("TrueOption=");
        b.append(this.trueOption);
        b.append(", ");
        b.append("FalseOption=");
        b.append(this.falseOption);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append(this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
