package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "Appointments", 
    "ResourceId"})
@JsonInclude(Include.NON_NULL)
public class AppointmentsToIgnore implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Appointments")
    protected List<UUID> appointments;

    @JsonProperty("Appointments@nextLink")
    protected String appointmentsNextLink;

    @JsonProperty("ResourceId")
    protected UUID resourceId;

    protected AppointmentsToIgnore() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppointmentsToIgnore";
    }

    @Property(name="Appointments")
    @JsonIgnore
    public CollectionPage<UUID> getAppointments() {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.appointments, Optional.ofNullable(appointmentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Appointments")
    @JsonIgnore
    public CollectionPage<UUID> getAppointments(HttpRequestOptions options) {
        return new CollectionPage<UUID>(contextPath, UUID.class, this.appointments, Optional.ofNullable(appointmentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ResourceId")
    @JsonIgnore
    public Optional<UUID> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public AppointmentsToIgnore withResourceId(UUID resourceId) {
        AppointmentsToIgnore _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppointmentsToIgnore");
        _x.resourceId = resourceId;
        return _x;
    }

    public AppointmentsToIgnore withUnmappedField(String name, Object value) {
        AppointmentsToIgnore _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<UUID> appointments;
        private String appointmentsNextLink;
        private UUID resourceId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder appointments(List<UUID> appointments) {
            this.appointments = appointments;
            this.changedFields = changedFields.add("Appointments");
            return this;
        }

        public Builder appointments(UUID... appointments) {
            return appointments(Arrays.asList(appointments));
        }

        public Builder appointmentsNextLink(String appointmentsNextLink) {
            this.appointmentsNextLink = appointmentsNextLink;
            this.changedFields = changedFields.add("Appointments");
            return this;
        }

        public Builder resourceId(UUID resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("ResourceId");
            return this;
        }

        public AppointmentsToIgnore build() {
            AppointmentsToIgnore _x = new AppointmentsToIgnore();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppointmentsToIgnore";
            _x.appointments = appointments;
            _x.appointmentsNextLink = appointmentsNextLink;
            _x.resourceId = resourceId;
            return _x;
        }
    }

    private AppointmentsToIgnore _copy() {
        AppointmentsToIgnore _x = new AppointmentsToIgnore();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appointments = appointments;
        _x.resourceId = resourceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppointmentsToIgnore[");
        b.append("Appointments=");
        b.append(this.appointments);
        b.append(", ");
        b.append("ResourceId=");
        b.append(this.resourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
