package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityId", 
    "ChartIds", 
    "Forms", 
    "Views", 
    "EntityDashboards"})
@JsonInclude(Include.NON_NULL)
public class AppEntityInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityId")
    protected String entityId;

    @JsonProperty("ChartIds")
    protected List<String> chartIds;

    @JsonProperty("ChartIds@nextLink")
    protected String chartIdsNextLink;

    @JsonProperty("Forms")
    protected List<ArtifactIdType> forms;

    @JsonProperty("Forms@nextLink")
    protected String formsNextLink;

    @JsonProperty("Views")
    protected List<ArtifactIdType> views;

    @JsonProperty("Views@nextLink")
    protected String viewsNextLink;

    @JsonProperty("EntityDashboards")
    protected List<ArtifactIdType> entityDashboards;

    @JsonProperty("EntityDashboards@nextLink")
    protected String entityDashboardsNextLink;

    protected AppEntityInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppEntityInfo";
    }

    @Property(name="EntityId")
    @JsonIgnore
    public Optional<String> getEntityId() {
        return Optional.ofNullable(entityId);
    }

    public AppEntityInfo withEntityId(String entityId) {
        AppEntityInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppEntityInfo");
        _x.entityId = entityId;
        return _x;
    }

    @Property(name="ChartIds")
    @JsonIgnore
    public CollectionPage<String> getChartIds() {
        return new CollectionPage<String>(contextPath, String.class, this.chartIds, Optional.ofNullable(chartIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ChartIds")
    @JsonIgnore
    public CollectionPage<String> getChartIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.chartIds, Optional.ofNullable(chartIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="Forms")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getForms() {
        return new CollectionPage<ArtifactIdType>(contextPath, ArtifactIdType.class, this.forms, Optional.ofNullable(formsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Forms")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getForms(HttpRequestOptions options) {
        return new CollectionPage<ArtifactIdType>(contextPath, ArtifactIdType.class, this.forms, Optional.ofNullable(formsNextLink), Collections.emptyList(), options);
    }

    @Property(name="Views")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getViews() {
        return new CollectionPage<ArtifactIdType>(contextPath, ArtifactIdType.class, this.views, Optional.ofNullable(viewsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Views")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getViews(HttpRequestOptions options) {
        return new CollectionPage<ArtifactIdType>(contextPath, ArtifactIdType.class, this.views, Optional.ofNullable(viewsNextLink), Collections.emptyList(), options);
    }

    @Property(name="EntityDashboards")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getEntityDashboards() {
        return new CollectionPage<ArtifactIdType>(contextPath, ArtifactIdType.class, this.entityDashboards, Optional.ofNullable(entityDashboardsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="EntityDashboards")
    @JsonIgnore
    public CollectionPage<ArtifactIdType> getEntityDashboards(HttpRequestOptions options) {
        return new CollectionPage<ArtifactIdType>(contextPath, ArtifactIdType.class, this.entityDashboards, Optional.ofNullable(entityDashboardsNextLink), Collections.emptyList(), options);
    }

    public AppEntityInfo withUnmappedField(String name, Object value) {
        AppEntityInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityId;
        private List<String> chartIds;
        private String chartIdsNextLink;
        private List<ArtifactIdType> forms;
        private String formsNextLink;
        private List<ArtifactIdType> views;
        private String viewsNextLink;
        private List<ArtifactIdType> entityDashboards;
        private String entityDashboardsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.changedFields = changedFields.add("EntityId");
            return this;
        }

        public Builder chartIds(List<String> chartIds) {
            this.chartIds = chartIds;
            this.changedFields = changedFields.add("ChartIds");
            return this;
        }

        public Builder chartIds(String... chartIds) {
            return chartIds(Arrays.asList(chartIds));
        }

        public Builder chartIdsNextLink(String chartIdsNextLink) {
            this.chartIdsNextLink = chartIdsNextLink;
            this.changedFields = changedFields.add("ChartIds");
            return this;
        }

        public Builder forms(List<ArtifactIdType> forms) {
            this.forms = forms;
            this.changedFields = changedFields.add("Forms");
            return this;
        }

        public Builder forms(ArtifactIdType... forms) {
            return forms(Arrays.asList(forms));
        }

        public Builder formsNextLink(String formsNextLink) {
            this.formsNextLink = formsNextLink;
            this.changedFields = changedFields.add("Forms");
            return this;
        }

        public Builder views(List<ArtifactIdType> views) {
            this.views = views;
            this.changedFields = changedFields.add("Views");
            return this;
        }

        public Builder views(ArtifactIdType... views) {
            return views(Arrays.asList(views));
        }

        public Builder viewsNextLink(String viewsNextLink) {
            this.viewsNextLink = viewsNextLink;
            this.changedFields = changedFields.add("Views");
            return this;
        }

        public Builder entityDashboards(List<ArtifactIdType> entityDashboards) {
            this.entityDashboards = entityDashboards;
            this.changedFields = changedFields.add("EntityDashboards");
            return this;
        }

        public Builder entityDashboards(ArtifactIdType... entityDashboards) {
            return entityDashboards(Arrays.asList(entityDashboards));
        }

        public Builder entityDashboardsNextLink(String entityDashboardsNextLink) {
            this.entityDashboardsNextLink = entityDashboardsNextLink;
            this.changedFields = changedFields.add("EntityDashboards");
            return this;
        }

        public AppEntityInfo build() {
            AppEntityInfo _x = new AppEntityInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppEntityInfo";
            _x.entityId = entityId;
            _x.chartIds = chartIds;
            _x.chartIdsNextLink = chartIdsNextLink;
            _x.forms = forms;
            _x.formsNextLink = formsNextLink;
            _x.views = views;
            _x.viewsNextLink = viewsNextLink;
            _x.entityDashboards = entityDashboards;
            _x.entityDashboardsNextLink = entityDashboardsNextLink;
            return _x;
        }
    }

    private AppEntityInfo _copy() {
        AppEntityInfo _x = new AppEntityInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityId = entityId;
        _x.chartIds = chartIds;
        _x.forms = forms;
        _x.views = views;
        _x.entityDashboards = entityDashboards;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppEntityInfo[");
        b.append("EntityId=");
        b.append(this.entityId);
        b.append(", ");
        b.append("ChartIds=");
        b.append(this.chartIds);
        b.append(", ");
        b.append("Forms=");
        b.append(this.forms);
        b.append(", ");
        b.append("Views=");
        b.append(this.views);
        b.append(", ");
        b.append("EntityDashboards=");
        b.append(this.entityDashboards);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
