/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.OptionMetadata;

@JsonPropertyOrder(value={"@odata.type", "State", "TransitionData"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StatusOptionMetadata
extends OptionMetadata
implements ODataType {
    @JsonProperty(value="State")
    protected Integer state;
    @JsonProperty(value="TransitionData")
    protected String transitionData;

    protected StatusOptionMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.StatusOptionMetadata";
    }

    @Property(name="State")
    @JsonIgnore
    public Optional<Integer> getState() {
        return Optional.ofNullable(this.state);
    }

    public StatusOptionMetadata withState(Integer state) {
        StatusOptionMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.StatusOptionMetadata");
        _x.state = state;
        return _x;
    }

    @Property(name="TransitionData")
    @JsonIgnore
    public Optional<String> getTransitionData() {
        return Optional.ofNullable(this.transitionData);
    }

    public StatusOptionMetadata withTransitionData(String transitionData) {
        StatusOptionMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.StatusOptionMetadata");
        _x.transitionData = transitionData;
        return _x;
    }

    @Override
    public StatusOptionMetadata withUnmappedField(String name, Object value) {
        StatusOptionMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builderStatusOptionMetadata() {
        return new Builder();
    }

    private StatusOptionMetadata _copy() {
        StatusOptionMetadata _x = new StatusOptionMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.value = this.value;
        _x.label = this.label;
        _x.description = this.description;
        _x.color = this.color;
        _x.isManaged = this.isManaged;
        _x.externalValue = this.externalValue;
        _x.parentValues = this.parentValues;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.state = this.state;
        _x.transitionData = this.transitionData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("StatusOptionMetadata[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("Color=");
        b.append(this.color);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("ExternalValue=");
        b.append(this.externalValue);
        b.append(", ");
        b.append("ParentValues=");
        b.append(this.parentValues);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("State=");
        b.append(this.state);
        b.append(", ");
        b.append("TransitionData=");
        b.append(this.transitionData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer value;
        private Label label;
        private Label description;
        private String color;
        private Boolean isManaged;
        private String externalValue;
        private List<Integer> parentValues;
        private String parentValuesNextLink;
        private UUID metadataId;
        private Boolean hasChanged;
        private Integer state;
        private String transitionData;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder value(Integer value) {
            this.value = value;
            this.changedFields = this.changedFields.add("Value");
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            this.changedFields = this.changedFields.add("Label");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder color(String color) {
            this.color = color;
            this.changedFields = this.changedFields.add("Color");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder externalValue(String externalValue) {
            this.externalValue = externalValue;
            this.changedFields = this.changedFields.add("ExternalValue");
            return this;
        }

        public Builder parentValues(List<Integer> parentValues) {
            this.parentValues = parentValues;
            this.changedFields = this.changedFields.add("ParentValues");
            return this;
        }

        public Builder parentValues(Integer ... parentValues) {
            return this.parentValues(Arrays.asList(parentValues));
        }

        public Builder parentValuesNextLink(String parentValuesNextLink) {
            this.parentValuesNextLink = parentValuesNextLink;
            this.changedFields = this.changedFields.add("ParentValues");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public Builder state(Integer state) {
            this.state = state;
            this.changedFields = this.changedFields.add("State");
            return this;
        }

        public Builder transitionData(String transitionData) {
            this.transitionData = transitionData;
            this.changedFields = this.changedFields.add("TransitionData");
            return this;
        }

        public StatusOptionMetadata build() {
            StatusOptionMetadata _x = new StatusOptionMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.StatusOptionMetadata";
            _x.value = this.value;
            _x.label = this.label;
            _x.description = this.description;
            _x.color = this.color;
            _x.isManaged = this.isManaged;
            _x.externalValue = this.externalValue;
            _x.parentValues = this.parentValues;
            _x.parentValuesNextLink = this.parentValuesNextLink;
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            _x.state = this.state;
            _x.transitionData = this.transitionData;
            return _x;
        }
    }
}

