/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.MetadataConditionExpression;
import microsoft.dynamics.crm.enums.LogicalOperator;

@JsonPropertyOrder(value={"@odata.type", "Conditions", "FilterOperator", "Filters"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MetadataFilterExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Conditions")
    protected List<MetadataConditionExpression> conditions;
    @JsonProperty(value="Conditions@nextLink")
    protected String conditionsNextLink;
    @JsonProperty(value="FilterOperator")
    protected LogicalOperator filterOperator;
    @JsonProperty(value="Filters")
    protected List<MetadataFilterExpression> filters;
    @JsonProperty(value="Filters@nextLink")
    protected String filtersNextLink;

    protected MetadataFilterExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataFilterExpression";
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<MetadataConditionExpression> getConditions() {
        return new CollectionPage(this.contextPath, MetadataConditionExpression.class, this.conditions, Optional.ofNullable(this.conditionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<MetadataConditionExpression> getConditions(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, MetadataConditionExpression.class, this.conditions, Optional.ofNullable(this.conditionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="FilterOperator")
    @JsonIgnore
    public Optional<LogicalOperator> getFilterOperator() {
        return Optional.ofNullable(this.filterOperator);
    }

    public MetadataFilterExpression withFilterOperator(LogicalOperator filterOperator) {
        MetadataFilterExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MetadataFilterExpression");
        _x.filterOperator = filterOperator;
        return _x;
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<MetadataFilterExpression> getFilters() {
        return new CollectionPage(this.contextPath, MetadataFilterExpression.class, this.filters, Optional.ofNullable(this.filtersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<MetadataFilterExpression> getFilters(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, MetadataFilterExpression.class, this.filters, Optional.ofNullable(this.filtersNextLink), Collections.emptyList(), options);
    }

    public MetadataFilterExpression withUnmappedField(String name, Object value) {
        MetadataFilterExpression _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private MetadataFilterExpression _copy() {
        MetadataFilterExpression _x = new MetadataFilterExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.conditions = this.conditions;
        _x.filterOperator = this.filterOperator;
        _x.filters = this.filters;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataFilterExpression[");
        b.append("Conditions=");
        b.append(this.conditions);
        b.append(", ");
        b.append("FilterOperator=");
        b.append((Object)this.filterOperator);
        b.append(", ");
        b.append("Filters=");
        b.append(this.filters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<MetadataConditionExpression> conditions;
        private String conditionsNextLink;
        private LogicalOperator filterOperator;
        private List<MetadataFilterExpression> filters;
        private String filtersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder conditions(List<MetadataConditionExpression> conditions) {
            this.conditions = conditions;
            this.changedFields = this.changedFields.add("Conditions");
            return this;
        }

        public Builder conditions(MetadataConditionExpression ... conditions) {
            return this.conditions(Arrays.asList(conditions));
        }

        public Builder conditionsNextLink(String conditionsNextLink) {
            this.conditionsNextLink = conditionsNextLink;
            this.changedFields = this.changedFields.add("Conditions");
            return this;
        }

        public Builder filterOperator(LogicalOperator filterOperator) {
            this.filterOperator = filterOperator;
            this.changedFields = this.changedFields.add("FilterOperator");
            return this;
        }

        public Builder filters(List<MetadataFilterExpression> filters) {
            this.filters = filters;
            this.changedFields = this.changedFields.add("Filters");
            return this;
        }

        public Builder filters(MetadataFilterExpression ... filters) {
            return this.filters(Arrays.asList(filters));
        }

        public Builder filtersNextLink(String filtersNextLink) {
            this.filtersNextLink = filtersNextLink;
            this.changedFields = this.changedFields.add("Filters");
            return this;
        }

        public MetadataFilterExpression build() {
            MetadataFilterExpression _x = new MetadataFilterExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataFilterExpression";
            _x.conditions = this.conditions;
            _x.conditionsNextLink = this.conditionsNextLink;
            _x.filterOperator = this.filterOperator;
            _x.filters = this.filters;
            _x.filtersNextLink = this.filtersNextLink;
            return _x;
        }
    }
}

