/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "EntityName", "AttributeName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityAndAttribute
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityName")
    protected String entityName;
    @JsonProperty(value="AttributeName")
    protected String attributeName;

    protected EntityAndAttribute() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityAndAttribute";
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public EntityAndAttribute withEntityName(String entityName) {
        EntityAndAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityAndAttribute");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(this.attributeName);
    }

    public EntityAndAttribute withAttributeName(String attributeName) {
        EntityAndAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityAndAttribute");
        _x.attributeName = attributeName;
        return _x;
    }

    public EntityAndAttribute withUnmappedField(String name, Object value) {
        EntityAndAttribute _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private EntityAndAttribute _copy() {
        EntityAndAttribute _x = new EntityAndAttribute();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityName = this.entityName;
        _x.attributeName = this.attributeName;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityAndAttribute[");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityName;
        private String attributeName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = this.changedFields.add("EntityName");
            return this;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = this.changedFields.add("AttributeName");
            return this;
        }

        public EntityAndAttribute build() {
            EntityAndAttribute _x = new EntityAndAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityAndAttribute";
            _x.entityName = this.entityName;
            _x.attributeName = this.attributeName;
            return _x;
        }
    }
}

