/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.IChangedItem;

@JsonPropertyOrder(value={"@odata.type", "MoreRecords", "PagingCookie", "DataToken", "Changes", "GlobalMetadataVersion"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BusinessEntityChanges
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="MoreRecords")
    protected Boolean moreRecords;
    @JsonProperty(value="PagingCookie")
    protected String pagingCookie;
    @JsonProperty(value="DataToken")
    protected String dataToken;
    @JsonProperty(value="Changes")
    protected List<IChangedItem> changes;
    @JsonProperty(value="Changes@nextLink")
    protected String changesNextLink;
    @JsonProperty(value="GlobalMetadataVersion")
    protected String globalMetadataVersion;

    protected BusinessEntityChanges() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BusinessEntityChanges";
    }

    @Property(name="MoreRecords")
    @JsonIgnore
    public Optional<Boolean> getMoreRecords() {
        return Optional.ofNullable(this.moreRecords);
    }

    public BusinessEntityChanges withMoreRecords(Boolean moreRecords) {
        BusinessEntityChanges _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.moreRecords = moreRecords;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(this.pagingCookie);
    }

    public BusinessEntityChanges withPagingCookie(String pagingCookie) {
        BusinessEntityChanges _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    @Property(name="DataToken")
    @JsonIgnore
    public Optional<String> getDataToken() {
        return Optional.ofNullable(this.dataToken);
    }

    public BusinessEntityChanges withDataToken(String dataToken) {
        BusinessEntityChanges _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.dataToken = dataToken;
        return _x;
    }

    @Property(name="Changes")
    @JsonIgnore
    public CollectionPage<IChangedItem> getChanges() {
        return new CollectionPage(this.contextPath, IChangedItem.class, this.changes, Optional.ofNullable(this.changesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Changes")
    @JsonIgnore
    public CollectionPage<IChangedItem> getChanges(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, IChangedItem.class, this.changes, Optional.ofNullable(this.changesNextLink), Collections.emptyList(), options);
    }

    @Property(name="GlobalMetadataVersion")
    @JsonIgnore
    public Optional<String> getGlobalMetadataVersion() {
        return Optional.ofNullable(this.globalMetadataVersion);
    }

    public BusinessEntityChanges withGlobalMetadataVersion(String globalMetadataVersion) {
        BusinessEntityChanges _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BusinessEntityChanges");
        _x.globalMetadataVersion = globalMetadataVersion;
        return _x;
    }

    public BusinessEntityChanges withUnmappedField(String name, Object value) {
        BusinessEntityChanges _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private BusinessEntityChanges _copy() {
        BusinessEntityChanges _x = new BusinessEntityChanges();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.moreRecords = this.moreRecords;
        _x.pagingCookie = this.pagingCookie;
        _x.dataToken = this.dataToken;
        _x.changes = this.changes;
        _x.globalMetadataVersion = this.globalMetadataVersion;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BusinessEntityChanges[");
        b.append("MoreRecords=");
        b.append(this.moreRecords);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append(", ");
        b.append("DataToken=");
        b.append(this.dataToken);
        b.append(", ");
        b.append("Changes=");
        b.append(this.changes);
        b.append(", ");
        b.append("GlobalMetadataVersion=");
        b.append(this.globalMetadataVersion);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Boolean moreRecords;
        private String pagingCookie;
        private String dataToken;
        private List<IChangedItem> changes;
        private String changesNextLink;
        private String globalMetadataVersion;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder moreRecords(Boolean moreRecords) {
            this.moreRecords = moreRecords;
            this.changedFields = this.changedFields.add("MoreRecords");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = this.changedFields.add("PagingCookie");
            return this;
        }

        public Builder dataToken(String dataToken) {
            this.dataToken = dataToken;
            this.changedFields = this.changedFields.add("DataToken");
            return this;
        }

        public Builder changes(List<IChangedItem> changes) {
            this.changes = changes;
            this.changedFields = this.changedFields.add("Changes");
            return this;
        }

        public Builder changes(IChangedItem ... changes) {
            return this.changes(Arrays.asList(changes));
        }

        public Builder changesNextLink(String changesNextLink) {
            this.changesNextLink = changesNextLink;
            this.changedFields = this.changedFields.add("Changes");
            return this;
        }

        public Builder globalMetadataVersion(String globalMetadataVersion) {
            this.globalMetadataVersion = globalMetadataVersion;
            this.changedFields = this.changedFields.add("GlobalMetadataVersion");
            return this;
        }

        public BusinessEntityChanges build() {
            BusinessEntityChanges _x = new BusinessEntityChanges();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BusinessEntityChanges";
            _x.moreRecords = this.moreRecords;
            _x.pagingCookie = this.pagingCookie;
            _x.dataToken = this.dataToken;
            _x.changes = this.changes;
            _x.changesNextLink = this.changesNextLink;
            _x.globalMetadataVersion = this.globalMetadataVersion;
            return _x;
        }
    }
}

