/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.MetadataFilterExpression;
import microsoft.dynamics.crm.complex.MetadataPropertiesExpression;

@JsonPropertyOrder(value={"@odata.type", "Criteria", "Properties"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AttributeQueryExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Criteria")
    protected MetadataFilterExpression criteria;
    @JsonProperty(value="Properties")
    protected MetadataPropertiesExpression properties;

    protected AttributeQueryExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AttributeQueryExpression";
    }

    @Property(name="Criteria")
    @JsonIgnore
    public Optional<MetadataFilterExpression> getCriteria() {
        return Optional.ofNullable(this.criteria);
    }

    public AttributeQueryExpression withCriteria(MetadataFilterExpression criteria) {
        AttributeQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AttributeQueryExpression");
        _x.criteria = criteria;
        return _x;
    }

    @Property(name="Properties")
    @JsonIgnore
    public Optional<MetadataPropertiesExpression> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    public AttributeQueryExpression withProperties(MetadataPropertiesExpression properties) {
        AttributeQueryExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AttributeQueryExpression");
        _x.properties = properties;
        return _x;
    }

    public AttributeQueryExpression withUnmappedField(String name, Object value) {
        AttributeQueryExpression _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AttributeQueryExpression _copy() {
        AttributeQueryExpression _x = new AttributeQueryExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.criteria = this.criteria;
        _x.properties = this.properties;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeQueryExpression[");
        b.append("Criteria=");
        b.append(this.criteria);
        b.append(", ");
        b.append("Properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private MetadataFilterExpression criteria;
        private MetadataPropertiesExpression properties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder criteria(MetadataFilterExpression criteria) {
            this.criteria = criteria;
            this.changedFields = this.changedFields.add("Criteria");
            return this;
        }

        public Builder properties(MetadataPropertiesExpression properties) {
            this.properties = properties;
            this.changedFields = this.changedFields.add("Properties");
            return this;
        }

        public AttributeQueryExpression build() {
            AttributeQueryExpression _x = new AttributeQueryExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AttributeQueryExpression";
            _x.criteria = this.criteria;
            _x.properties = this.properties;
            return _x;
        }
    }
}

