/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder(value={"@odata.type", "ObjectId", "AppElementType"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppElementInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ObjectId")
    protected UUID objectId;
    @JsonProperty(value="AppElementType")
    protected String appElementType;

    protected AppElementInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppElementInfo";
    }

    @Property(name="ObjectId")
    @JsonIgnore
    public Optional<UUID> getObjectId() {
        return Optional.ofNullable(this.objectId);
    }

    public AppElementInfo withObjectId(UUID objectId) {
        AppElementInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppElementInfo");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="AppElementType")
    @JsonIgnore
    public Optional<String> getAppElementType() {
        return Optional.ofNullable(this.appElementType);
    }

    public AppElementInfo withAppElementType(String appElementType) {
        AppElementInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppElementInfo");
        _x.appElementType = appElementType;
        return _x;
    }

    public AppElementInfo withUnmappedField(String name, Object value) {
        AppElementInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppElementInfo _copy() {
        AppElementInfo _x = new AppElementInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.objectId = this.objectId;
        _x.appElementType = this.appElementType;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppElementInfo[");
        b.append("ObjectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("AppElementType=");
        b.append(this.appElementType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private UUID objectId;
        private String appElementType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder objectId(UUID objectId) {
            this.objectId = objectId;
            this.changedFields = this.changedFields.add("ObjectId");
            return this;
        }

        public Builder appElementType(String appElementType) {
            this.appElementType = appElementType;
            this.changedFields = this.changedFields.add("AppElementType");
            return this;
        }

        public AppElementInfo build() {
            AppElementInfo _x = new AppElementInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppElementInfo";
            _x.objectId = this.objectId;
            _x.appElementType = this.appElementType;
            return _x;
        }
    }
}

