/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.microsoft.dynamics;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.microsoft.client.builder.Creator;
import com.github.davidmoten.microsoft.client.builder.MicrosoftClientBuilder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.PathStyle;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Supplier;
import microsoft.dynamics.crm.schema.SchemaInfo;

public final class Dynamics {
    private Dynamics() {
    }

    public static <T extends HasContext> Builder<T> service(Class<T> serviceClass) {
        return new Builder<T>(serviceClass);
    }

    public static final class Builder3<T extends HasContext> {
        private final Builder<T> b;

        public Builder3(Builder<T> b) {
            this.b = b;
        }

        public MicrosoftClientBuilder.Builder5<T> basicAuthentication(Supplier<MicrosoftClientBuilder.UsernamePassword> usernamePassword) {
            return this.createBuilder().basicAuthentication(usernamePassword);
        }

        public MicrosoftClientBuilder.Builder5<T> basicAuthentication(String username, String password) {
            return this.basicAuthentication(() -> MicrosoftClientBuilder.UsernamePassword.create((String)username, (String)password));
        }

        public MicrosoftClientBuilder.Builder<T> tenantName(String tenantName) {
            return this.createBuilder().tenantName(tenantName);
        }

        private MicrosoftClientBuilder<T> createBuilder() {
            Creator creator = context -> {
                try {
                    return (HasContext)((Builder)this.b).serviceCls.getConstructor(Context.class).newInstance(context);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new ClientException((Throwable)e);
                }
            };
            return MicrosoftClientBuilder.baseUrl((String)((String)((Builder)this.b).baseUrl.get())).creator(creator).addSchema((com.github.davidmoten.odata.client.SchemaInfo)SchemaInfo.INSTANCE).pathStyle(((Builder)this.b).pathStyle).build();
        }
    }

    public static final class Builder<T extends HasContext> {
        private final Class<T> serviceCls;
        private Optional<String> baseUrl = Optional.empty();
        private PathStyle pathStyle = PathStyle.IDENTIFIERS_IN_ROUND_BRACKETS;

        Builder(Class<T> serviceClass) {
            Preconditions.checkNotNull(serviceClass);
            this.serviceCls = serviceClass;
        }

        public Builder<T> pathStyle(PathStyle pathStyle) {
            this.pathStyle = pathStyle;
            return this;
        }

        public Builder3<T> baseUrl(String baseUrl) {
            Preconditions.checkNotNull((Object)baseUrl);
            this.baseUrl = Optional.of(baseUrl);
            return new Builder3(this);
        }
    }
}

