package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SecurityTypes implements Enum {

    @JsonProperty("None")
    NONE("None", "0"),

    @JsonProperty("Append")
    APPEND("Append", "1"),

    @JsonProperty("ParentChild")
    PARENT_CHILD("ParentChild", "2"),

    @JsonProperty("Pointer")
    POINTER("Pointer", "4"),

    @JsonProperty("Inheritance")
    INHERITANCE("Inheritance", "8");

    private final String name;
    private final String value;

    private SecurityTypes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
