package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Serviceplan;
import microsoft.dynamics.crm.entity.collection.request.AppmoduleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ServiceplanRequest extends EntityRequest<Serviceplan> {

    public ServiceplanRequest(ContextPath contextPath, Optional<Object> value) {
        super(Serviceplan.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest serviceplan_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("serviceplan_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest serviceplan_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("serviceplan_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest serviceplan_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("serviceplan_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest serviceplan_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("serviceplan_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest serviceplan_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("serviceplan_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest serviceplan_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("serviceplan_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest serviceplan_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("serviceplan_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest serviceplan_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("serviceplan_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest serviceplan_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("serviceplan_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest serviceplan_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("serviceplan_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest serviceplan_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("serviceplan_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest serviceplan_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("serviceplan_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest serviceplan_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("serviceplan_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest serviceplan_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("serviceplan_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest serviceplan_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("serviceplan_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest serviceplan_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("serviceplan_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public AppmoduleRequest serviceplan_appmodule_association(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("serviceplan_appmodule_association").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest serviceplan_appmodule_association() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("serviceplan_appmodule_association"), Optional.empty());
    }

}
