package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Goal;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class GoalRequest extends EntityRequest<Goal> {

    public GoalRequest(ContextPath contextPath, Optional<Object> value) {
        super(Goal.class, contextPath, value, false);
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupqueryactualintegerid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupqueryactualintegerid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupqueryactualmoneyid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupqueryactualmoneyid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupqueryactualdecimalid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupqueryactualdecimalid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupquerycustomintegerid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupquerycustomintegerid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupquerycustommoneyid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupquerycustommoneyid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupquerycustomdecimalid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupquerycustomdecimalid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupqueryinprogressintegerid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupqueryinprogressintegerid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupqueryinprogressmoneyid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupqueryinprogressmoneyid"), Optional.empty());
    }

    public GoalrollupqueryRequest rollupqueryinprogressdecimalid() {
        return new GoalrollupqueryRequest(contextPath.addSegment("rollupqueryinprogressdecimalid"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SystemuserRequest goalownerid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("goalownerid_systemuser"), Optional.empty());
    }

    public GoalRequest parentgoalid() {
        return new GoalRequest(contextPath.addSegment("parentgoalid"), Optional.empty());
    }

    public GoalRequest goal_parent_goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("goal_parent_goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_parent_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("goal_parent_goal"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public MetricRequest metricid() {
        return new MetricRequest(contextPath.addSegment("metricid"), Optional.empty());
    }

    public DuplicaterecordRequest goal_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Goal_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goal_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Goal_DuplicateMatchingRecord"), Optional.empty());
    }

    public GoalRequest goalwitherrorid() {
        return new GoalRequest(contextPath.addSegment("goalwitherrorid"), Optional.empty());
    }

    public GoalRequest goal_RollupError_Goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("Goal_RollupError_Goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest goal_RollupError_Goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("Goal_RollupError_Goal"), Optional.empty());
    }

    public ConnectionRequest goal_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("goal_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest goal_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("goal_connections2"), Optional.empty());
    }

    public SyncerrorRequest goal_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Goal_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest goal_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Goal_SyncErrors"), Optional.empty());
    }

    public AnnotationRequest goal_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Goal_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest goal_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Goal_Annotation"), Optional.empty());
    }

    public ConnectionRequest goal_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("goal_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest goal_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("goal_connections1"), Optional.empty());
    }

    public AsyncoperationRequest goal_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Goal_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest goal_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Goal_AsyncOperations"), Optional.empty());
    }

    public DuplicaterecordRequest goal_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Goal_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goal_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Goal_DuplicateBaseRecord"), Optional.empty());
    }

    public ProcesssessionRequest goal_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Goal_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest goal_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Goal_ProcessSessions"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest goal_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("goal_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest goal_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("goal_principalobjectattributeaccess"), Optional.empty());
    }

    public TeamRequest goalownerid_team() {
        return new TeamRequest(contextPath.addSegment("goalownerid_team"), Optional.empty());
    }

    @Action(name = "Recalculate")
    @JsonIgnore
    public ActionRequestNoReturn recalculate() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.Recalculate"), _parameters);
    }

}
