package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Exportsolutionupload;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FileattachmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class ExportsolutionuploadRequest extends EntityRequest<Exportsolutionupload> {

    public ExportsolutionuploadRequest(ContextPath contextPath, Optional<Object> value) {
        super(Exportsolutionupload.class, contextPath, value, false);
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest owninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), Optional.empty());
    }

    public TeamRequest owningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), Optional.empty());
    }

    public PrincipalRequest ownerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), Optional.empty());
    }

    public SyncerrorRequest exportsolutionupload_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("exportsolutionupload_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest exportsolutionupload_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest exportsolutionupload_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("exportsolutionupload_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest exportsolutionupload_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest exportsolutionupload_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("exportsolutionupload_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest exportsolutionupload_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_DuplicateBaseRecord"), Optional.empty());
    }

    public AsyncoperationRequest exportsolutionupload_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("exportsolutionupload_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest exportsolutionupload_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_AsyncOperations"), Optional.empty());
    }

    public MailboxtrackingfolderRequest exportsolutionupload_MailboxTrackingFolders(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("exportsolutionupload_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest exportsolutionupload_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_MailboxTrackingFolders"), Optional.empty());
    }

    public ProcesssessionRequest exportsolutionupload_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("exportsolutionupload_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest exportsolutionupload_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest exportsolutionupload_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("exportsolutionupload_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest exportsolutionupload_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest exportsolutionupload_PrincipalObjectAttributeAccesses(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("exportsolutionupload_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest exportsolutionupload_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public FileattachmentRequest exportsolutionupload_FileAttachments(UUID fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("exportsolutionupload_FileAttachments").addKeys(new NameValue(fileattachmentid, UUID.class)), Optional.empty());
    }

    public FileattachmentCollectionRequest exportsolutionupload_FileAttachments() {
        return new FileattachmentCollectionRequest(
                        contextPath.addSegment("exportsolutionupload_FileAttachments"), Optional.empty());
    }

}
