package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.EntityMetadata;
import microsoft.dynamics.crm.entity.collection.request.AttributeMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EntityKeyMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ManyToManyRelationshipMetadataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OneToManyRelationshipMetadataCollectionRequest;

@JsonIgnoreType
public class EntityMetadataRequest extends EntityRequest<EntityMetadata> {

    public EntityMetadataRequest(ContextPath contextPath, Optional<Object> value) {
        super(EntityMetadata.class, contextPath, value, false);
    }

    public AttributeMetadataRequest attributes(UUID metadataId) {
        return new AttributeMetadataRequest(contextPath.addSegment("Attributes").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public AttributeMetadataCollectionRequest attributes() {
        return new AttributeMetadataCollectionRequest(
                        contextPath.addSegment("Attributes"), Optional.empty());
    }

    public ManyToManyRelationshipMetadataRequest manyToManyRelationships2(UUID metadataId) {
        return new ManyToManyRelationshipMetadataRequest(contextPath.addSegment("ManyToManyRelationships2").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public ManyToManyRelationshipMetadataCollectionRequest manyToManyRelationships2() {
        return new ManyToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("ManyToManyRelationships2"), Optional.empty());
    }

    public OneToManyRelationshipMetadataRequest manyToOneRelationships2(UUID metadataId) {
        return new OneToManyRelationshipMetadataRequest(contextPath.addSegment("ManyToOneRelationships2").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public OneToManyRelationshipMetadataCollectionRequest manyToOneRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("ManyToOneRelationships2"), Optional.empty());
    }

    public OneToManyRelationshipMetadataRequest oneToManyRelationships2(UUID metadataId) {
        return new OneToManyRelationshipMetadataRequest(contextPath.addSegment("OneToManyRelationships2").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public OneToManyRelationshipMetadataCollectionRequest oneToManyRelationships2() {
        return new OneToManyRelationshipMetadataCollectionRequest(
                        contextPath.addSegment("OneToManyRelationships2"), Optional.empty());
    }

    public EntityKeyMetadataRequest keys(UUID metadataId) {
        return new EntityKeyMetadataRequest(contextPath.addSegment("Keys").addKeys(new NameValue(metadataId, UUID.class)), Optional.empty());
    }

    public EntityKeyMetadataCollectionRequest keys() {
        return new EntityKeyMetadataCollectionRequest(
                        contextPath.addSegment("Keys"), Optional.empty());
    }

}
