package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Roletemplate;
import microsoft.dynamics.crm.entity.request.PrivilegeRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.RoletemplateRequest;

public class RoletemplateCollectionRequest extends CollectionPageEntityRequest<Roletemplate, RoletemplateRequest>{

    protected ContextPath contextPath;

    public RoletemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Roletemplate.class, cp -> new RoletemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrivilegeRequest roletemplateprivileges_association(UUID privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("roletemplateprivileges_association").addKeys(new NameValue(privilegeid, UUID.class)), Optional.empty());
    }

    public PrivilegeCollectionRequest roletemplateprivileges_association() {
        return new PrivilegeCollectionRequest(contextPath.addSegment("roletemplateprivileges_association"), Optional.empty());
    }

    public RoleRequest role_template_roles(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("role_template_roles").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest role_template_roles() {
        return new RoleCollectionRequest(contextPath.addSegment("role_template_roles"), Optional.empty());
    }

}
