package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Processsession;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;

public class ProcesssessionCollectionRequest extends CollectionPageEntityRequest<Processsession, ProcesssessionRequest>{

    protected ContextPath contextPath;

    public ProcesssessionCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Processsession.class, cp -> new ProcesssessionRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public WorkflowlogRequest lk_workflowlog_processsession(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_processsession").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_processsession() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("lk_workflowlog_processsession"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_processsession_childworkflow(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_processsession_childworkflow").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_processsession_childworkflow() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("lk_workflowlog_processsession_childworkflow"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_previouslinkedsessionid(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_previouslinkedsessionid").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_previouslinkedsessionid() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("lk_processsession_previouslinkedsessionid"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_nextlinkedsessionid(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_nextlinkedsessionid").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_nextlinkedsessionid() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("lk_processsession_nextlinkedsessionid"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_originatingsessionid(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_originatingsessionid").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_originatingsessionid() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("lk_processsession_originatingsessionid"), Optional.empty());
    }

    public SyncerrorRequest processSession_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ProcessSession_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest processSession_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ProcessSession_SyncErrors"), Optional.empty());
    }

    public ConnectionRequest processsession_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("processsession_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest processsession_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("processsession_connections1"), Optional.empty());
    }

    public PostfollowRequest processsession_PostFollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("processsession_PostFollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest processsession_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("processsession_PostFollows"), Optional.empty());
    }

    public ConnectionRequest processsession_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("processsession_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest processsession_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("processsession_connections2"), Optional.empty());
    }

    public PostregardingRequest processsession_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("processsession_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest processsession_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("processsession_PostRegardings"), Optional.empty());
    }

}
