package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Knowledgebaserecord;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;

public class KnowledgebaserecordCollectionRequest extends CollectionPageEntityRequest<Knowledgebaserecord, KnowledgebaserecordRequest>{

    protected ContextPath contextPath;

    public KnowledgebaserecordCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Knowledgebaserecord.class, cp -> new KnowledgebaserecordRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ActivitypointerRequest knowledgeBaseRecord_ActivityPointers(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("KnowledgeBaseRecord_ActivityPointers").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest knowledgeBaseRecord_ActivityPointers() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_ActivityPointers"), Optional.empty());
    }

    public AppointmentRequest knowledgeBaseRecord_Appointments(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("KnowledgeBaseRecord_Appointments").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest knowledgeBaseRecord_Appointments() {
        return new AppointmentCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_Appointments"), Optional.empty());
    }

    public EmailRequest knowledgeBaseRecord_Emails(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("KnowledgeBaseRecord_Emails").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest knowledgeBaseRecord_Emails() {
        return new EmailCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_Emails"), Optional.empty());
    }

    public FaxRequest knowledgeBaseRecord_Faxes(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("KnowledgeBaseRecord_Faxes").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest knowledgeBaseRecord_Faxes() {
        return new FaxCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_Faxes"), Optional.empty());
    }

    public LetterRequest knowledgeBaseRecord_Letters(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("KnowledgeBaseRecord_Letters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest knowledgeBaseRecord_Letters() {
        return new LetterCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_Letters"), Optional.empty());
    }

    public PhonecallRequest knowledgeBaseRecord_PhoneCalls(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("KnowledgeBaseRecord_PhoneCalls").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest knowledgeBaseRecord_PhoneCalls() {
        return new PhonecallCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_PhoneCalls"), Optional.empty());
    }

    public TaskRequest knowledgeBaseRecord_Tasks(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("KnowledgeBaseRecord_Tasks").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest knowledgeBaseRecord_Tasks() {
        return new TaskCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_Tasks"), Optional.empty());
    }

    public RecurringappointmentmasterRequest knowledgeBaseRecord_RecurringAppointmentMasters(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("KnowledgeBaseRecord_RecurringAppointmentMasters").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest knowledgeBaseRecord_RecurringAppointmentMasters() {
        return new RecurringappointmentmasterCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_RecurringAppointmentMasters"), Optional.empty());
    }

    public SocialactivityRequest knowledgeBaseRecord_SocialActivities(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("KnowledgeBaseRecord_SocialActivities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest knowledgeBaseRecord_SocialActivities() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_SocialActivities"), Optional.empty());
    }

    public ConnectionRequest knowledgeBaseRecord_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("KnowledgeBaseRecord_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest knowledgeBaseRecord_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_connections1"), Optional.empty());
    }

    public ConnectionRequest knowledgeBaseRecord_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("KnowledgeBaseRecord_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest knowledgeBaseRecord_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_connections2"), Optional.empty());
    }

    public DuplicaterecordRequest knowledgeBaseRecord_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KnowledgeBaseRecord_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest knowledgeBaseRecord_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest knowledgeBaseRecord_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("KnowledgeBaseRecord_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest knowledgeBaseRecord_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_DuplicateBaseRecord"), Optional.empty());
    }

    public AnnotationRequest knowledgeBaseRecord_Annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("KnowledgeBaseRecord_Annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest knowledgeBaseRecord_Annotations() {
        return new AnnotationCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_Annotations"), Optional.empty());
    }

    public AsyncoperationRequest knowledgeBaseRecord_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KnowledgeBaseRecord_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest knowledgeBaseRecord_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_AsyncOperations"), Optional.empty());
    }

    public ProcesssessionRequest knowledgeBaseRecord_ProcessSession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KnowledgeBaseRecord_ProcessSession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest knowledgeBaseRecord_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_ProcessSession"), Optional.empty());
    }

    public BulkdeletefailureRequest knowledgeBaseRecord_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KnowledgeBaseRecord_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest knowledgeBaseRecord_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_BulkDeleteFailures"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest knowledgeBaseRecord_PrincipalObjectAttributeAccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("KnowledgeBaseRecord_PrincipalObjectAttributeAccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest knowledgeBaseRecord_PrincipalObjectAttributeAccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_PrincipalObjectAttributeAccess"), Optional.empty());
    }

    public SyncerrorRequest knowledgeBaseRecord_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KnowledgeBaseRecord_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest knowledgeBaseRecord_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("KnowledgeBaseRecord_SyncErrors"), Optional.empty());
    }

}
