package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Emailserverprofile;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TracelogRequest;

public class EmailserverprofileCollectionRequest extends CollectionPageEntityRequest<Emailserverprofile, EmailserverprofileRequest>{

    protected ContextPath contextPath;

    public EmailserverprofileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Emailserverprofile.class, cp -> new EmailserverprofileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public MailboxRequest emailserverprofile_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("emailserverprofile_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest emailserverprofile_mailbox() {
        return new MailboxCollectionRequest(contextPath.addSegment("emailserverprofile_mailbox"), Optional.empty());
    }

    public AsyncoperationRequest emailserverprofile_asyncoperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("emailserverprofile_asyncoperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest emailserverprofile_asyncoperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("emailserverprofile_asyncoperations"), Optional.empty());
    }

    public BulkdeletefailureRequest emailserverprofile_bulkdeletefailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("emailserverprofile_bulkdeletefailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest emailserverprofile_bulkdeletefailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("emailserverprofile_bulkdeletefailures"), Optional.empty());
    }

    public OrganizationRequest emailServerProfile_Organization(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("EmailServerProfile_Organization").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest emailServerProfile_Organization() {
        return new OrganizationCollectionRequest(contextPath.addSegment("EmailServerProfile_Organization"), Optional.empty());
    }

    public TracelogRequest tracelog_EmailServerProfile(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("tracelog_EmailServerProfile").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest tracelog_EmailServerProfile() {
        return new TracelogCollectionRequest(contextPath.addSegment("tracelog_EmailServerProfile"), Optional.empty());
    }

    public AnnotationRequest emailServerProfile_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("EmailServerProfile_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest emailServerProfile_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("EmailServerProfile_Annotation"), Optional.empty());
    }

    public DuplicaterecordRequest emailserverprofile_duplicatematchingrecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("emailserverprofile_duplicatematchingrecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest emailserverprofile_duplicatematchingrecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("emailserverprofile_duplicatematchingrecord"), Optional.empty());
    }

    public SyncerrorRequest emailServerProfile_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("EmailServerProfile_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest emailServerProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("EmailServerProfile_SyncErrors"), Optional.empty());
    }

    public DuplicaterecordRequest emailserverprofile_duplicatebaserecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("emailserverprofile_duplicatebaserecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest emailserverprofile_duplicatebaserecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("emailserverprofile_duplicatebaserecord"), Optional.empty());
    }

}
