package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Businessunit;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.CallbackregistrationRequest;
import microsoft.dynamics.crm.entity.request.CanvasappRequest;
import microsoft.dynamics.crm.entity.request.CategoryRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.ConnectionreferenceRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExchangesyncidmappingRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.GoalrollupqueryRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;
import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.InteractionforemailRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.MailboxRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aifptrainingdocumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aitemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_richtextfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.PersonaldocumenttemplateRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageparameterRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.RecurrenceruleRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.ReportRequest;
import microsoft.dynamics.crm.entity.request.RoleRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;
import microsoft.dynamics.crm.entity.request.UserformRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;
import microsoft.dynamics.crm.entity.request.UserqueryvisualizationRequest;
import microsoft.dynamics.crm.entity.request.UsersettingsRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;

public class BusinessunitCollectionRequest extends CollectionPageEntityRequest<Businessunit, BusinessunitRequest>{

    protected ContextPath contextPath;

    public BusinessunitCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Businessunit.class, cp -> new BusinessunitRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ExchangesyncidmappingRequest business_unit_exchangesyncidmapping(UUID exchangesyncidmappingid) {
        return new ExchangesyncidmappingRequest(contextPath.addSegment("business_unit_exchangesyncidmapping").addKeys(new NameValue(exchangesyncidmappingid, UUID.class)), Optional.empty());
    }

    public ExchangesyncidmappingCollectionRequest business_unit_exchangesyncidmapping() {
        return new ExchangesyncidmappingCollectionRequest(contextPath.addSegment("business_unit_exchangesyncidmapping"), Optional.empty());
    }

    public InteractionforemailRequest business_unit_new_interactionforemail(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("business_unit_new_interactionforemail").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest business_unit_new_interactionforemail() {
        return new InteractionforemailCollectionRequest(contextPath.addSegment("business_unit_new_interactionforemail"), Optional.empty());
    }

    public KnowledgearticleRequest business_unit_knowledgearticle(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("business_unit_knowledgearticle").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest business_unit_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(contextPath.addSegment("business_unit_knowledgearticle"), Optional.empty());
    }

    public SharepointdocumentlocationRequest business_unit_sharepointdocumentlocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("business_unit_sharepointdocumentlocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest business_unit_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("business_unit_sharepointdocumentlocation"), Optional.empty());
    }

    public GoalRequest business_unit_goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("business_unit_goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest business_unit_goal() {
        return new GoalCollectionRequest(contextPath.addSegment("business_unit_goal"), Optional.empty());
    }

    public MailboxRequest business_unit_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("business_unit_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest business_unit_mailbox() {
        return new MailboxCollectionRequest(contextPath.addSegment("business_unit_mailbox"), Optional.empty());
    }

    public RecurrenceruleRequest business_unit_recurrencerule(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("business_unit_recurrencerule").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest business_unit_recurrencerule() {
        return new RecurrenceruleCollectionRequest(contextPath.addSegment("business_unit_recurrencerule"), Optional.empty());
    }

    public SyncerrorRequest businessUnit_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("BusinessUnit_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest businessUnit_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("BusinessUnit_SyncErrors"), Optional.empty());
    }

    public BulkdeleteoperationRequest bulkDeleteOperation_BusinessUnit(UUID bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("BulkDeleteOperation_BusinessUnit").addKeys(new NameValue(bulkdeleteoperationid, UUID.class)), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest bulkDeleteOperation_BusinessUnit() {
        return new BulkdeleteoperationCollectionRequest(contextPath.addSegment("BulkDeleteOperation_BusinessUnit"), Optional.empty());
    }

    public WorkflowRequest business_unit_workflow(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("business_unit_workflow").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest business_unit_workflow() {
        return new WorkflowCollectionRequest(contextPath.addSegment("business_unit_workflow"), Optional.empty());
    }

    public SyncerrorRequest businessUnit_SyncError(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("BusinessUnit_SyncError").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest businessUnit_SyncError() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("BusinessUnit_SyncError"), Optional.empty());
    }

    public PostregardingRequest business_unit_PostRegarding(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("business_unit_PostRegarding").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest business_unit_PostRegarding() {
        return new PostregardingCollectionRequest(contextPath.addSegment("business_unit_PostRegarding"), Optional.empty());
    }

    public PostfollowRequest business_unit_postfollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("business_unit_postfollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest business_unit_postfollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("business_unit_postfollows"), Optional.empty());
    }

    public AsyncoperationRequest businessUnit_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("BusinessUnit_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest businessUnit_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("BusinessUnit_AsyncOperations"), Optional.empty());
    }

    public QueueRequest business_unit_queues(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("business_unit_queues").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest business_unit_queues() {
        return new QueueCollectionRequest(contextPath.addSegment("business_unit_queues"), Optional.empty());
    }

    public FaxRequest business_unit_fax_activities(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("business_unit_fax_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest business_unit_fax_activities() {
        return new FaxCollectionRequest(contextPath.addSegment("business_unit_fax_activities"), Optional.empty());
    }

    public CalendarRequest business_unit_calendars(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("business_unit_calendars").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public CalendarCollectionRequest business_unit_calendars() {
        return new CalendarCollectionRequest(contextPath.addSegment("business_unit_calendars"), Optional.empty());
    }

    public ImportlogRequest businessUnit_ImportLogs(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("BusinessUnit_ImportLogs").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest businessUnit_ImportLogs() {
        return new ImportlogCollectionRequest(contextPath.addSegment("BusinessUnit_ImportLogs"), Optional.empty());
    }

    public AnnotationRequest business_unit_annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("business_unit_annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest business_unit_annotations() {
        return new AnnotationCollectionRequest(contextPath.addSegment("business_unit_annotations"), Optional.empty());
    }

    public RecurringappointmentmasterRequest business_unit_recurringappointmentmaster_activities(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("business_unit_recurringappointmentmaster_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest business_unit_recurringappointmentmaster_activities() {
        return new RecurringappointmentmasterCollectionRequest(contextPath.addSegment("business_unit_recurringappointmentmaster_activities"), Optional.empty());
    }

    public TemplateRequest business_unit_templates(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("business_unit_templates").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest business_unit_templates() {
        return new TemplateCollectionRequest(contextPath.addSegment("business_unit_templates"), Optional.empty());
    }

    public AccountRequest business_unit_accounts(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("business_unit_accounts").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest business_unit_accounts() {
        return new AccountCollectionRequest(contextPath.addSegment("business_unit_accounts"), Optional.empty());
    }

    public SocialprofileRequest business_unit_socialprofiles(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("business_unit_socialprofiles").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public SocialprofileCollectionRequest business_unit_socialprofiles() {
        return new SocialprofileCollectionRequest(contextPath.addSegment("business_unit_socialprofiles"), Optional.empty());
    }

    public AppointmentRequest business_unit_appointment_activities(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("business_unit_appointment_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest business_unit_appointment_activities() {
        return new AppointmentCollectionRequest(contextPath.addSegment("business_unit_appointment_activities"), Optional.empty());
    }

    public LetterRequest business_unit_letter_activities(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("business_unit_letter_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest business_unit_letter_activities() {
        return new LetterCollectionRequest(contextPath.addSegment("business_unit_letter_activities"), Optional.empty());
    }

    public ActioncardRequest business_unit_actioncards(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("business_unit_actioncards").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest business_unit_actioncards() {
        return new ActioncardCollectionRequest(contextPath.addSegment("business_unit_actioncards"), Optional.empty());
    }

    public TaskRequest business_unit_task_activities(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("business_unit_task_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest business_unit_task_activities() {
        return new TaskCollectionRequest(contextPath.addSegment("business_unit_task_activities"), Optional.empty());
    }

    public ActivitypointerRequest business_unit_activitypointer(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("business_unit_activitypointer").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest business_unit_activitypointer() {
        return new ActivitypointerCollectionRequest(contextPath.addSegment("business_unit_activitypointer"), Optional.empty());
    }

    public QueueRequest business_unit_queues2(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("business_unit_queues2").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest business_unit_queues2() {
        return new QueueCollectionRequest(contextPath.addSegment("business_unit_queues2"), Optional.empty());
    }

    public AsyncoperationRequest business_unit_asyncoperation(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("business_unit_asyncoperation").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest business_unit_asyncoperation() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("business_unit_asyncoperation"), Optional.empty());
    }

    public EmailRequest business_unit_email_activities(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("business_unit_email_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest business_unit_email_activities() {
        return new EmailCollectionRequest(contextPath.addSegment("business_unit_email_activities"), Optional.empty());
    }

    public RoleRequest business_unit_roles(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("business_unit_roles").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest business_unit_roles() {
        return new RoleCollectionRequest(contextPath.addSegment("business_unit_roles"), Optional.empty());
    }

    public TeamRequest business_unit_teams(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("business_unit_teams").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest business_unit_teams() {
        return new TeamCollectionRequest(contextPath.addSegment("business_unit_teams"), Optional.empty());
    }

    public UserqueryvisualizationRequest business_unit_userqueryvisualizations(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("business_unit_userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest business_unit_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(contextPath.addSegment("business_unit_userqueryvisualizations"), Optional.empty());
    }

    public SlakpiinstanceRequest business_unit_slakpiinstance(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("business_unit_slakpiinstance").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest business_unit_slakpiinstance() {
        return new SlakpiinstanceCollectionRequest(contextPath.addSegment("business_unit_slakpiinstance"), Optional.empty());
    }

    public ProcesssessionRequest owning_businessunit_processsessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Owning_businessunit_processsessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest owning_businessunit_processsessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Owning_businessunit_processsessions"), Optional.empty());
    }

    public DuplicateruleRequest businessUnit_DuplicateRules(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("BusinessUnit_DuplicateRules").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest businessUnit_DuplicateRules() {
        return new DuplicateruleCollectionRequest(contextPath.addSegment("BusinessUnit_DuplicateRules"), Optional.empty());
    }

    public ImportdataRequest businessUnit_ImportData(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("BusinessUnit_ImportData").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest businessUnit_ImportData() {
        return new ImportdataCollectionRequest(contextPath.addSegment("BusinessUnit_ImportData"), Optional.empty());
    }

    public ProcesssessionRequest businessUnit_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("BusinessUnit_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest businessUnit_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("BusinessUnit_ProcessSessions"), Optional.empty());
    }

    public PhonecallRequest business_unit_phone_call_activities(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("business_unit_phone_call_activities").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest business_unit_phone_call_activities() {
        return new PhonecallCollectionRequest(contextPath.addSegment("business_unit_phone_call_activities"), Optional.empty());
    }

    public ContactRequest business_unit_contacts(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("business_unit_contacts").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest business_unit_contacts() {
        return new ContactCollectionRequest(contextPath.addSegment("business_unit_contacts"), Optional.empty());
    }

    public SharepointsiteRequest business_unit_sharepointsites(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("business_unit_sharepointsites").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest business_unit_sharepointsites() {
        return new SharepointsiteCollectionRequest(contextPath.addSegment("business_unit_sharepointsites"), Optional.empty());
    }

    public EmailserverprofileRequest business_unit_emailserverprofile(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("business_unit_emailserverprofile").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest business_unit_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(contextPath.addSegment("business_unit_emailserverprofile"), Optional.empty());
    }

    public MailmergetemplateRequest business_unit_mailmergetemplates(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("business_unit_mailmergetemplates").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest business_unit_mailmergetemplates() {
        return new MailmergetemplateCollectionRequest(contextPath.addSegment("business_unit_mailmergetemplates"), Optional.empty());
    }

    public WorkflowlogRequest business_unit_workflowlogs(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("business_unit_workflowlogs").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest business_unit_workflowlogs() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("business_unit_workflowlogs"), Optional.empty());
    }

    public BulkdeletefailureRequest businessUnit_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("BusinessUnit_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest businessUnit_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("BusinessUnit_BulkDeleteFailures"), Optional.empty());
    }

    public ConnectionRequest business_unit_connections(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("business_unit_connections").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest business_unit_connections() {
        return new ConnectionCollectionRequest(contextPath.addSegment("business_unit_connections"), Optional.empty());
    }

    public PersonaldocumenttemplateRequest business_unit_personaldocumenttemplates(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("business_unit_personaldocumenttemplates").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public PersonaldocumenttemplateCollectionRequest business_unit_personaldocumenttemplates() {
        return new PersonaldocumenttemplateCollectionRequest(contextPath.addSegment("business_unit_personaldocumenttemplates"), Optional.empty());
    }

    public ImportfileRequest businessUnit_ImportFiles(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("BusinessUnit_ImportFiles").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest businessUnit_ImportFiles() {
        return new ImportfileCollectionRequest(contextPath.addSegment("BusinessUnit_ImportFiles"), Optional.empty());
    }

    public FeedbackRequest business_unit_feedback(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("business_unit_feedback").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest business_unit_feedback() {
        return new FeedbackCollectionRequest(contextPath.addSegment("business_unit_feedback"), Optional.empty());
    }

    public ReportRequest business_unit_reports(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("business_unit_reports").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public ReportCollectionRequest business_unit_reports() {
        return new ReportCollectionRequest(contextPath.addSegment("business_unit_reports"), Optional.empty());
    }

    public MailboxtrackingfolderRequest businessunit_mailboxtrackingfolder(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("businessunit_mailboxtrackingfolder").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest businessunit_mailboxtrackingfolder() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("businessunit_mailboxtrackingfolder"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest businessunit_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("businessunit_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest businessunit_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("businessunit_principalobjectattributeaccess"), Optional.empty());
    }

    public UsersettingsRequest business_unit_user_settings(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("business_unit_user_settings").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest business_unit_user_settings() {
        return new UsersettingsCollectionRequest(contextPath.addSegment("business_unit_user_settings"), Optional.empty());
    }

    public ImportRequest businessUnit_Imports(UUID importid) {
        return new ImportRequest(contextPath.addSegment("BusinessUnit_Imports").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest businessUnit_Imports() {
        return new ImportCollectionRequest(contextPath.addSegment("BusinessUnit_Imports"), Optional.empty());
    }

    public CategoryRequest business_unit_category(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("business_unit_category").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest business_unit_category() {
        return new CategoryCollectionRequest(contextPath.addSegment("business_unit_category"), Optional.empty());
    }

    public SystemuserRequest business_unit_system_users(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("business_unit_system_users").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest business_unit_system_users() {
        return new SystemuserCollectionRequest(contextPath.addSegment("business_unit_system_users"), Optional.empty());
    }

    public SlaRequest business_unit_slabase(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("business_unit_slabase").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest business_unit_slabase() {
        return new SlaCollectionRequest(contextPath.addSegment("business_unit_slabase"), Optional.empty());
    }

    public UserformRequest business_unit_userform(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("business_unit_userform").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest business_unit_userform() {
        return new UserformCollectionRequest(contextPath.addSegment("business_unit_userform"), Optional.empty());
    }

    public SocialactivityRequest business_unit_socialactivity(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("business_unit_socialactivity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest business_unit_socialactivity() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("business_unit_socialactivity"), Optional.empty());
    }

    public GoalrollupqueryRequest business_unit_goalrollupquery(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("business_unit_goalrollupquery").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest business_unit_goalrollupquery() {
        return new GoalrollupqueryCollectionRequest(contextPath.addSegment("business_unit_goalrollupquery"), Optional.empty());
    }

    public UserqueryRequest business_unit_userquery(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("business_unit_userquery").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest business_unit_userquery() {
        return new UserqueryCollectionRequest(contextPath.addSegment("business_unit_userquery"), Optional.empty());
    }

    public ImportmapRequest businessUnit_ImportMaps(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("BusinessUnit_ImportMaps").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest businessUnit_ImportMaps() {
        return new ImportmapCollectionRequest(contextPath.addSegment("BusinessUnit_ImportMaps"), Optional.empty());
    }

    public BusinessunitRequest business_unit_parent_business_unit(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("business_unit_parent_business_unit").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest business_unit_parent_business_unit() {
        return new BusinessunitCollectionRequest(contextPath.addSegment("business_unit_parent_business_unit"), Optional.empty());
    }

    public CallbackregistrationRequest businessunit_callbackregistration(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("businessunit_callbackregistration").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public CallbackregistrationCollectionRequest businessunit_callbackregistration() {
        return new CallbackregistrationCollectionRequest(contextPath.addSegment("businessunit_callbackregistration"), Optional.empty());
    }

    public CanvasappRequest businessunit_canvasapp(UUID canvasappid) {
        return new CanvasappRequest(contextPath.addSegment("businessunit_canvasapp").addKeys(new NameValue(canvasappid, UUID.class)), Optional.empty());
    }

    public CanvasappCollectionRequest businessunit_canvasapp() {
        return new CanvasappCollectionRequest(contextPath.addSegment("businessunit_canvasapp"), Optional.empty());
    }

    public StagesolutionuploadRequest business_unit_stagesolutionupload(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("business_unit_stagesolutionupload").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest business_unit_stagesolutionupload() {
        return new StagesolutionuploadCollectionRequest(contextPath.addSegment("business_unit_stagesolutionupload"), Optional.empty());
    }

    public ExportsolutionuploadRequest business_unit_exportsolutionupload(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("business_unit_exportsolutionupload").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest business_unit_exportsolutionupload() {
        return new ExportsolutionuploadCollectionRequest(contextPath.addSegment("business_unit_exportsolutionupload"), Optional.empty());
    }

    public ApplicationuserRequest business_unit_applicationuser(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("business_unit_applicationuser").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public ApplicationuserCollectionRequest business_unit_applicationuser() {
        return new ApplicationuserCollectionRequest(contextPath.addSegment("business_unit_applicationuser"), Optional.empty());
    }

    public ConnectorRequest business_unit_connector(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("business_unit_connector").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest business_unit_connector() {
        return new ConnectorCollectionRequest(contextPath.addSegment("business_unit_connector"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest business_unit_environmentvariabledefinition(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("business_unit_environmentvariabledefinition").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest business_unit_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionCollectionRequest(contextPath.addSegment("business_unit_environmentvariabledefinition"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest business_unit_environmentvariablevalue(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("business_unit_environmentvariablevalue").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest business_unit_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(contextPath.addSegment("business_unit_environmentvariablevalue"), Optional.empty());
    }

    public ProcessstageparameterRequest business_unit_processstageparameter(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("business_unit_processstageparameter").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest business_unit_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(contextPath.addSegment("business_unit_processstageparameter"), Optional.empty());
    }

    public FlowsessionRequest business_unit_flowsession(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("business_unit_flowsession").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest business_unit_flowsession() {
        return new FlowsessionCollectionRequest(contextPath.addSegment("business_unit_flowsession"), Optional.empty());
    }

    public WorkflowbinaryRequest business_unit_workflowbinary(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("business_unit_workflowbinary").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest business_unit_workflowbinary() {
        return new WorkflowbinaryCollectionRequest(contextPath.addSegment("business_unit_workflowbinary"), Optional.empty());
    }

    public ConnectionreferenceRequest business_unit_connectionreference(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("business_unit_connectionreference").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest business_unit_connectionreference() {
        return new ConnectionreferenceCollectionRequest(contextPath.addSegment("business_unit_connectionreference"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest business_unit_msdyn_serviceconfiguration(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("business_unit_msdyn_serviceconfiguration").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest business_unit_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationCollectionRequest(contextPath.addSegment("business_unit_msdyn_serviceconfiguration"), Optional.empty());
    }

    public Msdyn_slakpiRequest business_unit_msdyn_slakpi(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("business_unit_msdyn_slakpi").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest business_unit_msdyn_slakpi() {
        return new Msdyn_slakpiCollectionRequest(contextPath.addSegment("business_unit_msdyn_slakpi"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest business_unit_msdyn_knowledgearticleimage(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("business_unit_msdyn_knowledgearticleimage").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest business_unit_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageCollectionRequest(contextPath.addSegment("business_unit_msdyn_knowledgearticleimage"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest business_unit_msdyn_knowledgearticletemplate(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("business_unit_msdyn_knowledgearticletemplate").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest business_unit_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(contextPath.addSegment("business_unit_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    public Msdyn_dataflowRequest business_unit_msdyn_dataflow(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("business_unit_msdyn_dataflow").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest business_unit_msdyn_dataflow() {
        return new Msdyn_dataflowCollectionRequest(contextPath.addSegment("business_unit_msdyn_dataflow"), Optional.empty());
    }

    public Msdyn_richtextfileRequest business_unit_msdyn_richtextfile(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("business_unit_msdyn_richtextfile").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest business_unit_msdyn_richtextfile() {
        return new Msdyn_richtextfileCollectionRequest(contextPath.addSegment("business_unit_msdyn_richtextfile"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest business_unit_msdyn_aiconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("business_unit_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest business_unit_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(contextPath.addSegment("business_unit_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aimodelRequest business_unit_msdyn_aimodel(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("business_unit_msdyn_aimodel").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest business_unit_msdyn_aimodel() {
        return new Msdyn_aimodelCollectionRequest(contextPath.addSegment("business_unit_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aitemplateRequest business_unit_msdyn_aitemplate(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("business_unit_msdyn_aitemplate").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest business_unit_msdyn_aitemplate() {
        return new Msdyn_aitemplateCollectionRequest(contextPath.addSegment("business_unit_msdyn_aitemplate"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest business_unit_msdyn_aibdataset(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("business_unit_msdyn_aibdataset").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest business_unit_msdyn_aibdataset() {
        return new Msdyn_aibdatasetCollectionRequest(contextPath.addSegment("business_unit_msdyn_aibdataset"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest business_unit_msdyn_aibdatasetfile(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("business_unit_msdyn_aibdatasetfile").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest business_unit_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileCollectionRequest(contextPath.addSegment("business_unit_msdyn_aibdatasetfile"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest business_unit_msdyn_aibdatasetrecord(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("business_unit_msdyn_aibdatasetrecord").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest business_unit_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordCollectionRequest(contextPath.addSegment("business_unit_msdyn_aibdatasetrecord"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest business_unit_msdyn_aibdatasetscontainer(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("business_unit_msdyn_aibdatasetscontainer").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest business_unit_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(contextPath.addSegment("business_unit_msdyn_aibdatasetscontainer"), Optional.empty());
    }

    public Msdyn_aibfileRequest business_unit_msdyn_aibfile(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("business_unit_msdyn_aibfile").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest business_unit_msdyn_aibfile() {
        return new Msdyn_aibfileCollectionRequest(contextPath.addSegment("business_unit_msdyn_aibfile"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest business_unit_msdyn_aibfileattacheddata(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("business_unit_msdyn_aibfileattacheddata").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest business_unit_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataCollectionRequest(contextPath.addSegment("business_unit_msdyn_aibfileattacheddata"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest business_unit_msdyn_aifptrainingdocument(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("business_unit_msdyn_aifptrainingdocument").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest business_unit_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(contextPath.addSegment("business_unit_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest business_unit_msdyn_aiodimage(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("business_unit_msdyn_aiodimage").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest business_unit_msdyn_aiodimage() {
        return new Msdyn_aiodimageCollectionRequest(contextPath.addSegment("business_unit_msdyn_aiodimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest business_unit_msdyn_aiodlabel(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("business_unit_msdyn_aiodlabel").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest business_unit_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelCollectionRequest(contextPath.addSegment("business_unit_msdyn_aiodlabel"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest business_unit_msdyn_aiodtrainingboundingbox(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("business_unit_msdyn_aiodtrainingboundingbox").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest business_unit_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(contextPath.addSegment("business_unit_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest business_unit_msdyn_aiodtrainingimage(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("business_unit_msdyn_aiodtrainingimage").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest business_unit_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(contextPath.addSegment("business_unit_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest business_unit_msdyn_analysiscomponent(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("business_unit_msdyn_analysiscomponent").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest business_unit_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentCollectionRequest(contextPath.addSegment("business_unit_msdyn_analysiscomponent"), Optional.empty());
    }

    public Msdyn_analysisjobRequest business_unit_msdyn_analysisjob(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("business_unit_msdyn_analysisjob").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest business_unit_msdyn_analysisjob() {
        return new Msdyn_analysisjobCollectionRequest(contextPath.addSegment("business_unit_msdyn_analysisjob"), Optional.empty());
    }

    public Msdyn_analysisresultRequest business_unit_msdyn_analysisresult(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("business_unit_msdyn_analysisresult").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest business_unit_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(contextPath.addSegment("business_unit_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest business_unit_msdyn_analysisresultdetail(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("business_unit_msdyn_analysisresultdetail").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest business_unit_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailCollectionRequest(contextPath.addSegment("business_unit_msdyn_analysisresultdetail"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest business_unit_msdyn_solutionhealthrule(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("business_unit_msdyn_solutionhealthrule").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest business_unit_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleCollectionRequest(contextPath.addSegment("business_unit_msdyn_solutionhealthrule"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest business_unit_msdyn_solutionhealthruleargument(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("business_unit_msdyn_solutionhealthruleargument").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest business_unit_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(contextPath.addSegment("business_unit_msdyn_solutionhealthruleargument"), Optional.empty());
    }

    public Ggw_eventRequest business_unit_ggw_event(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("business_unit_ggw_event").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest business_unit_ggw_event() {
        return new Ggw_eventCollectionRequest(contextPath.addSegment("business_unit_ggw_event"), Optional.empty());
    }

    public Ggw_teamRequest business_unit_ggw_team(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("business_unit_ggw_team").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest business_unit_ggw_team() {
        return new Ggw_teamCollectionRequest(contextPath.addSegment("business_unit_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest business_unit_ggw_crew(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("business_unit_ggw_crew").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest business_unit_ggw_crew() {
        return new Ggw_crewCollectionRequest(contextPath.addSegment("business_unit_ggw_crew"), Optional.empty());
    }

    public Ggw_team_applicationRequest business_unit_ggw_team_application(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("business_unit_ggw_team_application").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest business_unit_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(contextPath.addSegment("business_unit_ggw_team_application"), Optional.empty());
    }

}
