package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "modifiedon", 
    "statuscode", 
    "_owningteam_value", 
    "returnedtypecode", 
    "querytype", 
    "advancedgroupby", 
    "_parentqueryid_value", 
    "columnsetxml", 
    "fetchxml", 
    "_owninguser_value", 
    "description", 
    "conditionalformatting", 
    "statecode", 
    "name", 
    "_modifiedonbehalfby_value", 
    "layoutjson", 
    "_owningbusinessunit_value", 
    "_createdby_value", 
    "createdon", 
    "_createdonbehalfby_value", 
    "userqueryid", 
    "layoutxml", 
    "versionnumber", 
    "_modifiedby_value", 
    "_ownerid_value", 
    "offlinesqlquery"})
@JsonInclude(Include.NON_NULL)
public class Userquery extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.userquery";
    }

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("returnedtypecode")
    protected String returnedtypecode;

    @JsonProperty("querytype")
    protected Integer querytype;

    @JsonProperty("advancedgroupby")
    protected String advancedgroupby;

    @JsonProperty("_parentqueryid_value")
    protected UUID _parentqueryid_value;

    @JsonProperty("columnsetxml")
    protected String columnsetxml;

    @JsonProperty("fetchxml")
    protected String fetchxml;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("conditionalformatting")
    protected String conditionalformatting;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("layoutjson")
    protected String layoutjson;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("userqueryid")
    protected UUID userqueryid;

    @JsonProperty("layoutxml")
    protected String layoutxml;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("offlinesqlquery")
    protected String offlinesqlquery;

    protected Userquery() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderUserquery() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime modifiedon;
        private Integer statuscode;
        private UUID _owningteam_value;
        private String returnedtypecode;
        private Integer querytype;
        private String advancedgroupby;
        private UUID _parentqueryid_value;
        private String columnsetxml;
        private String fetchxml;
        private UUID _owninguser_value;
        private String description;
        private String conditionalformatting;
        private Integer statecode;
        private String name;
        private UUID _modifiedonbehalfby_value;
        private String layoutjson;
        private UUID _owningbusinessunit_value;
        private UUID _createdby_value;
        private OffsetDateTime createdon;
        private UUID _createdonbehalfby_value;
        private UUID userqueryid;
        private String layoutxml;
        private Long versionnumber;
        private UUID _modifiedby_value;
        private UUID _ownerid_value;
        private String offlinesqlquery;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder returnedtypecode(String returnedtypecode) {
            this.returnedtypecode = returnedtypecode;
            this.changedFields = changedFields.add("returnedtypecode");
            return this;
        }

        public Builder querytype(Integer querytype) {
            this.querytype = querytype;
            this.changedFields = changedFields.add("querytype");
            return this;
        }

        public Builder advancedgroupby(String advancedgroupby) {
            this.advancedgroupby = advancedgroupby;
            this.changedFields = changedFields.add("advancedgroupby");
            return this;
        }

        public Builder _parentqueryid_value(UUID _parentqueryid_value) {
            this._parentqueryid_value = _parentqueryid_value;
            this.changedFields = changedFields.add("_parentqueryid_value");
            return this;
        }

        public Builder columnsetxml(String columnsetxml) {
            this.columnsetxml = columnsetxml;
            this.changedFields = changedFields.add("columnsetxml");
            return this;
        }

        public Builder fetchxml(String fetchxml) {
            this.fetchxml = fetchxml;
            this.changedFields = changedFields.add("fetchxml");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder conditionalformatting(String conditionalformatting) {
            this.conditionalformatting = conditionalformatting;
            this.changedFields = changedFields.add("conditionalformatting");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder layoutjson(String layoutjson) {
            this.layoutjson = layoutjson;
            this.changedFields = changedFields.add("layoutjson");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder userqueryid(UUID userqueryid) {
            this.userqueryid = userqueryid;
            this.changedFields = changedFields.add("userqueryid");
            return this;
        }

        public Builder layoutxml(String layoutxml) {
            this.layoutxml = layoutxml;
            this.changedFields = changedFields.add("layoutxml");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder offlinesqlquery(String offlinesqlquery) {
            this.offlinesqlquery = offlinesqlquery;
            this.changedFields = changedFields.add("offlinesqlquery");
            return this;
        }

        public Userquery build() {
            Userquery _x = new Userquery();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.userquery";
            _x.modifiedon = modifiedon;
            _x.statuscode = statuscode;
            _x._owningteam_value = _owningteam_value;
            _x.returnedtypecode = returnedtypecode;
            _x.querytype = querytype;
            _x.advancedgroupby = advancedgroupby;
            _x._parentqueryid_value = _parentqueryid_value;
            _x.columnsetxml = columnsetxml;
            _x.fetchxml = fetchxml;
            _x._owninguser_value = _owninguser_value;
            _x.description = description;
            _x.conditionalformatting = conditionalformatting;
            _x.statecode = statecode;
            _x.name = name;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.layoutjson = layoutjson;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdby_value = _createdby_value;
            _x.createdon = createdon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.userqueryid = userqueryid;
            _x.layoutxml = layoutxml;
            _x.versionnumber = versionnumber;
            _x._modifiedby_value = _modifiedby_value;
            _x._ownerid_value = _ownerid_value;
            _x.offlinesqlquery = offlinesqlquery;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && userqueryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(userqueryid, UUID.class));
        }
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Userquery withModifiedon(OffsetDateTime modifiedon) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Userquery withStatuscode(Integer statuscode) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Userquery with_owningteam_value(UUID _owningteam_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="returnedtypecode")
    @JsonIgnore
    public Optional<String> getReturnedtypecode() {
        return Optional.ofNullable(returnedtypecode);
    }

    public Userquery withReturnedtypecode(String returnedtypecode) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("returnedtypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.returnedtypecode = returnedtypecode;
        return _x;
    }

    @Property(name="querytype")
    @JsonIgnore
    public Optional<Integer> getQuerytype() {
        return Optional.ofNullable(querytype);
    }

    public Userquery withQuerytype(Integer querytype) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("querytype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.querytype = querytype;
        return _x;
    }

    @Property(name="advancedgroupby")
    @JsonIgnore
    public Optional<String> getAdvancedgroupby() {
        return Optional.ofNullable(advancedgroupby);
    }

    public Userquery withAdvancedgroupby(String advancedgroupby) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("advancedgroupby");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.advancedgroupby = advancedgroupby;
        return _x;
    }

    @Property(name="_parentqueryid_value")
    @JsonIgnore
    public Optional<UUID> get_parentqueryid_value() {
        return Optional.ofNullable(_parentqueryid_value);
    }

    public Userquery with_parentqueryid_value(UUID _parentqueryid_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_parentqueryid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._parentqueryid_value = _parentqueryid_value;
        return _x;
    }

    @Property(name="columnsetxml")
    @JsonIgnore
    public Optional<String> getColumnsetxml() {
        return Optional.ofNullable(columnsetxml);
    }

    public Userquery withColumnsetxml(String columnsetxml) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("columnsetxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.columnsetxml = columnsetxml;
        return _x;
    }

    @Property(name="fetchxml")
    @JsonIgnore
    public Optional<String> getFetchxml() {
        return Optional.ofNullable(fetchxml);
    }

    public Userquery withFetchxml(String fetchxml) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("fetchxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.fetchxml = fetchxml;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Userquery with_owninguser_value(UUID _owninguser_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Userquery withDescription(String description) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.description = description;
        return _x;
    }

    @Property(name="conditionalformatting")
    @JsonIgnore
    public Optional<String> getConditionalformatting() {
        return Optional.ofNullable(conditionalformatting);
    }

    public Userquery withConditionalformatting(String conditionalformatting) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("conditionalformatting");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.conditionalformatting = conditionalformatting;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Userquery withStatecode(Integer statecode) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Userquery withName(String name) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.name = name;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Userquery with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="layoutjson")
    @JsonIgnore
    public Optional<String> getLayoutjson() {
        return Optional.ofNullable(layoutjson);
    }

    public Userquery withLayoutjson(String layoutjson) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("layoutjson");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.layoutjson = layoutjson;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Userquery with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Userquery with_createdby_value(UUID _createdby_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Userquery withCreatedon(OffsetDateTime createdon) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Userquery with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="userqueryid")
    @JsonIgnore
    public Optional<UUID> getUserqueryid() {
        return Optional.ofNullable(userqueryid);
    }

    public Userquery withUserqueryid(UUID userqueryid) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("userqueryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.userqueryid = userqueryid;
        return _x;
    }

    @Property(name="layoutxml")
    @JsonIgnore
    public Optional<String> getLayoutxml() {
        return Optional.ofNullable(layoutxml);
    }

    public Userquery withLayoutxml(String layoutxml) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("layoutxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.layoutxml = layoutxml;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Userquery withVersionnumber(Long versionnumber) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Userquery with_modifiedby_value(UUID _modifiedby_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Userquery with_ownerid_value(UUID _ownerid_value) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="offlinesqlquery")
    @JsonIgnore
    public Optional<String> getOfflinesqlquery() {
        return Optional.ofNullable(offlinesqlquery);
    }

    public Userquery withOfflinesqlquery(String offlinesqlquery) {
        Userquery _x = _copy();
        _x.changedFields = changedFields.add("offlinesqlquery");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.userquery");
        _x.offlinesqlquery = offlinesqlquery;
        return _x;
    }

    public Userquery withUnmappedField(String name, Object value) {
        Userquery _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="UserQuery_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getUserQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("UserQuery_SyncErrors"), RequestHelper.getValue(unmappedFields, "UserQuery_SyncErrors"));
    }

    @NavigationProperty(name="UserQuery_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getUserQuery_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("UserQuery_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "UserQuery_BulkDeleteFailures"));
    }

    @NavigationProperty(name="UserQuery_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getUserQuery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("UserQuery_AsyncOperations"), RequestHelper.getValue(unmappedFields, "UserQuery_AsyncOperations"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Userquery patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Userquery _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Userquery put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Userquery _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Userquery _copy() {
        Userquery _x = new Userquery();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.modifiedon = modifiedon;
        _x.statuscode = statuscode;
        _x._owningteam_value = _owningteam_value;
        _x.returnedtypecode = returnedtypecode;
        _x.querytype = querytype;
        _x.advancedgroupby = advancedgroupby;
        _x._parentqueryid_value = _parentqueryid_value;
        _x.columnsetxml = columnsetxml;
        _x.fetchxml = fetchxml;
        _x._owninguser_value = _owninguser_value;
        _x.description = description;
        _x.conditionalformatting = conditionalformatting;
        _x.statecode = statecode;
        _x.name = name;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.layoutjson = layoutjson;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdby_value = _createdby_value;
        _x.createdon = createdon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.userqueryid = userqueryid;
        _x.layoutxml = layoutxml;
        _x.versionnumber = versionnumber;
        _x._modifiedby_value = _modifiedby_value;
        _x._ownerid_value = _ownerid_value;
        _x.offlinesqlquery = offlinesqlquery;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Userquery[");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("returnedtypecode=");
        b.append(this.returnedtypecode);
        b.append(", ");
        b.append("querytype=");
        b.append(this.querytype);
        b.append(", ");
        b.append("advancedgroupby=");
        b.append(this.advancedgroupby);
        b.append(", ");
        b.append("_parentqueryid_value=");
        b.append(this._parentqueryid_value);
        b.append(", ");
        b.append("columnsetxml=");
        b.append(this.columnsetxml);
        b.append(", ");
        b.append("fetchxml=");
        b.append(this.fetchxml);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("conditionalformatting=");
        b.append(this.conditionalformatting);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("layoutjson=");
        b.append(this.layoutjson);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("userqueryid=");
        b.append(this.userqueryid);
        b.append(", ");
        b.append("layoutxml=");
        b.append(this.layoutxml);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("offlinesqlquery=");
        b.append(this.offlinesqlquery);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
