package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "systemuserid", 
    "versionnumber", 
    "teammembershipid", 
    "teamid"})
@JsonInclude(Include.NON_NULL)
public class Teammembership extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.teammembership";
    }

    @JsonProperty("systemuserid")
    protected UUID systemuserid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("teammembershipid")
    protected UUID teammembershipid;

    @JsonProperty("teamid")
    protected UUID teamid;

    protected Teammembership() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeammembership() {
        return new Builder();
    }

    public static final class Builder {
        private UUID systemuserid;
        private Long versionnumber;
        private UUID teammembershipid;
        private UUID teamid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder systemuserid(UUID systemuserid) {
            this.systemuserid = systemuserid;
            this.changedFields = changedFields.add("systemuserid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder teammembershipid(UUID teammembershipid) {
            this.teammembershipid = teammembershipid;
            this.changedFields = changedFields.add("teammembershipid");
            return this;
        }

        public Builder teamid(UUID teamid) {
            this.teamid = teamid;
            this.changedFields = changedFields.add("teamid");
            return this;
        }

        public Teammembership build() {
            Teammembership _x = new Teammembership();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.teammembership";
            _x.systemuserid = systemuserid;
            _x.versionnumber = versionnumber;
            _x.teammembershipid = teammembershipid;
            _x.teamid = teamid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && teammembershipid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(teammembershipid, UUID.class));
        }
    }

    @Property(name="systemuserid")
    @JsonIgnore
    public Optional<UUID> getSystemuserid() {
        return Optional.ofNullable(systemuserid);
    }

    public Teammembership withSystemuserid(UUID systemuserid) {
        Teammembership _x = _copy();
        _x.changedFields = changedFields.add("systemuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teammembership");
        _x.systemuserid = systemuserid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Teammembership withVersionnumber(Long versionnumber) {
        Teammembership _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teammembership");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="teammembershipid")
    @JsonIgnore
    public Optional<UUID> getTeammembershipid() {
        return Optional.ofNullable(teammembershipid);
    }

    public Teammembership withTeammembershipid(UUID teammembershipid) {
        Teammembership _x = _copy();
        _x.changedFields = changedFields.add("teammembershipid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teammembership");
        _x.teammembershipid = teammembershipid;
        return _x;
    }

    @Property(name="teamid")
    @JsonIgnore
    public Optional<UUID> getTeamid() {
        return Optional.ofNullable(teamid);
    }

    public Teammembership withTeamid(UUID teamid) {
        Teammembership _x = _copy();
        _x.changedFields = changedFields.add("teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.teammembership");
        _x.teamid = teamid;
        return _x;
    }

    public Teammembership withUnmappedField(String name, Object value) {
        Teammembership _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teammembership patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Teammembership _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Teammembership put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Teammembership _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Teammembership _copy() {
        Teammembership _x = new Teammembership();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.systemuserid = systemuserid;
        _x.versionnumber = versionnumber;
        _x.teammembershipid = teammembershipid;
        _x.teamid = teamid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Teammembership[");
        b.append("systemuserid=");
        b.append(this.systemuserid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("teammembershipid=");
        b.append(this.teammembershipid);
        b.append(", ");
        b.append("teamid=");
        b.append(this.teamid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
