package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.RetrievePrincipalAccessInfoResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAccessResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAttributePrivilegesResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalSyncAttributeMappingsResponse;
import microsoft.dynamics.crm.complex.RetrieveTeamPrivilegesResponse;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionreferenceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailserverprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariabledefinitionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariablevalueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExchangesyncidmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExportsolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FlowsessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_crewCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_eventCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_teamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_team_applicationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalrollupqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportdataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportmapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.InteractionforemailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetrecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetscontainerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileattacheddataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aifptrainingdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aimodelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodlabelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingboundingboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aitemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultdetailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_dataflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticleimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_richtextfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_serviceconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_slakpiCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleargumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcessstageparameterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.StagesolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserformCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowbinaryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamtemplateRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_transactioncurrencyid_value", 
    "versionnumber", 
    "yominame", 
    "_teamtemplateid_value", 
    "_modifiedonbehalfby_value", 
    "traversedpath", 
    "organizationid", 
    "name", 
    "_regardingobjectid_value", 
    "isdefault", 
    "exchangerate", 
    "importsequencenumber", 
    "systemmanaged", 
    "description", 
    "_createdby_value", 
    "emailaddress", 
    "processid", 
    "_businessunitid_value", 
    "_queueid_value", 
    "modifiedon", 
    "overriddencreatedon", 
    "teamtype", 
    "stageid", 
    "membershiptype", 
    "createdon", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "azureactivedirectoryobjectid", 
    "_administratorid_value", 
    "teamid"})
@JsonInclude(Include.NON_NULL)
public class Team extends Principal implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.team";
    }

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("yominame")
    protected String yominame;

    @JsonProperty("_teamtemplateid_value")
    protected UUID _teamtemplateid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("traversedpath")
    protected String traversedpath;

    @JsonProperty("organizationid")
    protected UUID organizationid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("systemmanaged")
    protected Boolean systemmanaged;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("emailaddress")
    protected String emailaddress;

    @JsonProperty("processid")
    protected UUID processid;

    @JsonProperty("_businessunitid_value")
    protected UUID _businessunitid_value;

    @JsonProperty("_queueid_value")
    protected UUID _queueid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("teamtype")
    protected Integer teamtype;

    @JsonProperty("stageid")
    protected UUID stageid;

    @JsonProperty("membershiptype")
    protected Integer membershiptype;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("azureactivedirectoryobjectid")
    protected UUID azureactivedirectoryobjectid;

    @JsonProperty("_administratorid_value")
    protected UUID _administratorid_value;

    @JsonProperty("teamid")
    protected UUID teamid;

    protected Team() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderTeam() {
        return new Builder();
    }

    public static final class Builder {
        private UUID ownerid;
        private UUID _transactioncurrencyid_value;
        private Long versionnumber;
        private String yominame;
        private UUID _teamtemplateid_value;
        private UUID _modifiedonbehalfby_value;
        private String traversedpath;
        private UUID organizationid;
        private String name;
        private UUID _regardingobjectid_value;
        private Boolean isdefault;
        private BigDecimal exchangerate;
        private Integer importsequencenumber;
        private Boolean systemmanaged;
        private String description;
        private UUID _createdby_value;
        private String emailaddress;
        private UUID processid;
        private UUID _businessunitid_value;
        private UUID _queueid_value;
        private OffsetDateTime modifiedon;
        private OffsetDateTime overriddencreatedon;
        private Integer teamtype;
        private UUID stageid;
        private Integer membershiptype;
        private OffsetDateTime createdon;
        private UUID _modifiedby_value;
        private UUID _createdonbehalfby_value;
        private UUID azureactivedirectoryobjectid;
        private UUID _administratorid_value;
        private UUID teamid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder ownerid(UUID ownerid) {
            this.ownerid = ownerid;
            this.changedFields = changedFields.add("ownerid");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder yominame(String yominame) {
            this.yominame = yominame;
            this.changedFields = changedFields.add("yominame");
            return this;
        }

        public Builder _teamtemplateid_value(UUID _teamtemplateid_value) {
            this._teamtemplateid_value = _teamtemplateid_value;
            this.changedFields = changedFields.add("_teamtemplateid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder organizationid(UUID organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder systemmanaged(Boolean systemmanaged) {
            this.systemmanaged = systemmanaged;
            this.changedFields = changedFields.add("systemmanaged");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder emailaddress(String emailaddress) {
            this.emailaddress = emailaddress;
            this.changedFields = changedFields.add("emailaddress");
            return this;
        }

        public Builder processid(UUID processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder _businessunitid_value(UUID _businessunitid_value) {
            this._businessunitid_value = _businessunitid_value;
            this.changedFields = changedFields.add("_businessunitid_value");
            return this;
        }

        public Builder _queueid_value(UUID _queueid_value) {
            this._queueid_value = _queueid_value;
            this.changedFields = changedFields.add("_queueid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder teamtype(Integer teamtype) {
            this.teamtype = teamtype;
            this.changedFields = changedFields.add("teamtype");
            return this;
        }

        public Builder stageid(UUID stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder membershiptype(Integer membershiptype) {
            this.membershiptype = membershiptype;
            this.changedFields = changedFields.add("membershiptype");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder azureactivedirectoryobjectid(UUID azureactivedirectoryobjectid) {
            this.azureactivedirectoryobjectid = azureactivedirectoryobjectid;
            this.changedFields = changedFields.add("azureactivedirectoryobjectid");
            return this;
        }

        public Builder _administratorid_value(UUID _administratorid_value) {
            this._administratorid_value = _administratorid_value;
            this.changedFields = changedFields.add("_administratorid_value");
            return this;
        }

        public Builder teamid(UUID teamid) {
            this.teamid = teamid;
            this.changedFields = changedFields.add("teamid");
            return this;
        }

        public Team build() {
            Team _x = new Team();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.team";
            _x.ownerid = ownerid;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.versionnumber = versionnumber;
            _x.yominame = yominame;
            _x._teamtemplateid_value = _teamtemplateid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.traversedpath = traversedpath;
            _x.organizationid = organizationid;
            _x.name = name;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.isdefault = isdefault;
            _x.exchangerate = exchangerate;
            _x.importsequencenumber = importsequencenumber;
            _x.systemmanaged = systemmanaged;
            _x.description = description;
            _x._createdby_value = _createdby_value;
            _x.emailaddress = emailaddress;
            _x.processid = processid;
            _x._businessunitid_value = _businessunitid_value;
            _x._queueid_value = _queueid_value;
            _x.modifiedon = modifiedon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.teamtype = teamtype;
            _x.stageid = stageid;
            _x.membershiptype = membershiptype;
            _x.createdon = createdon;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.azureactivedirectoryobjectid = azureactivedirectoryobjectid;
            _x._administratorid_value = _administratorid_value;
            _x.teamid = teamid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ownerid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ownerid, UUID.class));
        }
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Team with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Team withVersionnumber(Long versionnumber) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="yominame")
    @JsonIgnore
    public Optional<String> getYominame() {
        return Optional.ofNullable(yominame);
    }

    public Team withYominame(String yominame) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("yominame");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.yominame = yominame;
        return _x;
    }

    @Property(name="_teamtemplateid_value")
    @JsonIgnore
    public Optional<UUID> get_teamtemplateid_value() {
        return Optional.ofNullable(_teamtemplateid_value);
    }

    public Team with_teamtemplateid_value(UUID _teamtemplateid_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_teamtemplateid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._teamtemplateid_value = _teamtemplateid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Team with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="traversedpath")
    @JsonIgnore
    public Optional<String> getTraversedpath() {
        return Optional.ofNullable(traversedpath);
    }

    public Team withTraversedpath(String traversedpath) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("traversedpath");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.traversedpath = traversedpath;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<UUID> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Team withOrganizationid(UUID organizationid) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Team withName(String name) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.name = name;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Team with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Team withIsdefault(Boolean isdefault) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Team withExchangerate(BigDecimal exchangerate) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Team withImportsequencenumber(Integer importsequencenumber) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="systemmanaged")
    @JsonIgnore
    public Optional<Boolean> getSystemmanaged() {
        return Optional.ofNullable(systemmanaged);
    }

    public Team withSystemmanaged(Boolean systemmanaged) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("systemmanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.systemmanaged = systemmanaged;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Team withDescription(String description) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.description = description;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Team with_createdby_value(UUID _createdby_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="emailaddress")
    @JsonIgnore
    public Optional<String> getEmailaddress() {
        return Optional.ofNullable(emailaddress);
    }

    public Team withEmailaddress(String emailaddress) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("emailaddress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.emailaddress = emailaddress;
        return _x;
    }

    @Property(name="processid")
    @JsonIgnore
    public Optional<UUID> getProcessid() {
        return Optional.ofNullable(processid);
    }

    public Team withProcessid(UUID processid) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("processid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.processid = processid;
        return _x;
    }

    @Property(name="_businessunitid_value")
    @JsonIgnore
    public Optional<UUID> get_businessunitid_value() {
        return Optional.ofNullable(_businessunitid_value);
    }

    public Team with_businessunitid_value(UUID _businessunitid_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_businessunitid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._businessunitid_value = _businessunitid_value;
        return _x;
    }

    @Property(name="_queueid_value")
    @JsonIgnore
    public Optional<UUID> get_queueid_value() {
        return Optional.ofNullable(_queueid_value);
    }

    public Team with_queueid_value(UUID _queueid_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_queueid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._queueid_value = _queueid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Team withModifiedon(OffsetDateTime modifiedon) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Team withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="teamtype")
    @JsonIgnore
    public Optional<Integer> getTeamtype() {
        return Optional.ofNullable(teamtype);
    }

    public Team withTeamtype(Integer teamtype) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("teamtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.teamtype = teamtype;
        return _x;
    }

    @Property(name="stageid")
    @JsonIgnore
    public Optional<UUID> getStageid() {
        return Optional.ofNullable(stageid);
    }

    public Team withStageid(UUID stageid) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("stageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.stageid = stageid;
        return _x;
    }

    @Property(name="membershiptype")
    @JsonIgnore
    public Optional<Integer> getMembershiptype() {
        return Optional.ofNullable(membershiptype);
    }

    public Team withMembershiptype(Integer membershiptype) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("membershiptype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.membershiptype = membershiptype;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Team withCreatedon(OffsetDateTime createdon) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Team with_modifiedby_value(UUID _modifiedby_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Team with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="azureactivedirectoryobjectid")
    @JsonIgnore
    public Optional<UUID> getAzureactivedirectoryobjectid() {
        return Optional.ofNullable(azureactivedirectoryobjectid);
    }

    public Team withAzureactivedirectoryobjectid(UUID azureactivedirectoryobjectid) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("azureactivedirectoryobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.azureactivedirectoryobjectid = azureactivedirectoryobjectid;
        return _x;
    }

    @Property(name="_administratorid_value")
    @JsonIgnore
    public Optional<UUID> get_administratorid_value() {
        return Optional.ofNullable(_administratorid_value);
    }

    public Team with_administratorid_value(UUID _administratorid_value) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("_administratorid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x._administratorid_value = _administratorid_value;
        return _x;
    }

    @Property(name="teamid")
    @JsonIgnore
    public Optional<UUID> getTeamid() {
        return Optional.ofNullable(teamid);
    }

    public Team withTeamid(UUID teamid) {
        Team _x = _copy();
        _x.changedFields = changedFields.add("teamid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.team");
        _x.teamid = teamid;
        return _x;
    }

    public Team withUnmappedField(String name, Object value) {
        Team _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="teammembership_association")
    @JsonIgnore
    public SystemuserCollectionRequest getTeammembership_association() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("teammembership_association"), RequestHelper.getValue(unmappedFields, "teammembership_association"));
    }

    @NavigationProperty(name="team_principalobjectattributeaccess_principalid")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getTeam_principalobjectattributeaccess_principalid() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("team_principalobjectattributeaccess_principalid"), RequestHelper.getValue(unmappedFields, "team_principalobjectattributeaccess_principalid"));
    }

    @NavigationProperty(name="team_exchangesyncidmapping")
    @JsonIgnore
    public ExchangesyncidmappingCollectionRequest getTeam_exchangesyncidmapping() {
        return new ExchangesyncidmappingCollectionRequest(
                        contextPath.addSegment("team_exchangesyncidmapping"), RequestHelper.getValue(unmappedFields, "team_exchangesyncidmapping"));
    }

    @NavigationProperty(name="team_new_interactionforemail")
    @JsonIgnore
    public InteractionforemailCollectionRequest getTeam_new_interactionforemail() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("team_new_interactionforemail"), RequestHelper.getValue(unmappedFields, "team_new_interactionforemail"));
    }

    @NavigationProperty(name="team_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleCollectionRequest getTeam_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("team_knowledgearticle"), RequestHelper.getValue(unmappedFields, "team_knowledgearticle"));
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle"));
    }

    @NavigationProperty(name="team_sharepointsite")
    @JsonIgnore
    public SharepointsiteCollectionRequest getTeam_sharepointsite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("team_sharepointsite"), RequestHelper.getValue(unmappedFields, "team_sharepointsite"));
    }

    @NavigationProperty(name="team_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationCollectionRequest getTeam_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("team_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "team_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="team_goal")
    @JsonIgnore
    public GoalCollectionRequest getTeam_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("team_goal"), RequestHelper.getValue(unmappedFields, "team_goal"));
    }

    @NavigationProperty(name="team_goalrollupquery")
    @JsonIgnore
    public GoalrollupqueryCollectionRequest getTeam_goalrollupquery() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("team_goalrollupquery"), RequestHelper.getValue(unmappedFields, "team_goalrollupquery"));
    }

    @NavigationProperty(name="team_mailbox")
    @JsonIgnore
    public MailboxCollectionRequest getTeam_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("team_mailbox"), RequestHelper.getValue(unmappedFields, "team_mailbox"));
    }

    @NavigationProperty(name="associatedteamtemplateid")
    @JsonIgnore
    public TeamtemplateRequest getAssociatedteamtemplateid() {
        return new TeamtemplateRequest(contextPath.addSegment("associatedteamtemplateid"), RequestHelper.getValue(unmappedFields, "associatedteamtemplateid"));
    }

    @NavigationProperty(name="team_DuplicateRules")
    @JsonIgnore
    public DuplicateruleCollectionRequest getTeam_DuplicateRules() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("team_DuplicateRules"), RequestHelper.getValue(unmappedFields, "team_DuplicateRules"));
    }

    @NavigationProperty(name="team_Imports")
    @JsonIgnore
    public ImportCollectionRequest getTeam_Imports() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("team_Imports"), RequestHelper.getValue(unmappedFields, "team_Imports"));
    }

    @NavigationProperty(name="OwningTeam_postfollows")
    @JsonIgnore
    public PostfollowCollectionRequest getOwningTeam_postfollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("OwningTeam_postfollows"), RequestHelper.getValue(unmappedFields, "OwningTeam_postfollows"));
    }

    @NavigationProperty(name="team_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterCollectionRequest getTeam_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("team_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "team_recurringappointmentmaster"));
    }

    @NavigationProperty(name="team_workflowlog")
    @JsonIgnore
    public WorkflowlogCollectionRequest getTeam_workflowlog() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("team_workflowlog"), RequestHelper.getValue(unmappedFields, "team_workflowlog"));
    }

    @NavigationProperty(name="team_connections2")
    @JsonIgnore
    public ConnectionCollectionRequest getTeam_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("team_connections2"), RequestHelper.getValue(unmappedFields, "team_connections2"));
    }

    @NavigationProperty(name="team_processsession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getTeam_processsession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("team_processsession"), RequestHelper.getValue(unmappedFields, "team_processsession"));
    }

    @NavigationProperty(name="stageid_processstage")
    @JsonIgnore
    public ProcessstageRequest getStageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), RequestHelper.getValue(unmappedFields, "stageid_processstage"));
    }

    @NavigationProperty(name="team_userform")
    @JsonIgnore
    public UserformCollectionRequest getTeam_userform() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("team_userform"), RequestHelper.getValue(unmappedFields, "team_userform"));
    }

    @NavigationProperty(name="Team_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getTeam_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Team_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Team_AsyncOperations"));
    }

    @NavigationProperty(name="team_SyncError")
    @JsonIgnore
    public SyncerrorCollectionRequest getTeam_SyncError() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("team_SyncError"), RequestHelper.getValue(unmappedFields, "team_SyncError"));
    }

    @NavigationProperty(name="queueid")
    @JsonIgnore
    public QueueRequest getQueueid() {
        return new QueueRequest(contextPath.addSegment("queueid"), RequestHelper.getValue(unmappedFields, "queueid"));
    }

    @NavigationProperty(name="Team_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getTeam_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Team_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "Team_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="team_task")
    @JsonIgnore
    public TaskCollectionRequest getTeam_task() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("team_task"), RequestHelper.getValue(unmappedFields, "team_task"));
    }

    @NavigationProperty(name="team_userquery")
    @JsonIgnore
    public UserqueryCollectionRequest getTeam_userquery() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("team_userquery"), RequestHelper.getValue(unmappedFields, "team_userquery"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="team_socialactivity")
    @JsonIgnore
    public SocialactivityCollectionRequest getTeam_socialactivity() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("team_socialactivity"), RequestHelper.getValue(unmappedFields, "team_socialactivity"));
    }

    @NavigationProperty(name="team_userqueryvisualizations")
    @JsonIgnore
    public UserqueryvisualizationCollectionRequest getTeam_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("team_userqueryvisualizations"), RequestHelper.getValue(unmappedFields, "team_userqueryvisualizations"));
    }

    @NavigationProperty(name="Team_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getTeam_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Team_SyncErrors"), RequestHelper.getValue(unmappedFields, "Team_SyncErrors"));
    }

    @NavigationProperty(name="team_ImportMaps")
    @JsonIgnore
    public ImportmapCollectionRequest getTeam_ImportMaps() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("team_ImportMaps"), RequestHelper.getValue(unmappedFields, "team_ImportMaps"));
    }

    @NavigationProperty(name="team_fax")
    @JsonIgnore
    public FaxCollectionRequest getTeam_fax() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("team_fax"), RequestHelper.getValue(unmappedFields, "team_fax"));
    }

    @NavigationProperty(name="team_queueitembase_workerid")
    @JsonIgnore
    public QueueitemCollectionRequest getTeam_queueitembase_workerid() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("team_queueitembase_workerid"), RequestHelper.getValue(unmappedFields, "team_queueitembase_workerid"));
    }

    @NavigationProperty(name="team_PostRegardings")
    @JsonIgnore
    public PostregardingCollectionRequest getTeam_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("team_PostRegardings"), RequestHelper.getValue(unmappedFields, "team_PostRegardings"));
    }

    @NavigationProperty(name="businessunitid")
    @JsonIgnore
    public BusinessunitRequest getBusinessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), RequestHelper.getValue(unmappedFields, "businessunitid"));
    }

    @NavigationProperty(name="ImportFile_Team")
    @JsonIgnore
    public ImportfileCollectionRequest getImportFile_Team() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("ImportFile_Team"), RequestHelper.getValue(unmappedFields, "ImportFile_Team"));
    }

    @NavigationProperty(name="team_connections1")
    @JsonIgnore
    public ConnectionCollectionRequest getTeam_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("team_connections1"), RequestHelper.getValue(unmappedFields, "team_connections1"));
    }

    @NavigationProperty(name="team_email_templates")
    @JsonIgnore
    public TemplateCollectionRequest getTeam_email_templates() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("team_email_templates"), RequestHelper.getValue(unmappedFields, "team_email_templates"));
    }

    @NavigationProperty(name="team_workflow")
    @JsonIgnore
    public WorkflowCollectionRequest getTeam_workflow() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("team_workflow"), RequestHelper.getValue(unmappedFields, "team_workflow"));
    }

    @NavigationProperty(name="Team_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getTeam_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Team_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "Team_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="organizationid_organization")
    @JsonIgnore
    public OrganizationRequest getOrganizationid_organization() {
        return new OrganizationRequest(contextPath.addSegment("organizationid_organization"), RequestHelper.getValue(unmappedFields, "organizationid_organization"));
    }

    @NavigationProperty(name="team_email")
    @JsonIgnore
    public EmailCollectionRequest getTeam_email() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("team_email"), RequestHelper.getValue(unmappedFields, "team_email"));
    }

    @NavigationProperty(name="team_letter")
    @JsonIgnore
    public LetterCollectionRequest getTeam_letter() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("team_letter"), RequestHelper.getValue(unmappedFields, "team_letter"));
    }

    @NavigationProperty(name="team_ImportFiles")
    @JsonIgnore
    public ImportfileCollectionRequest getTeam_ImportFiles() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("team_ImportFiles"), RequestHelper.getValue(unmappedFields, "team_ImportFiles"));
    }

    @NavigationProperty(name="team_ImportData")
    @JsonIgnore
    public ImportdataCollectionRequest getTeam_ImportData() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("team_ImportData"), RequestHelper.getValue(unmappedFields, "team_ImportData"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="team_asyncoperation")
    @JsonIgnore
    public AsyncoperationCollectionRequest getTeam_asyncoperation() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("team_asyncoperation"), RequestHelper.getValue(unmappedFields, "team_asyncoperation"));
    }

    @NavigationProperty(name="team_contacts")
    @JsonIgnore
    public ContactCollectionRequest getTeam_contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("team_contacts"), RequestHelper.getValue(unmappedFields, "team_contacts"));
    }

    @NavigationProperty(name="team_mailboxtrackingfolder")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getTeam_mailboxtrackingfolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("team_mailboxtrackingfolder"), RequestHelper.getValue(unmappedFields, "team_mailboxtrackingfolder"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="team_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileCollectionRequest getTeam_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("team_emailserverprofile"), RequestHelper.getValue(unmappedFields, "team_emailserverprofile"));
    }

    @NavigationProperty(name="Team_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getTeam_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Team_ProcessSessions"), RequestHelper.getValue(unmappedFields, "Team_ProcessSessions"));
    }

    @NavigationProperty(name="team_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getTeam_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("team_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "team_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="team_annotations")
    @JsonIgnore
    public AnnotationCollectionRequest getTeam_annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("team_annotations"), RequestHelper.getValue(unmappedFields, "team_annotations"));
    }

    @NavigationProperty(name="team_ImportLogs")
    @JsonIgnore
    public ImportlogCollectionRequest getTeam_ImportLogs() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("team_ImportLogs"), RequestHelper.getValue(unmappedFields, "team_ImportLogs"));
    }

    @NavigationProperty(name="team_slaBase")
    @JsonIgnore
    public SlaCollectionRequest getTeam_slaBase() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("team_slaBase"), RequestHelper.getValue(unmappedFields, "team_slaBase"));
    }

    @NavigationProperty(name="teamprofiles_association")
    @JsonIgnore
    public FieldsecurityprofileCollectionRequest getTeamprofiles_association() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("teamprofiles_association"), RequestHelper.getValue(unmappedFields, "teamprofiles_association"));
    }

    @NavigationProperty(name="team_phonecall")
    @JsonIgnore
    public PhonecallCollectionRequest getTeam_phonecall() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("team_phonecall"), RequestHelper.getValue(unmappedFields, "team_phonecall"));
    }

    @NavigationProperty(name="teamroles_association")
    @JsonIgnore
    public RoleCollectionRequest getTeamroles_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("teamroles_association"), RequestHelper.getValue(unmappedFields, "teamroles_association"));
    }

    @NavigationProperty(name="team_accounts")
    @JsonIgnore
    public AccountCollectionRequest getTeam_accounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("team_accounts"), RequestHelper.getValue(unmappedFields, "team_accounts"));
    }

    @NavigationProperty(name="team_activity")
    @JsonIgnore
    public ActivitypointerCollectionRequest getTeam_activity() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("team_activity"), RequestHelper.getValue(unmappedFields, "team_activity"));
    }

    @NavigationProperty(name="team_appointment")
    @JsonIgnore
    public AppointmentCollectionRequest getTeam_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("team_appointment"), RequestHelper.getValue(unmappedFields, "team_appointment"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="administratorid")
    @JsonIgnore
    public SystemuserRequest getAdministratorid() {
        return new SystemuserRequest(contextPath.addSegment("administratorid"), RequestHelper.getValue(unmappedFields, "administratorid"));
    }

    @NavigationProperty(name="Team_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getTeam_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Team_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Team_BulkDeleteFailures"));
    }

    @NavigationProperty(name="team_goal_goalowner")
    @JsonIgnore
    public GoalCollectionRequest getTeam_goal_goalowner() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("team_goal_goalowner"), RequestHelper.getValue(unmappedFields, "team_goal_goalowner"));
    }

    @NavigationProperty(name="team_stagesolutionupload")
    @JsonIgnore
    public StagesolutionuploadCollectionRequest getTeam_stagesolutionupload() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("team_stagesolutionupload"), RequestHelper.getValue(unmappedFields, "team_stagesolutionupload"));
    }

    @NavigationProperty(name="team_exportsolutionupload")
    @JsonIgnore
    public ExportsolutionuploadCollectionRequest getTeam_exportsolutionupload() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("team_exportsolutionupload"), RequestHelper.getValue(unmappedFields, "team_exportsolutionupload"));
    }

    @NavigationProperty(name="team_connector")
    @JsonIgnore
    public ConnectorCollectionRequest getTeam_connector() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("team_connector"), RequestHelper.getValue(unmappedFields, "team_connector"));
    }

    @NavigationProperty(name="team_environmentvariabledefinition")
    @JsonIgnore
    public EnvironmentvariabledefinitionCollectionRequest getTeam_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("team_environmentvariabledefinition"), RequestHelper.getValue(unmappedFields, "team_environmentvariabledefinition"));
    }

    @NavigationProperty(name="team_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueCollectionRequest getTeam_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("team_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "team_environmentvariablevalue"));
    }

    @NavigationProperty(name="team_processstageparameter")
    @JsonIgnore
    public ProcessstageparameterCollectionRequest getTeam_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("team_processstageparameter"), RequestHelper.getValue(unmappedFields, "team_processstageparameter"));
    }

    @NavigationProperty(name="team_flowsession")
    @JsonIgnore
    public FlowsessionCollectionRequest getTeam_flowsession() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("team_flowsession"), RequestHelper.getValue(unmappedFields, "team_flowsession"));
    }

    @NavigationProperty(name="team_workflowbinary")
    @JsonIgnore
    public WorkflowbinaryCollectionRequest getTeam_workflowbinary() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("team_workflowbinary"), RequestHelper.getValue(unmappedFields, "team_workflowbinary"));
    }

    @NavigationProperty(name="team_connectionreference")
    @JsonIgnore
    public ConnectionreferenceCollectionRequest getTeam_connectionreference() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("team_connectionreference"), RequestHelper.getValue(unmappedFields, "team_connectionreference"));
    }

    @NavigationProperty(name="team_msdyn_serviceconfiguration")
    @JsonIgnore
    public Msdyn_serviceconfigurationCollectionRequest getTeam_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("team_msdyn_serviceconfiguration"), RequestHelper.getValue(unmappedFields, "team_msdyn_serviceconfiguration"));
    }

    @NavigationProperty(name="team_msdyn_slakpi")
    @JsonIgnore
    public Msdyn_slakpiCollectionRequest getTeam_msdyn_slakpi() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("team_msdyn_slakpi"), RequestHelper.getValue(unmappedFields, "team_msdyn_slakpi"));
    }

    @NavigationProperty(name="team_msdyn_knowledgearticleimage")
    @JsonIgnore
    public Msdyn_knowledgearticleimageCollectionRequest getTeam_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("team_msdyn_knowledgearticleimage"), RequestHelper.getValue(unmappedFields, "team_msdyn_knowledgearticleimage"));
    }

    @NavigationProperty(name="team_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateCollectionRequest getTeam_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("team_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "team_msdyn_knowledgearticletemplate"));
    }

    @NavigationProperty(name="team_msdyn_dataflow")
    @JsonIgnore
    public Msdyn_dataflowCollectionRequest getTeam_msdyn_dataflow() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("team_msdyn_dataflow"), RequestHelper.getValue(unmappedFields, "team_msdyn_dataflow"));
    }

    @NavigationProperty(name="team_msdyn_richtextfile")
    @JsonIgnore
    public Msdyn_richtextfileCollectionRequest getTeam_msdyn_richtextfile() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("team_msdyn_richtextfile"), RequestHelper.getValue(unmappedFields, "team_msdyn_richtextfile"));
    }

    @NavigationProperty(name="team_msdyn_aiconfiguration")
    @JsonIgnore
    public Msdyn_aiconfigurationCollectionRequest getTeam_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiconfiguration"), RequestHelper.getValue(unmappedFields, "team_msdyn_aiconfiguration"));
    }

    @NavigationProperty(name="team_msdyn_aimodel")
    @JsonIgnore
    public Msdyn_aimodelCollectionRequest getTeam_msdyn_aimodel() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("team_msdyn_aimodel"), RequestHelper.getValue(unmappedFields, "team_msdyn_aimodel"));
    }

    @NavigationProperty(name="team_msdyn_aitemplate")
    @JsonIgnore
    public Msdyn_aitemplateCollectionRequest getTeam_msdyn_aitemplate() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("team_msdyn_aitemplate"), RequestHelper.getValue(unmappedFields, "team_msdyn_aitemplate"));
    }

    @NavigationProperty(name="team_msdyn_aibdataset")
    @JsonIgnore
    public Msdyn_aibdatasetCollectionRequest getTeam_msdyn_aibdataset() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdataset"), RequestHelper.getValue(unmappedFields, "team_msdyn_aibdataset"));
    }

    @NavigationProperty(name="team_msdyn_aibdatasetfile")
    @JsonIgnore
    public Msdyn_aibdatasetfileCollectionRequest getTeam_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdatasetfile"), RequestHelper.getValue(unmappedFields, "team_msdyn_aibdatasetfile"));
    }

    @NavigationProperty(name="team_msdyn_aibdatasetrecord")
    @JsonIgnore
    public Msdyn_aibdatasetrecordCollectionRequest getTeam_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdatasetrecord"), RequestHelper.getValue(unmappedFields, "team_msdyn_aibdatasetrecord"));
    }

    @NavigationProperty(name="team_msdyn_aibdatasetscontainer")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerCollectionRequest getTeam_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdatasetscontainer"), RequestHelper.getValue(unmappedFields, "team_msdyn_aibdatasetscontainer"));
    }

    @NavigationProperty(name="team_msdyn_aibfile")
    @JsonIgnore
    public Msdyn_aibfileCollectionRequest getTeam_msdyn_aibfile() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibfile"), RequestHelper.getValue(unmappedFields, "team_msdyn_aibfile"));
    }

    @NavigationProperty(name="team_msdyn_aibfileattacheddata")
    @JsonIgnore
    public Msdyn_aibfileattacheddataCollectionRequest getTeam_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibfileattacheddata"), RequestHelper.getValue(unmappedFields, "team_msdyn_aibfileattacheddata"));
    }

    @NavigationProperty(name="team_msdyn_aifptrainingdocument")
    @JsonIgnore
    public Msdyn_aifptrainingdocumentCollectionRequest getTeam_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("team_msdyn_aifptrainingdocument"), RequestHelper.getValue(unmappedFields, "team_msdyn_aifptrainingdocument"));
    }

    @NavigationProperty(name="team_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageCollectionRequest getTeam_msdyn_aiodimage() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "team_msdyn_aiodimage"));
    }

    @NavigationProperty(name="team_msdyn_aiodlabel")
    @JsonIgnore
    public Msdyn_aiodlabelCollectionRequest getTeam_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodlabel"), RequestHelper.getValue(unmappedFields, "team_msdyn_aiodlabel"));
    }

    @NavigationProperty(name="team_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxCollectionRequest getTeam_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "team_msdyn_aiodtrainingboundingbox"));
    }

    @NavigationProperty(name="team_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageCollectionRequest getTeam_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "team_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="team_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentCollectionRequest getTeam_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "team_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="team_msdyn_analysisjob")
    @JsonIgnore
    public Msdyn_analysisjobCollectionRequest getTeam_msdyn_analysisjob() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysisjob"), RequestHelper.getValue(unmappedFields, "team_msdyn_analysisjob"));
    }

    @NavigationProperty(name="team_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultCollectionRequest getTeam_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "team_msdyn_analysisresult"));
    }

    @NavigationProperty(name="team_msdyn_analysisresultdetail")
    @JsonIgnore
    public Msdyn_analysisresultdetailCollectionRequest getTeam_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysisresultdetail"), RequestHelper.getValue(unmappedFields, "team_msdyn_analysisresultdetail"));
    }

    @NavigationProperty(name="team_msdyn_solutionhealthrule")
    @JsonIgnore
    public Msdyn_solutionhealthruleCollectionRequest getTeam_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("team_msdyn_solutionhealthrule"), RequestHelper.getValue(unmappedFields, "team_msdyn_solutionhealthrule"));
    }

    @NavigationProperty(name="team_msdyn_solutionhealthruleargument")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentCollectionRequest getTeam_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("team_msdyn_solutionhealthruleargument"), RequestHelper.getValue(unmappedFields, "team_msdyn_solutionhealthruleargument"));
    }

    @NavigationProperty(name="team_ggw_event")
    @JsonIgnore
    public Ggw_eventCollectionRequest getTeam_ggw_event() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("team_ggw_event"), RequestHelper.getValue(unmappedFields, "team_ggw_event"));
    }

    @NavigationProperty(name="team_ggw_team")
    @JsonIgnore
    public Ggw_teamCollectionRequest getTeam_ggw_team() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("team_ggw_team"), RequestHelper.getValue(unmappedFields, "team_ggw_team"));
    }

    @NavigationProperty(name="team_ggw_crew")
    @JsonIgnore
    public Ggw_crewCollectionRequest getTeam_ggw_crew() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("team_ggw_crew"), RequestHelper.getValue(unmappedFields, "team_ggw_crew"));
    }

    @NavigationProperty(name="team_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationCollectionRequest getTeam_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("team_ggw_team_application"), RequestHelper.getValue(unmappedFields, "team_ggw_team_application"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Team put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Team _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Team _copy() {
        Team _x = new Team();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ownerid = ownerid;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.versionnumber = versionnumber;
        _x.yominame = yominame;
        _x._teamtemplateid_value = _teamtemplateid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.traversedpath = traversedpath;
        _x.organizationid = organizationid;
        _x.name = name;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.isdefault = isdefault;
        _x.exchangerate = exchangerate;
        _x.importsequencenumber = importsequencenumber;
        _x.systemmanaged = systemmanaged;
        _x.description = description;
        _x._createdby_value = _createdby_value;
        _x.emailaddress = emailaddress;
        _x.processid = processid;
        _x._businessunitid_value = _businessunitid_value;
        _x._queueid_value = _queueid_value;
        _x.modifiedon = modifiedon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.teamtype = teamtype;
        _x.stageid = stageid;
        _x.membershiptype = membershiptype;
        _x.createdon = createdon;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.azureactivedirectoryobjectid = azureactivedirectoryobjectid;
        _x._administratorid_value = _administratorid_value;
        _x.teamid = teamid;
        return _x;
    }

    @Action(name = "AddMembersTeam")
    @JsonIgnore
    public ActionRequestNoReturn addMembersTeam(List<Systemuser> members) {
        Preconditions.checkNotNull(members, "members cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Members", "Collection(Microsoft.Dynamics.CRM.systemuser)", members)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddMembersTeam"), _parameters);
    }

    @Action(name = "ConvertOwnerTeamToAccessTeam")
    @JsonIgnore
    public ActionRequestNoReturn convertOwnerTeamToAccessTeam() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ConvertOwnerTeamToAccessTeam"), _parameters);
    }

    @Action(name = "RemoveMembersTeam")
    @JsonIgnore
    public ActionRequestNoReturn removeMembersTeam(List<Systemuser> members) {
        Preconditions.checkNotNull(members, "members cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Members", "Collection(Microsoft.Dynamics.CRM.systemuser)", members)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveMembersTeam"), _parameters);
    }

    @Function(name = "RetrievePrincipalAccess")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessResponse> retrievePrincipalAccess(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAccess"), RetrievePrincipalAccessResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAccessInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessInfoResponse> retrievePrincipalAccessInfo(UUID objectId, String entityName) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAccessInfo"), RetrievePrincipalAccessInfoResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAttributePrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAttributePrivilegesResponse> retrievePrincipalAttributePrivileges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAttributePrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAttributePrivileges"), RetrievePrincipalAttributePrivilegesResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalSyncAttributeMappings")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalSyncAttributeMappingsResponse> retrievePrincipalSyncAttributeMappings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalSyncAttributeMappingsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalSyncAttributeMappings"), RetrievePrincipalSyncAttributeMappingsResponse.class, _parameters);
    }

    @Function(name = "RetrieveTeamPrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveTeamPrivilegesResponse> retrieveTeamPrivileges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveTeamPrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveTeamPrivileges"), RetrieveTeamPrivilegesResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Team[");
        b.append("ownerid=");
        b.append(this.ownerid);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("yominame=");
        b.append(this.yominame);
        b.append(", ");
        b.append("_teamtemplateid_value=");
        b.append(this._teamtemplateid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("systemmanaged=");
        b.append(this.systemmanaged);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("emailaddress=");
        b.append(this.emailaddress);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("_businessunitid_value=");
        b.append(this._businessunitid_value);
        b.append(", ");
        b.append("_queueid_value=");
        b.append(this._queueid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("teamtype=");
        b.append(this.teamtype);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("membershiptype=");
        b.append(this.membershiptype);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("azureactivedirectoryobjectid=");
        b.append(this.azureactivedirectoryobjectid);
        b.append(", ");
        b.append("_administratorid_value=");
        b.append(this._administratorid_value);
        b.append(", ");
        b.append("teamid=");
        b.append(this.teamid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
