package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.request.ActivitypointerRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "patternenddate", 
    "_objectid_value", 
    "dayofmonth", 
    "_createdby_value", 
    "_ownerid_value", 
    "monthofyear", 
    "instance", 
    "_owninguser_value", 
    "starttime", 
    "_modifiedby_value", 
    "isnthmonthly", 
    "isnthyearly", 
    "occurrences", 
    "duration", 
    "patternendtype", 
    "_owningteam_value", 
    "isregenerate", 
    "modifiedon", 
    "_createdonbehalfby_value", 
    "daysofweekmask", 
    "createdon", 
    "interval", 
    "effectivestartdate", 
    "endtime", 
    "versionnumber", 
    "_owningbusinessunit_value", 
    "patternstartdate", 
    "isweekdaypattern", 
    "firstdayofweek", 
    "recurrencepatterntype", 
    "_modifiedonbehalfby_value", 
    "ruleid", 
    "effectiveenddate"})
@JsonInclude(Include.NON_NULL)
public class Recurrencerule extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.recurrencerule";
    }

    @JsonProperty("patternenddate")
    protected OffsetDateTime patternenddate;

    @JsonProperty("_objectid_value")
    protected UUID _objectid_value;

    @JsonProperty("dayofmonth")
    protected Integer dayofmonth;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("monthofyear")
    protected Integer monthofyear;

    @JsonProperty("instance")
    protected Integer instance;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("starttime")
    protected OffsetDateTime starttime;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("isnthmonthly")
    protected Boolean isnthmonthly;

    @JsonProperty("isnthyearly")
    protected Boolean isnthyearly;

    @JsonProperty("occurrences")
    protected Integer occurrences;

    @JsonProperty("duration")
    protected Integer duration;

    @JsonProperty("patternendtype")
    protected Integer patternendtype;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("isregenerate")
    protected Boolean isregenerate;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("daysofweekmask")
    protected Integer daysofweekmask;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("interval")
    protected Integer interval;

    @JsonProperty("effectivestartdate")
    protected OffsetDateTime effectivestartdate;

    @JsonProperty("endtime")
    protected OffsetDateTime endtime;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("patternstartdate")
    protected OffsetDateTime patternstartdate;

    @JsonProperty("isweekdaypattern")
    protected Boolean isweekdaypattern;

    @JsonProperty("firstdayofweek")
    protected Integer firstdayofweek;

    @JsonProperty("recurrencepatterntype")
    protected Integer recurrencepatterntype;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("ruleid")
    protected UUID ruleid;

    @JsonProperty("effectiveenddate")
    protected OffsetDateTime effectiveenddate;

    protected Recurrencerule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRecurrencerule() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime patternenddate;
        private UUID _objectid_value;
        private Integer dayofmonth;
        private UUID _createdby_value;
        private UUID _ownerid_value;
        private Integer monthofyear;
        private Integer instance;
        private UUID _owninguser_value;
        private OffsetDateTime starttime;
        private UUID _modifiedby_value;
        private Boolean isnthmonthly;
        private Boolean isnthyearly;
        private Integer occurrences;
        private Integer duration;
        private Integer patternendtype;
        private UUID _owningteam_value;
        private Boolean isregenerate;
        private OffsetDateTime modifiedon;
        private UUID _createdonbehalfby_value;
        private Integer daysofweekmask;
        private OffsetDateTime createdon;
        private Integer interval;
        private OffsetDateTime effectivestartdate;
        private OffsetDateTime endtime;
        private Long versionnumber;
        private UUID _owningbusinessunit_value;
        private OffsetDateTime patternstartdate;
        private Boolean isweekdaypattern;
        private Integer firstdayofweek;
        private Integer recurrencepatterntype;
        private UUID _modifiedonbehalfby_value;
        private UUID ruleid;
        private OffsetDateTime effectiveenddate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder patternenddate(OffsetDateTime patternenddate) {
            this.patternenddate = patternenddate;
            this.changedFields = changedFields.add("patternenddate");
            return this;
        }

        public Builder _objectid_value(UUID _objectid_value) {
            this._objectid_value = _objectid_value;
            this.changedFields = changedFields.add("_objectid_value");
            return this;
        }

        public Builder dayofmonth(Integer dayofmonth) {
            this.dayofmonth = dayofmonth;
            this.changedFields = changedFields.add("dayofmonth");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder monthofyear(Integer monthofyear) {
            this.monthofyear = monthofyear;
            this.changedFields = changedFields.add("monthofyear");
            return this;
        }

        public Builder instance(Integer instance) {
            this.instance = instance;
            this.changedFields = changedFields.add("instance");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder starttime(OffsetDateTime starttime) {
            this.starttime = starttime;
            this.changedFields = changedFields.add("starttime");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder isnthmonthly(Boolean isnthmonthly) {
            this.isnthmonthly = isnthmonthly;
            this.changedFields = changedFields.add("isnthmonthly");
            return this;
        }

        public Builder isnthyearly(Boolean isnthyearly) {
            this.isnthyearly = isnthyearly;
            this.changedFields = changedFields.add("isnthyearly");
            return this;
        }

        public Builder occurrences(Integer occurrences) {
            this.occurrences = occurrences;
            this.changedFields = changedFields.add("occurrences");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder patternendtype(Integer patternendtype) {
            this.patternendtype = patternendtype;
            this.changedFields = changedFields.add("patternendtype");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder isregenerate(Boolean isregenerate) {
            this.isregenerate = isregenerate;
            this.changedFields = changedFields.add("isregenerate");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder daysofweekmask(Integer daysofweekmask) {
            this.daysofweekmask = daysofweekmask;
            this.changedFields = changedFields.add("daysofweekmask");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            this.changedFields = changedFields.add("interval");
            return this;
        }

        public Builder effectivestartdate(OffsetDateTime effectivestartdate) {
            this.effectivestartdate = effectivestartdate;
            this.changedFields = changedFields.add("effectivestartdate");
            return this;
        }

        public Builder endtime(OffsetDateTime endtime) {
            this.endtime = endtime;
            this.changedFields = changedFields.add("endtime");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder patternstartdate(OffsetDateTime patternstartdate) {
            this.patternstartdate = patternstartdate;
            this.changedFields = changedFields.add("patternstartdate");
            return this;
        }

        public Builder isweekdaypattern(Boolean isweekdaypattern) {
            this.isweekdaypattern = isweekdaypattern;
            this.changedFields = changedFields.add("isweekdaypattern");
            return this;
        }

        public Builder firstdayofweek(Integer firstdayofweek) {
            this.firstdayofweek = firstdayofweek;
            this.changedFields = changedFields.add("firstdayofweek");
            return this;
        }

        public Builder recurrencepatterntype(Integer recurrencepatterntype) {
            this.recurrencepatterntype = recurrencepatterntype;
            this.changedFields = changedFields.add("recurrencepatterntype");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder ruleid(UUID ruleid) {
            this.ruleid = ruleid;
            this.changedFields = changedFields.add("ruleid");
            return this;
        }

        public Builder effectiveenddate(OffsetDateTime effectiveenddate) {
            this.effectiveenddate = effectiveenddate;
            this.changedFields = changedFields.add("effectiveenddate");
            return this;
        }

        public Recurrencerule build() {
            Recurrencerule _x = new Recurrencerule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.recurrencerule";
            _x.patternenddate = patternenddate;
            _x._objectid_value = _objectid_value;
            _x.dayofmonth = dayofmonth;
            _x._createdby_value = _createdby_value;
            _x._ownerid_value = _ownerid_value;
            _x.monthofyear = monthofyear;
            _x.instance = instance;
            _x._owninguser_value = _owninguser_value;
            _x.starttime = starttime;
            _x._modifiedby_value = _modifiedby_value;
            _x.isnthmonthly = isnthmonthly;
            _x.isnthyearly = isnthyearly;
            _x.occurrences = occurrences;
            _x.duration = duration;
            _x.patternendtype = patternendtype;
            _x._owningteam_value = _owningteam_value;
            _x.isregenerate = isregenerate;
            _x.modifiedon = modifiedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.daysofweekmask = daysofweekmask;
            _x.createdon = createdon;
            _x.interval = interval;
            _x.effectivestartdate = effectivestartdate;
            _x.endtime = endtime;
            _x.versionnumber = versionnumber;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.patternstartdate = patternstartdate;
            _x.isweekdaypattern = isweekdaypattern;
            _x.firstdayofweek = firstdayofweek;
            _x.recurrencepatterntype = recurrencepatterntype;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.ruleid = ruleid;
            _x.effectiveenddate = effectiveenddate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ruleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ruleid, UUID.class));
        }
    }

    @Property(name="patternenddate")
    @JsonIgnore
    public Optional<OffsetDateTime> getPatternenddate() {
        return Optional.ofNullable(patternenddate);
    }

    public Recurrencerule withPatternenddate(OffsetDateTime patternenddate) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("patternenddate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.patternenddate = patternenddate;
        return _x;
    }

    @Property(name="_objectid_value")
    @JsonIgnore
    public Optional<UUID> get_objectid_value() {
        return Optional.ofNullable(_objectid_value);
    }

    public Recurrencerule with_objectid_value(UUID _objectid_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_objectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._objectid_value = _objectid_value;
        return _x;
    }

    @Property(name="dayofmonth")
    @JsonIgnore
    public Optional<Integer> getDayofmonth() {
        return Optional.ofNullable(dayofmonth);
    }

    public Recurrencerule withDayofmonth(Integer dayofmonth) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("dayofmonth");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.dayofmonth = dayofmonth;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Recurrencerule with_createdby_value(UUID _createdby_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Recurrencerule with_ownerid_value(UUID _ownerid_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="monthofyear")
    @JsonIgnore
    public Optional<Integer> getMonthofyear() {
        return Optional.ofNullable(monthofyear);
    }

    public Recurrencerule withMonthofyear(Integer monthofyear) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("monthofyear");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.monthofyear = monthofyear;
        return _x;
    }

    @Property(name="instance")
    @JsonIgnore
    public Optional<Integer> getInstance() {
        return Optional.ofNullable(instance);
    }

    public Recurrencerule withInstance(Integer instance) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("instance");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.instance = instance;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Recurrencerule with_owninguser_value(UUID _owninguser_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="starttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStarttime() {
        return Optional.ofNullable(starttime);
    }

    public Recurrencerule withStarttime(OffsetDateTime starttime) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("starttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.starttime = starttime;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Recurrencerule with_modifiedby_value(UUID _modifiedby_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="isnthmonthly")
    @JsonIgnore
    public Optional<Boolean> getIsnthmonthly() {
        return Optional.ofNullable(isnthmonthly);
    }

    public Recurrencerule withIsnthmonthly(Boolean isnthmonthly) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("isnthmonthly");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.isnthmonthly = isnthmonthly;
        return _x;
    }

    @Property(name="isnthyearly")
    @JsonIgnore
    public Optional<Boolean> getIsnthyearly() {
        return Optional.ofNullable(isnthyearly);
    }

    public Recurrencerule withIsnthyearly(Boolean isnthyearly) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("isnthyearly");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.isnthyearly = isnthyearly;
        return _x;
    }

    @Property(name="occurrences")
    @JsonIgnore
    public Optional<Integer> getOccurrences() {
        return Optional.ofNullable(occurrences);
    }

    public Recurrencerule withOccurrences(Integer occurrences) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("occurrences");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.occurrences = occurrences;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(duration);
    }

    public Recurrencerule withDuration(Integer duration) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.duration = duration;
        return _x;
    }

    @Property(name="patternendtype")
    @JsonIgnore
    public Optional<Integer> getPatternendtype() {
        return Optional.ofNullable(patternendtype);
    }

    public Recurrencerule withPatternendtype(Integer patternendtype) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("patternendtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.patternendtype = patternendtype;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Recurrencerule with_owningteam_value(UUID _owningteam_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="isregenerate")
    @JsonIgnore
    public Optional<Boolean> getIsregenerate() {
        return Optional.ofNullable(isregenerate);
    }

    public Recurrencerule withIsregenerate(Boolean isregenerate) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("isregenerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.isregenerate = isregenerate;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Recurrencerule withModifiedon(OffsetDateTime modifiedon) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Recurrencerule with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="daysofweekmask")
    @JsonIgnore
    public Optional<Integer> getDaysofweekmask() {
        return Optional.ofNullable(daysofweekmask);
    }

    public Recurrencerule withDaysofweekmask(Integer daysofweekmask) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("daysofweekmask");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.daysofweekmask = daysofweekmask;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Recurrencerule withCreatedon(OffsetDateTime createdon) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="interval")
    @JsonIgnore
    public Optional<Integer> getInterval() {
        return Optional.ofNullable(interval);
    }

    public Recurrencerule withInterval(Integer interval) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("interval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.interval = interval;
        return _x;
    }

    @Property(name="effectivestartdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectivestartdate() {
        return Optional.ofNullable(effectivestartdate);
    }

    public Recurrencerule withEffectivestartdate(OffsetDateTime effectivestartdate) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("effectivestartdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.effectivestartdate = effectivestartdate;
        return _x;
    }

    @Property(name="endtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndtime() {
        return Optional.ofNullable(endtime);
    }

    public Recurrencerule withEndtime(OffsetDateTime endtime) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("endtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.endtime = endtime;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Recurrencerule withVersionnumber(Long versionnumber) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Recurrencerule with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="patternstartdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getPatternstartdate() {
        return Optional.ofNullable(patternstartdate);
    }

    public Recurrencerule withPatternstartdate(OffsetDateTime patternstartdate) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("patternstartdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.patternstartdate = patternstartdate;
        return _x;
    }

    @Property(name="isweekdaypattern")
    @JsonIgnore
    public Optional<Boolean> getIsweekdaypattern() {
        return Optional.ofNullable(isweekdaypattern);
    }

    public Recurrencerule withIsweekdaypattern(Boolean isweekdaypattern) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("isweekdaypattern");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.isweekdaypattern = isweekdaypattern;
        return _x;
    }

    @Property(name="firstdayofweek")
    @JsonIgnore
    public Optional<Integer> getFirstdayofweek() {
        return Optional.ofNullable(firstdayofweek);
    }

    public Recurrencerule withFirstdayofweek(Integer firstdayofweek) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("firstdayofweek");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.firstdayofweek = firstdayofweek;
        return _x;
    }

    @Property(name="recurrencepatterntype")
    @JsonIgnore
    public Optional<Integer> getRecurrencepatterntype() {
        return Optional.ofNullable(recurrencepatterntype);
    }

    public Recurrencerule withRecurrencepatterntype(Integer recurrencepatterntype) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("recurrencepatterntype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.recurrencepatterntype = recurrencepatterntype;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Recurrencerule with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="ruleid")
    @JsonIgnore
    public Optional<UUID> getRuleid() {
        return Optional.ofNullable(ruleid);
    }

    public Recurrencerule withRuleid(UUID ruleid) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("ruleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.ruleid = ruleid;
        return _x;
    }

    @Property(name="effectiveenddate")
    @JsonIgnore
    public Optional<OffsetDateTime> getEffectiveenddate() {
        return Optional.ofNullable(effectiveenddate);
    }

    public Recurrencerule withEffectiveenddate(OffsetDateTime effectiveenddate) {
        Recurrencerule _x = _copy();
        _x.changedFields = changedFields.add("effectiveenddate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.recurrencerule");
        _x.effectiveenddate = effectiveenddate;
        return _x;
    }

    public Recurrencerule withUnmappedField(String name, Object value) {
        Recurrencerule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="recurrencerule_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterCollectionRequest getRecurrencerule_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("recurrencerule_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "recurrencerule_recurringappointmentmaster"));
    }

    @NavigationProperty(name="objectid")
    @JsonIgnore
    public ActivitypointerRequest getObjectid() {
        return new ActivitypointerRequest(contextPath.addSegment("objectid"), RequestHelper.getValue(unmappedFields, "objectid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recurrencerule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Recurrencerule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Recurrencerule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Recurrencerule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Recurrencerule _copy() {
        Recurrencerule _x = new Recurrencerule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.patternenddate = patternenddate;
        _x._objectid_value = _objectid_value;
        _x.dayofmonth = dayofmonth;
        _x._createdby_value = _createdby_value;
        _x._ownerid_value = _ownerid_value;
        _x.monthofyear = monthofyear;
        _x.instance = instance;
        _x._owninguser_value = _owninguser_value;
        _x.starttime = starttime;
        _x._modifiedby_value = _modifiedby_value;
        _x.isnthmonthly = isnthmonthly;
        _x.isnthyearly = isnthyearly;
        _x.occurrences = occurrences;
        _x.duration = duration;
        _x.patternendtype = patternendtype;
        _x._owningteam_value = _owningteam_value;
        _x.isregenerate = isregenerate;
        _x.modifiedon = modifiedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.daysofweekmask = daysofweekmask;
        _x.createdon = createdon;
        _x.interval = interval;
        _x.effectivestartdate = effectivestartdate;
        _x.endtime = endtime;
        _x.versionnumber = versionnumber;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.patternstartdate = patternstartdate;
        _x.isweekdaypattern = isweekdaypattern;
        _x.firstdayofweek = firstdayofweek;
        _x.recurrencepatterntype = recurrencepatterntype;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.ruleid = ruleid;
        _x.effectiveenddate = effectiveenddate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Recurrencerule[");
        b.append("patternenddate=");
        b.append(this.patternenddate);
        b.append(", ");
        b.append("_objectid_value=");
        b.append(this._objectid_value);
        b.append(", ");
        b.append("dayofmonth=");
        b.append(this.dayofmonth);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("monthofyear=");
        b.append(this.monthofyear);
        b.append(", ");
        b.append("instance=");
        b.append(this.instance);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("starttime=");
        b.append(this.starttime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("isnthmonthly=");
        b.append(this.isnthmonthly);
        b.append(", ");
        b.append("isnthyearly=");
        b.append(this.isnthyearly);
        b.append(", ");
        b.append("occurrences=");
        b.append(this.occurrences);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("patternendtype=");
        b.append(this.patternendtype);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("isregenerate=");
        b.append(this.isregenerate);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("daysofweekmask=");
        b.append(this.daysofweekmask);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("interval=");
        b.append(this.interval);
        b.append(", ");
        b.append("effectivestartdate=");
        b.append(this.effectivestartdate);
        b.append(", ");
        b.append("endtime=");
        b.append(this.endtime);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("patternstartdate=");
        b.append(this.patternstartdate);
        b.append(", ");
        b.append("isweekdaypattern=");
        b.append(this.isweekdaypattern);
        b.append(", ");
        b.append("firstdayofweek=");
        b.append(this.firstdayofweek);
        b.append(", ");
        b.append("recurrencepatterntype=");
        b.append(this.recurrencepatterntype);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("ruleid=");
        b.append(this.ruleid);
        b.append(", ");
        b.append("effectiveenddate=");
        b.append(this.effectiveenddate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
